/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.os.Bundle;
import android.support.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infobip.mobile.messaging.CustomAttributeValue;
import org.infobip.mobile.messaging.Installation;
import org.infobip.mobile.messaging.UserAttributes;
import org.infobip.mobile.messaging.UserIdentity;
import org.infobip.mobile.messaging.UserMapper;

public class User
extends UserAttributes {
    private String externalUserId;
    private Set<String> phones;
    private Set<String> emails;
    private List<Installation> installations;

    public User() {
    }

    public User(@Nullable UserAttributes userAttributes) {
        this.setUserAtts(userAttributes);
    }

    public User(UserIdentity userIdentity) {
        this.setUserIdentity(userIdentity);
    }

    public User(UserIdentity userIdentity, UserAttributes userAttributes) {
        this.setUserIdentity(userIdentity);
        this.setUserAtts(userAttributes);
    }

    private void setUserIdentity(UserIdentity userIdentity) {
        if (userIdentity.containsField("externalUserId")) {
            this.setExternalUserId(userIdentity.getExternalUserId());
        }
        if (userIdentity.containsField("emails")) {
            this.setEmails(userIdentity.getEmails());
        }
        if (userIdentity.containsField("phones")) {
            this.setPhones(userIdentity.getPhones());
        }
    }

    private void setUserAtts(@Nullable UserAttributes userAttributes) {
        if (userAttributes == null) {
            return;
        }
        if (userAttributes.containsField("birthday")) {
            this.setBirthdayString(userAttributes.getBirthdayString());
        }
        if (userAttributes.containsField("firstName")) {
            this.setFirstName(userAttributes.getFirstName());
        }
        if (userAttributes.containsField("lastName")) {
            this.setLastName(userAttributes.getLastName());
        }
        if (userAttributes.containsField("middleName")) {
            this.setMiddleName(userAttributes.getMiddleName());
        }
        if (userAttributes.containsField("gender")) {
            this.setGender(userAttributes.getGender());
        }
        if (userAttributes.containsField("tags")) {
            this.setTags(userAttributes.getTags());
        }
    }

    public User(String externalUserId, String firstName, String lastName, String middleName, UserAttributes.Gender gender, String birthday, Set<String> phones, Set<String> emails, Set<String> tags, List<Installation> installations, Map<String, CustomAttributeValue> customAttributes) {
        super(customAttributes);
        this.externalUserId = externalUserId;
        this.firstName = firstName;
        this.lastName = lastName;
        this.middleName = middleName;
        this.gender = gender;
        this.birthday = birthday;
        this.phones = phones;
        this.emails = emails;
        this.tags = tags;
        this.installations = installations;
    }

    public static User createFrom(Bundle bundle) {
        return UserMapper.fromBundle("org.infobip.mobile.messaging.user", bundle);
    }

    public String getExternalUserId() {
        return this.externalUserId;
    }

    public void setExternalUserId(String externalUserId) {
        this.externalUserId = externalUserId;
        this.setField("externalUserId", externalUserId);
    }

    public Set<String> getPhones() {
        return this.phones;
    }

    public void setPhones(Set<String> phones) {
        this.phones = phones;
        this.setField("phones", UserMapper.mapPhonesToBackend(phones));
    }

    public Set<String> getEmails() {
        return this.emails;
    }

    public void setEmails(Set<String> emails) {
        this.emails = emails;
        this.setField("emails", UserMapper.mapEmailsToBackend(emails));
    }

    public List<Installation> getInstallations() {
        return this.installations;
    }

    void setInstallations(List<Installation> installations) {
        this.installations = installations;
    }
}

