/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.cloud.firebase;

import android.support.annotation.NonNull;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import java.io.IOException;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.cloud.RegistrationTokenHandler;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.util.StringUtils;

public class FirebaseRegistrationTokenHandler
extends RegistrationTokenHandler {
    private static final String TAG = FirebaseRegistrationTokenHandler.class.getSimpleName();
    private final Broadcaster broadcaster;

    public FirebaseRegistrationTokenHandler(MobileMessagingCore mobileMessagingCore, Broadcaster broadcaster) {
        super(mobileMessagingCore);
        this.broadcaster = broadcaster;
    }

    @Override
    public void handleNewToken(String senderId, String token) {
        MobileMessagingLogger.v(TAG, (Object)"RECEIVED FCM TOKEN", token);
        this.broadcaster.tokenReceived(token);
        this.sendRegistrationToServer(token);
    }

    @Override
    public void cleanupToken(String senderId) {
        if (StringUtils.isBlank(senderId)) {
            return;
        }
        try {
            FirebaseInstanceId.getInstance().deleteToken(senderId, "FCM");
        }
        catch (IOException e) {
            MobileMessagingLogger.e(TAG, "Error while deleting token", e);
        }
    }

    @Override
    public void acquireNewToken(final String senderId) {
        FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<InstanceIdResult>(){

            public void onSuccess(InstanceIdResult instanceIdResult) {
                String token = instanceIdResult.getToken();
                if (StringUtils.isNotBlank(token) && StringUtils.isNotBlank(FirebaseRegistrationTokenHandler.this.mobileMessagingCore.getApplicationCode())) {
                    FirebaseRegistrationTokenHandler.this.handleNewToken(senderId, token);
                }
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                MobileMessagingLogger.e(TAG, "Error while acquiring token", e);
            }
        });
    }
}

