/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.interactive.notification;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.RemoteInput;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.dal.bundle.MessageBundleMapper;
import org.infobip.mobile.messaging.interactive.MobileInteractiveImpl;
import org.infobip.mobile.messaging.interactive.NotificationAction;
import org.infobip.mobile.messaging.interactive.NotificationCategory;
import org.infobip.mobile.messaging.interactive.dal.bundle.NotificationActionBundleMapper;
import org.infobip.mobile.messaging.interactive.dal.bundle.NotificationCategoryBundleMapper;
import org.infobip.mobile.messaging.interactive.notification.NotificationActionTapReceiver;
import org.infobip.mobile.messaging.notification.BaseNotificationHandler;
import org.infobip.mobile.messaging.notification.NotificationHandler;

public class InteractiveNotificationHandler
implements NotificationHandler {
    private final Context context;
    private final BaseNotificationHandler baseNotificationHandler;

    public InteractiveNotificationHandler(Context context) {
        this.context = context;
        this.baseNotificationHandler = new BaseNotificationHandler(context);
    }

    @Override
    public void displayNotification(Message message) {
        if (this.context == null) {
            return;
        }
        int notificationId = this.baseNotificationHandler.getNotificationId(message);
        NotificationCompat.Builder builder = this.getNotificationBuilder(message, notificationId);
        this.baseNotificationHandler.displayNotification(builder, message, notificationId);
    }

    @Override
    public void cancelAllNotifications() {
        this.baseNotificationHandler.cancelAllNotifications();
    }

    private NotificationCompat.Builder getNotificationBuilder(Message message, int notificationId) {
        NotificationCompat.Builder builder = this.baseNotificationHandler.createNotificationCompatBuilder(message);
        if (builder == null) {
            return null;
        }
        String category = message.getCategory();
        NotificationCategory triggeredNotificationCategory = MobileInteractiveImpl.getInstance(this.context).getNotificationCategory(category);
        this.setNotificationActions(builder, message, triggeredNotificationCategory, notificationId);
        return builder;
    }

    private void setNotificationActions(NotificationCompat.Builder notificationBuilder, Message message, NotificationCategory triggeredNotificationCategory, int notificationId) {
        NotificationAction[] notificationActions;
        if (triggeredNotificationCategory == null) {
            return;
        }
        for (NotificationAction notificationAction : notificationActions = triggeredNotificationCategory.getNotificationActions()) {
            PendingIntent pendingIntent = this.createActionTapPendingIntent(message, triggeredNotificationCategory, notificationAction, notificationId);
            notificationBuilder.addAction(this.createAndroidNotificationAction(notificationAction, pendingIntent));
        }
    }

    @NonNull
    private NotificationCompat.Action createAndroidNotificationAction(NotificationAction notificationAction, PendingIntent pendingIntent) {
        NotificationCompat.Action.Builder builder = new NotificationCompat.Action.Builder(notificationAction.getIcon(), (CharSequence)InteractiveNotificationHandler.notificationActionTitle(this.context, notificationAction), pendingIntent);
        if (notificationAction.hasInput()) {
            RemoteInput.Builder inputBuilder = new RemoteInput.Builder(notificationAction.getId());
            String inputPlaceholderText = InteractiveNotificationHandler.notificationActionInputPlaceholder(this.context, notificationAction);
            if (inputPlaceholderText != null) {
                inputBuilder.setLabel((CharSequence)inputPlaceholderText);
            }
            builder.addRemoteInput(inputBuilder.build());
        }
        return builder.build();
    }

    private static String notificationActionTitle(Context context, NotificationAction action) {
        return action.getTitleResourceId() != 0 ? context.getString(action.getTitleResourceId()) : action.getTitleText();
    }

    private static String notificationActionInputPlaceholder(Context context, NotificationAction action) {
        return action.getInputPlaceholderResourceId() != 0 ? context.getString(action.getInputPlaceholderResourceId()) : action.getInputPlaceholderText();
    }

    @NonNull
    private PendingIntent createActionTapPendingIntent(Message message, NotificationCategory notificationCategory, NotificationAction notificationAction, int notificationId) {
        Intent intent = new Intent(this.context, NotificationActionTapReceiver.class);
        intent.setAction(message.getMessageId() + notificationAction.getId());
        intent.putExtra("org.infobip.mobile.messaging.message", MessageBundleMapper.messageToBundle(message));
        intent.putExtra("org.infobip.mobile.messaging.notification.action.tapped", NotificationActionBundleMapper.notificationActionToBundle(notificationAction));
        intent.putExtra("org.infobip.mobile.messaging.notification.category.tapped", NotificationCategoryBundleMapper.notificationCategoryToBundle(notificationCategory));
        intent.putExtra("org.infobip.mobile.messaging.notification.id", notificationId);
        return PendingIntent.getBroadcast((Context)this.context, (int)notificationId, (Intent)intent, (int)0x10000000);
    }
}

