/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobileapi.events;

import android.support.annotation.NonNull;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infobip.mobile.messaging.CustomEvent;
import org.infobip.mobile.messaging.EventPropertiesMapper;
import org.infobip.mobile.messaging.api.appinstance.AppInstance;
import org.infobip.mobile.messaging.api.appinstance.UserCustomEventBody;
import org.infobip.mobile.messaging.api.appinstance.UserSessionEventBody;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.api.support.util.CollectionUtils;
import org.infobip.mobile.messaging.platform.Time;
import org.infobip.mobile.messaging.util.DateTimeUtil;
import org.infobip.mobile.messaging.util.StringUtils;

public class UserEventsRequestMapper {
    private static final JsonSerializer nullSerializer = new JsonSerializer(true, new JsonSerializer.ObjectAdapter[0]);

    public static String toJson(UserCustomEventBody.CustomEvent customEvent) {
        return nullSerializer.serialize((Object)customEvent);
    }

    public static UserCustomEventBody.CustomEvent fromJson(String json) {
        if (StringUtils.isBlank(json)) {
            return null;
        }
        return (UserCustomEventBody.CustomEvent)nullSerializer.deserialize(json, UserCustomEventBody.CustomEvent.class);
    }

    public static UserCustomEventBody createCustomEventRequest(CustomEvent customEvent) {
        Map<String, Object> payload = null;
        if (StringUtils.isBlank(customEvent.getDefinitionId())) {
            return null;
        }
        if (customEvent.getProperties() != null) {
            payload = EventPropertiesMapper.eventPropertiesToBackend(customEvent.getProperties());
        }
        UserCustomEventBody.CustomEvent customEventRequestBody = new UserCustomEventBody.CustomEvent(customEvent.getDefinitionId(), DateTimeUtil.dateToISO8601UTCString(Time.date()), payload);
        UserCustomEventBody.CustomEvent[] customEvents = new UserCustomEventBody.CustomEvent[]{customEventRequestBody};
        return new UserCustomEventBody(customEvents);
    }

    static UserSessionEventBody createUserSessionEventRequest(long sessionStartsMillis, String[] storedSessionBounds, AppInstance systemData) {
        HashMap<String, String> sessionBounds = UserEventsRequestMapper.getSessionBounds(storedSessionBounds);
        if (systemData == null) {
            return null;
        }
        Set<String> sessionStarts = UserEventsRequestMapper.getSessionStarts(sessionStartsMillis);
        return new UserSessionEventBody(systemData, sessionStarts, sessionBounds);
    }

    @NonNull
    public static HashMap<String, String> getSessionBounds(String[] storedSessionBounds) {
        HashMap<String, String> sessionBounds = new HashMap<String, String>();
        if (storedSessionBounds == null || storedSessionBounds.length == 0) {
            return sessionBounds;
        }
        for (String sessionBound : storedSessionBounds) {
            String[] splitSession = sessionBound.split("___");
            String sessionStart = splitSession[0];
            String sessionEnd = splitSession[1];
            sessionBounds.put(sessionStart, sessionEnd);
        }
        return sessionBounds;
    }

    @NonNull
    static Set<String> getSessionStarts(long sessionStartsMillis) {
        Set<String> sessionStarts = new HashSet<String>();
        if (sessionStartsMillis != 0L) {
            String sessionStartsDate = DateTimeUtil.dateToISO8601UTCString(new Date(sessionStartsMillis));
            sessionStarts = CollectionUtils.setOf((Object[])new String[]{sessionStartsDate});
        }
        return sessionStarts;
    }
}

