/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobileapi.events;

import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.CustomEvent;
import org.infobip.mobile.messaging.Installation;
import org.infobip.mobile.messaging.InstallationMapper;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.SystemData;
import org.infobip.mobile.messaging.api.appinstance.AppInstance;
import org.infobip.mobile.messaging.api.appinstance.MobileApiAppInstance;
import org.infobip.mobile.messaging.api.appinstance.UserCustomEventBody;
import org.infobip.mobile.messaging.api.appinstance.UserSessionEventBody;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobileapi.BatchReporter;
import org.infobip.mobile.messaging.mobileapi.InternalSdkError;
import org.infobip.mobile.messaging.mobileapi.MobileMessagingError;
import org.infobip.mobile.messaging.mobileapi.Result;
import org.infobip.mobile.messaging.mobileapi.common.MAsyncTask;
import org.infobip.mobile.messaging.mobileapi.common.MRetryPolicy;
import org.infobip.mobile.messaging.mobileapi.common.MRetryableTask;
import org.infobip.mobile.messaging.mobileapi.events.UserEventsRequestMapper;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.util.StringUtils;

public class UserEventsSynchronizer {
    private final MobileMessagingCore mobileMessagingCore;
    private final Broadcaster broadcaster;
    private final MobileApiAppInstance mobileApiAppInstance;
    private final Executor executor;
    private final MRetryPolicy policy;
    private final BatchReporter batchReporter;

    public UserEventsSynchronizer(MobileMessagingCore mobileMessagingCore, Broadcaster broadcaster, MobileApiAppInstance mobileApiAppInstance, MRetryPolicy policy, Executor executor, BatchReporter batchReporter) {
        this.mobileMessagingCore = mobileMessagingCore;
        this.broadcaster = broadcaster;
        this.mobileApiAppInstance = mobileApiAppInstance;
        this.policy = policy;
        this.executor = executor;
        this.batchReporter = batchReporter;
    }

    public void reportSessions() {
        AppInstance systemData;
        if (this.mobileMessagingCore.isDepersonalizeInProgress()) {
            MobileMessagingLogger.w("Depersonalization is in progress, will report user session later");
            return;
        }
        if (StringUtils.isBlank(this.mobileMessagingCore.getPushRegistrationId())) {
            MobileMessagingLogger.w("Registration not available yet, will report user session later");
            return;
        }
        final long sessionStartsMillis = this.mobileMessagingCore.getActiveSessionStartTime();
        long lastReportedSessionStartTime = this.mobileMessagingCore.getLastReportedActiveSessionStartTime();
        final String[] storedSessionBounds = this.mobileMessagingCore.getStoredSessionBounds();
        final UserSessionEventBody userSessionEventBody = UserEventsRequestMapper.createUserSessionEventRequest(sessionStartsMillis, storedSessionBounds, systemData = this.getSystemDataForBackend());
        if (userSessionEventBody == null || sessionStartsMillis == lastReportedSessionStartTime && userSessionEventBody.getSessionBounds().size() == 0) {
            return;
        }
        new MRetryableTask<Void, Void>(){

            public Void run(Void[] voids) {
                MobileMessagingLogger.v("USER SESSION REPORT >>>", userSessionEventBody);
                UserEventsSynchronizer.this.mobileApiAppInstance.sendUserSessionReport(UserEventsSynchronizer.this.mobileMessagingCore.getPushRegistrationId(), userSessionEventBody);
                return null;
            }

            @Override
            public void after(Void aVoid) {
                MobileMessagingLogger.v("USER SESSION REPORT DONE <<<");
                UserEventsSynchronizer.this.mobileMessagingCore.setUserSessionsReported(storedSessionBounds, sessionStartsMillis);
                UserEventsSynchronizer.this.broadcaster.userSessionsReported();
            }

            @Override
            public void error(Throwable error) {
                MobileMessagingLogger.v("USER SESSION REPORT ERROR <<<", error);
                MobileMessagingError mobileMessagingError = MobileMessagingError.createFrom(error);
                UserEventsSynchronizer.this.mobileMessagingCore.handleNoRegistrationError(mobileMessagingError);
            }
        }.retryWith(this.policy).execute(this.executor, (IN[])new Void[0]);
    }

    private AppInstance getSystemDataForBackend() {
        SystemData systemDataForReport = this.mobileMessagingCore.systemDataForReport(true);
        if (systemDataForReport == null) {
            return null;
        }
        Installation installation = this.mobileMessagingCore.populateInstallationWithSystemData(systemDataForReport, new Installation());
        return InstallationMapper.toBackend(installation);
    }

    public void reportCustomEvent(final CustomEvent customEvent, final MobileMessaging.ResultListener<CustomEvent> listener) {
        if (this.mobileMessagingCore.isDepersonalizeInProgress()) {
            MobileMessagingLogger.w("Depersonalization is in progress, will report custom event later");
            if (listener != null) {
                listener.onResult(new Result<CustomEvent, MobileMessagingError>(customEvent, InternalSdkError.DEPERSONALIZATION_IN_PROGRESS.getError()));
            }
            return;
        }
        if (StringUtils.isBlank(this.mobileMessagingCore.getPushRegistrationId())) {
            MobileMessagingLogger.w("Registration not available yet, not reporting provided custom event");
            if (listener != null) {
                listener.onResult(new Result<CustomEvent, MobileMessagingError>(customEvent, InternalSdkError.NO_VALID_REGISTRATION.getError()));
            }
            return;
        }
        final UserCustomEventBody userCustomEventBody = UserEventsRequestMapper.createCustomEventRequest(customEvent);
        if (userCustomEventBody == null) {
            MobileMessagingLogger.w("Attempt to save empty custom event, will do nothing");
            if (listener != null) {
                listener.onResult(new Result<CustomEvent, MobileMessagingError>(customEvent, InternalSdkError.ERROR_SAVING_EMPTY_OBJECT.getError()));
            }
            return;
        }
        new MAsyncTask<Void, Void>(){

            public Void run(Void[] voids) {
                MobileMessagingLogger.v("CUSTOM EVENT REPORT >>>", userCustomEventBody);
                UserEventsSynchronizer.this.mobileApiAppInstance.sendUserCustomEvents(UserEventsSynchronizer.this.mobileMessagingCore.getPushRegistrationId(), true, userCustomEventBody);
                return null;
            }

            @Override
            public void after(Void aVoid) {
                MobileMessagingLogger.v("CUSTOM EVENT REPORT DONE <<<");
                UserEventsSynchronizer.this.broadcaster.customEventsReported();
                if (listener != null) {
                    listener.onResult(new Result(customEvent));
                }
            }

            @Override
            public void error(Throwable error) {
                MobileMessagingLogger.v("CUSTOM EVENT REPORT ERROR <<<", error);
                MobileMessagingError mobileMessagingError = MobileMessagingError.createFrom(error);
                UserEventsSynchronizer.this.mobileMessagingCore.handleNoRegistrationError(mobileMessagingError);
                UserEventsSynchronizer.this.broadcaster.error(mobileMessagingError);
                if (listener != null) {
                    listener.onResult(new Result<CustomEvent, MobileMessagingError>(customEvent, mobileMessagingError));
                }
            }
        }.execute(this.executor, (IN[])new Void[0]);
    }

    public void reportCustomEvents() {
        if (StringUtils.isBlank(this.mobileMessagingCore.getPushRegistrationId())) {
            MobileMessagingLogger.w("Registration not available yet, will report custom event later");
            return;
        }
        this.batchReporter.put(new Runnable(){

            @Override
            public void run() {
                new MAsyncTask<Void, Void>(){

                    public Void run(Void[] voids) {
                        UserCustomEventBody userCustomEventBody = new UserCustomEventBody(UserEventsSynchronizer.this.mobileMessagingCore.getUnreportedUserCustomEvents());
                        MobileMessagingLogger.v("CUSTOM EVENT REPORT >>>", userCustomEventBody);
                        UserEventsSynchronizer.this.mobileApiAppInstance.sendUserCustomEvents(UserEventsSynchronizer.this.mobileMessagingCore.getPushRegistrationId(), false, userCustomEventBody);
                        return null;
                    }

                    @Override
                    public void after(Void aVoid) {
                        MobileMessagingLogger.v("CUSTOM EVENT REPORT DONE <<<");
                        UserEventsSynchronizer.this.mobileMessagingCore.setUserCustomEventsReported();
                        UserEventsSynchronizer.this.broadcaster.customEventsReported();
                    }

                    @Override
                    public void error(Throwable error) {
                        MobileMessagingLogger.v("CUSTOM EVENT REPORT ERROR <<<", error);
                        MobileMessagingError mobileMessagingError = MobileMessagingError.createFrom(error);
                        UserEventsSynchronizer.this.mobileMessagingCore.handleNoRegistrationError(mobileMessagingError);
                        UserEventsSynchronizer.this.broadcaster.error(mobileMessagingError);
                    }
                }.execute(UserEventsSynchronizer.this.executor, (IN[])new Void[0]);
            }
        });
    }
}

