/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobileapi.seen;

import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.messages.MobileApiMessages;
import org.infobip.mobile.messaging.api.messages.SeenMessages;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobileapi.BatchReporter;
import org.infobip.mobile.messaging.mobileapi.InternalSdkError;
import org.infobip.mobile.messaging.mobileapi.MobileMessagingError;
import org.infobip.mobile.messaging.mobileapi.common.MAsyncTask;
import org.infobip.mobile.messaging.mobileapi.seen.SeenMessagesMapper;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;
import org.infobip.mobile.messaging.util.StringUtils;

public class SeenStatusReporter {
    private final MobileMessagingCore mobileMessagingCore;
    private final MobileMessagingStats stats;
    private final Executor executor;
    private final Broadcaster broadcaster;
    private final MobileApiMessages mobileApiMessages;
    private final BatchReporter batchReporter;

    public SeenStatusReporter(MobileMessagingCore mobileMessagingCore, MobileMessagingStats stats, Executor executor, Broadcaster broadcaster, MobileApiMessages mobileApiMessages, BatchReporter batchReporter) {
        this.mobileMessagingCore = mobileMessagingCore;
        this.stats = stats;
        this.executor = executor;
        this.broadcaster = broadcaster;
        this.mobileApiMessages = mobileApiMessages;
        this.batchReporter = batchReporter;
    }

    public void sync() {
        String[] unreportedSeenMessageIds = this.mobileMessagingCore.getUnreportedSeenMessageIds();
        if (unreportedSeenMessageIds.length == 0) {
            return;
        }
        this.batchReporter.put(new Runnable(){

            @Override
            public void run() {
                new MAsyncTask<Void, String[]>(){

                    public String[] run(Void[] voids) {
                        if (StringUtils.isBlank(SeenStatusReporter.this.mobileMessagingCore.getPushRegistrationId())) {
                            MobileMessagingLogger.w("Can't report seen status without valid registration");
                            throw InternalSdkError.NO_VALID_REGISTRATION.getException();
                        }
                        String[] messageIDs = SeenStatusReporter.this.mobileMessagingCore.getUnreportedSeenMessageIds();
                        if (messageIDs.length == 0) {
                            return messageIDs;
                        }
                        SeenMessages seenMessages = SeenMessagesMapper.fromMessageIds(messageIDs);
                        MobileMessagingLogger.v("SEEN >>>", seenMessages);
                        SeenStatusReporter.this.mobileApiMessages.reportSeen(seenMessages);
                        MobileMessagingLogger.v("SEEN DONE <<<");
                        SeenStatusReporter.this.mobileMessagingCore.removeUnreportedSeenMessageIds(messageIDs);
                        return messageIDs;
                    }

                    @Override
                    public void after(String[] messageIdsWithTimestamp) {
                        String[] seenMessageIdsFromReports = SeenStatusReporter.this.mobileMessagingCore.getSeenMessageIdsFromReports(messageIdsWithTimestamp).toArray(new String[0]);
                        SeenStatusReporter.this.broadcaster.seenStatusReported(seenMessageIdsFromReports);
                    }

                    @Override
                    public void error(Throwable error) {
                        SeenStatusReporter.this.mobileMessagingCore.setLastHttpException(error);
                        MobileMessagingLogger.e("Error reporting seen status!");
                        SeenStatusReporter.this.stats.reportError(MobileMessagingStatsError.SEEN_REPORTING_ERROR);
                        SeenStatusReporter.this.broadcaster.error(MobileMessagingError.createFrom(error));
                    }
                }.execute(SeenStatusReporter.this.executor, (IN[])new Void[0]);
            }
        });
    }
}

