/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import android.support.annotation.NonNull;
import android.util.Base64;
import android.util.Log;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.util.StringUtils;

public class Cryptor {
    private static final String AES_ALGO = "AES/ECB/PKCS5Padding";
    private Key key = null;

    public Cryptor(@NonNull String keySecret) {
        MessageDigest sha;
        byte[] keyBytes = keySecret.getBytes();
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            MobileMessagingLogger.d(Log.getStackTraceString((Throwable)e));
            return;
        }
        keyBytes = sha.digest(keyBytes);
        keyBytes = Arrays.copyOf(keyBytes, 16);
        this.key = new SecretKeySpec(keyBytes, AES_ALGO);
    }

    public String encrypt(String data) {
        if (StringUtils.isBlank(data)) {
            return null;
        }
        byte[] encoded = this.encodeAES128(data.getBytes());
        return Base64.encodeToString((byte[])encoded, (int)2);
    }

    public String decrypt(String encryptedBase64Data) {
        if (StringUtils.isBlank(encryptedBase64Data)) {
            return null;
        }
        byte[] encrypted = Base64.decode((String)encryptedBase64Data, (int)0);
        byte[] decrypted = this.decodeAES128(encrypted);
        if (decrypted == null) {
            return null;
        }
        return new String(decrypted);
    }

    private byte[] encodeAES128(byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGO);
            cipher.init(1, this.key);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            MobileMessagingLogger.d(Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    private byte[] decodeAES128(byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGO);
            cipher.init(2, this.key);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            MobileMessagingLogger.d(Log.getStackTraceString((Throwable)e));
            return null;
        }
    }
}

