/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import android.annotation.SuppressLint;
import android.app.KeyguardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.util.DateTimeUtil;

public class DeviceInformation {
    private DeviceInformation() {
    }

    @SuppressLint(value={"HardwareIds"})
    static String getDeviceID(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public static String getDeviceModel() {
        return Build.MODEL;
    }

    public static String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    public static boolean isDeviceSecure(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            KeyguardManager keyguardMgr = (KeyguardManager)context.getSystemService("keyguard");
            return keyguardMgr != null && keyguardMgr.isDeviceSecure();
        }
        try {
            String LOCKSCREEN_UTILS_CLASSNAME = "com.android.internal.widget.LockPatternUtils";
            Class<?> lockUtilsClass = Class.forName(LOCKSCREEN_UTILS_CLASSNAME);
            Object lockUtils = lockUtilsClass.getConstructor(Context.class).newInstance(context);
            Method method = lockUtilsClass.getMethod("getActivePasswordQuality", new Class[0]);
            Integer lockProtectionLevel = (Integer)method.invoke(lockUtils, new Object[0]);
            return lockProtectionLevel >= 65536;
        }
        catch (InvocationTargetException LOCKSCREEN_UTILS_CLASSNAME) {
        }
        catch (Exception e) {
            MobileMessagingLogger.e("Error detecting whether screen lock is disabled: " + e);
        }
        return false;
    }

    public static String getDeviceTimeZoneOffset() {
        return DateTimeUtil.getGMTTimeZoneOffset();
    }
}

