/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import android.content.Context;
import org.infobip.mobile.messaging.util.MissingAndroidResourceException;
import org.infobip.mobile.messaging.util.StringUtils;

public abstract class ResourceLoader {
    private ResourceLoader() {
    }

    public static int loadResourceByName(Context context, String resourceGroup, String resourceName) {
        try {
            return context.getResources().getIdentifier(resourceName, resourceGroup, context.getApplicationContext().getPackageName());
        }
        catch (Exception e) {
            String className = context.getApplicationContext().getPackageName() + ".R$" + resourceGroup;
            throw new MissingAndroidResourceException("Can't load resource: " + resourceName, className, resourceName, e);
        }
    }

    public static String loadStringResourceByName(Context context, String resourceName) {
        String className;
        int resource = 0;
        try {
            resource = ResourceLoader.loadResourceByName(context, "string", resourceName);
        }
        catch (MissingAndroidResourceException missingAndroidResourceException) {
            // empty catch block
        }
        if (resource > 0 && StringUtils.isNotBlank(className = context.getResources().getString(resource))) {
            return className;
        }
        return null;
    }
}

