/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import java.lang.reflect.Field;
import java.util.Locale;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;

public class SystemInformation {
    private static String systemName = null;
    private static String androidABI = null;
    private static String deviceName = null;

    private SystemInformation() {
    }

    public static String getAndroidSystemName() {
        Field[] fields;
        if (systemName != null) {
            return systemName;
        }
        for (Field field : fields = Build.VERSION_CODES.class.getFields()) {
            String fieldName = field.getName();
            int fieldValue = -1;
            try {
                fieldValue = field.getInt(new Object());
            }
            catch (IllegalAccessException | IllegalArgumentException | NullPointerException e) {
                MobileMessagingLogger.d(Log.getStackTraceString((Throwable)e));
            }
            if (fieldValue != Build.VERSION.SDK_INT) continue;
            systemName = fieldName;
        }
        return systemName;
    }

    public static String getAndroidSystemABI() {
        if (androidABI != null) {
            return androidABI;
        }
        androidABI = Build.VERSION.SDK_INT < 21 ? Build.CPU_ABI : Build.SUPPORTED_ABIS[0];
        return androidABI;
    }

    public static String getAndroidSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getAndroidSystemLanguage() {
        return Locale.getDefault().getLanguage();
    }

    @SuppressLint(value={"InlinedApi"})
    public static String getAndroidDeviceName(Context context) {
        if (deviceName != null) {
            return deviceName;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            String deviceNameKey = Build.VERSION.SDK_INT >= 25 ? "device_name" : "device_name";
            deviceName = Settings.Global.getString((ContentResolver)context.getContentResolver(), (String)deviceNameKey);
        }
        return deviceName;
    }
}

