/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.api.support.http.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class JsonSerializer {
    private final Gson gson;

    public JsonSerializer() {
        this.gson = new GsonBuilder().serializeNulls().create();
    }

    public JsonSerializer(boolean serializeNulls, ObjectAdapter ... adapters) {
        GsonBuilder builder = new GsonBuilder();
        if (serializeNulls) {
            builder = builder.serializeNulls();
        }
        if (adapters.length > 0) {
            for (ObjectAdapter adapter : adapters) {
                builder.registerTypeHierarchyAdapter(adapter.getCls(), (Object)new CustomTypeAdapter(adapter));
            }
        }
        this.gson = builder.create();
    }

    public <T> T deserialize(String s, Class<T> type) {
        return (T)this.gson.fromJson(s, type);
    }

    public <T> String serialize(T t) {
        return this.gson.toJson(t);
    }

    private class CustomTypeAdapter
    extends TypeAdapter<Object> {
        private final ObjectAdapter adapter;

        CustomTypeAdapter(ObjectAdapter adapter) {
            this.adapter = adapter;
        }

        public void write(JsonWriter out, Object value) throws IOException {
            out.jsonValue(this.adapter.serialize(value));
        }

        public Object read(JsonReader in) throws IOException {
            JsonElement element = new JsonParser().parse(in);
            return this.adapter.deserialize(element.toString());
        }
    }

    public static interface ObjectAdapter<T> {
        public Class<T> getCls();

        public T deserialize(String var1);

        public String serialize(T var1);
    }
}

