/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.api.support.http.client;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.infobip.mobile.messaging.api.support.ApiBackendException;
import org.infobip.mobile.messaging.api.support.ApiBackendExceptionWithContent;
import org.infobip.mobile.messaging.api.support.ApiException;
import org.infobip.mobile.messaging.api.support.ApiIOException;
import org.infobip.mobile.messaging.api.support.Tuple;
import org.infobip.mobile.messaging.api.support.http.client.ApiClient;
import org.infobip.mobile.messaging.api.support.http.client.HttpMethod;
import org.infobip.mobile.messaging.api.support.http.client.model.ApiResponse;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.api.support.util.StreamUtils;
import org.infobip.mobile.messaging.api.support.util.StringUtils;

public class DefaultApiClient
implements ApiClient {
    public static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    public static final int DEFAULT_READ_TIMEOUT = 60000;
    public static final JsonSerializer JSON_SERIALIZER = new JsonSerializer();
    private final int connectTimeout;
    private final int readTimeout;
    private final String libraryVersion;
    private final String[] userAgentAdditions;
    private String userAgent;

    public DefaultApiClient() {
        this(5000, 60000, null, null, null, null);
    }

    public DefaultApiClient(int connectTimeout, int readTimeout, String libraryVersion, String ... userAgentAdditions) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.libraryVersion = libraryVersion;
        this.userAgentAdditions = userAgentAdditions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <B, R> R execute(HttpMethod method, String uri, String apiKey, Tuple<String, String> credentials, Map<String, Collection<Object>> queryParams, Map<String, Collection<Object>> headers, B body, Class<R> responseType) {
        ApiResponse apiResponse;
        int responseCode;
        HttpURLConnection urlConnection = null;
        try {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Collection<Object>> entry : queryParams.entrySet()) {
                this.appendValue(sb, entry);
            }
            urlConnection = (HttpURLConnection)new URL(uri + sb.toString()).openConnection();
            urlConnection.setRequestMethod(method.name());
            urlConnection.setUseCaches(false);
            if (method != HttpMethod.GET) {
                urlConnection.setDoOutput(true);
            }
            urlConnection.setDoInput(true);
            urlConnection.setConnectTimeout(this.connectTimeout);
            urlConnection.setReadTimeout(this.readTimeout);
            if (null != headers) {
                for (Map.Entry<String, Collection<Object>> entry : headers.entrySet()) {
                    String key;
                    Collection<Object> value = entry.getValue();
                    if (null == value || value.isEmpty() || (key = entry.getKey().trim()).equalsIgnoreCase("Content-Length")) continue;
                    for (Object v : value) {
                        if (v == null) continue;
                        urlConnection.setRequestProperty(key, v.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            if (!(e instanceof ApiIOException)) throw new ApiIOException("-4", "Can't access URI: " + uri, e);
            throw (ApiIOException)e;
        }
        if (StringUtils.isNotBlank(apiKey)) {
            urlConnection.setRequestProperty("Authorization", "App " + apiKey);
        } else if (credentials != null && StringUtils.isNotBlank(credentials.getLeft()) && StringUtils.isNotBlank(credentials.getRight())) {
            String basicApiKey = new String(Base64.encodeBase64((byte[])(credentials.getLeft() + ":" + credentials.getRight()).getBytes()));
            urlConnection.setRequestProperty("Authorization", "Basic " + basicApiKey);
        }
        urlConnection.setRequestProperty("Accept", "application/json");
        String userAgent = urlConnection.getRequestProperty("User-Agent");
        if (null == userAgent) {
            urlConnection.setRequestProperty("User-Agent", this.getUserAgent());
        }
        if (null != body) {
            byte[] bytes = JSON_SERIALIZER.serialize(body).getBytes("UTF-8");
            urlConnection.setRequestProperty("Content-Length", "" + Long.toString(bytes.length));
            urlConnection.setRequestProperty("Content-Type", "application/json");
            BufferedOutputStream outputStream = null;
            try {
                outputStream = new BufferedOutputStream(urlConnection.getOutputStream());
                ((OutputStream)outputStream).write(bytes);
                ((OutputStream)outputStream).flush();
            }
            catch (Throwable throwable) {
                StreamUtils.closeSafely(outputStream);
                throw throwable;
            }
            StreamUtils.closeSafely(outputStream);
        }
        if ((responseCode = urlConnection.getResponseCode()) >= 400) {
            Tuple<String, String> tuple;
            apiResponse = new ApiResponse("-1", "Unknown error");
            if (urlConnection.getContentLength() > 0) {
                InputStream inputStream = urlConnection.getErrorStream();
                String s = StreamUtils.readToString(inputStream, "UTF-8", Long.parseLong(urlConnection.getHeaderField("Content-Length")));
                apiResponse = JSON_SERIALIZER.deserialize(s, ApiResponse.class);
            }
            if (responseCode >= 500) {
                tuple = this.safeGetErrorInfo(apiResponse, "-2", "Unknown API backend error");
                throw new ApiBackendException(tuple.getLeft(), tuple.getRight());
            }
            tuple = this.safeGetErrorInfo(apiResponse, "-3", "Unknown API error");
            throw new ApiException(tuple.getLeft(), tuple.getRight());
        }
        if (urlConnection.getContentLength() <= 0) {
            apiResponse = null;
            return (R)apiResponse;
        }
        if (Void.class.equals(responseType) || Void.TYPE.equals(responseType)) {
            apiResponse = null;
            return (R)apiResponse;
        }
        InputStream inputStream = urlConnection.getInputStream();
        String s = StreamUtils.readToString(inputStream, "UTF-8", Long.parseLong(urlConnection.getHeaderField("Content-Length")));
        R response = JSON_SERIALIZER.deserialize(s, responseType);
        ApiResponse apiResponse2 = JSON_SERIALIZER.deserialize(s, ApiResponse.class);
        if (apiResponse2.getRequestError() != null) {
            Tuple<String, String> tuple = this.safeGetErrorInfo(apiResponse2, "-2", "Unknown API backend error");
            throw new ApiBackendExceptionWithContent(tuple.getLeft(), tuple.getRight(), response);
        }
        R r = response;
        return r;
        finally {
            if (null != urlConnection) {
                try {
                    urlConnection.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getUserAgent() {
        if (null != this.userAgent) {
            return this.userAgent;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Infobip Mobile API Client");
        if (StringUtils.isNotBlank(this.libraryVersion)) {
            sb.append("/").append(this.libraryVersion);
        }
        sb.append("(");
        if (null != this.userAgentAdditions) {
            sb.append(StringUtils.join(";", this.userAgentAdditions));
        }
        sb.append(")");
        this.userAgent = sb.toString();
        return this.userAgent;
    }

    private Tuple<String, String> safeGetErrorInfo(ApiResponse apiResponse, String code, String message) {
        if (null == apiResponse) {
            return new Tuple<String, String>(code, message);
        }
        if (null == apiResponse.getRequestError()) {
            return new Tuple<String, String>(code, message);
        }
        if (null == apiResponse.getRequestError().getServiceException()) {
            return new Tuple<String, String>(code, message);
        }
        return new Tuple<String, String>(apiResponse.getRequestError().getServiceException().getMessageId(), apiResponse.getRequestError().getServiceException().getText());
    }

    private void appendValue(StringBuilder sb, Map.Entry<String, Collection<Object>> entry) throws UnsupportedEncodingException {
        if (null == entry) {
            return;
        }
        Collection<Object> value = entry.getValue();
        if (null == value || value.isEmpty()) {
            return;
        }
        for (Object v : value) {
            String s = v.toString();
            if (StringUtils.isBlank(s)) {
                s = "";
            }
            sb.append(sb.length() == 0 ? "?" : "&").append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(s, "UTF-8"));
        }
    }

    public static enum ErrorCode {
        UNKNOWN_ERROR("-1"),
        UNKNOWN_API_BACKEND_ERROR("-2"),
        UNKNOWN_API_ERROR("-3"),
        API_IO_ERROR("-4");

        private final String value;

        private ErrorCode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

