/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.api.shaded.google.gson;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.infobip.mobile.messaging.api.shaded.google.gson.JsonElement;
import org.infobip.mobile.messaging.api.shaded.google.gson.JsonIOException;
import org.infobip.mobile.messaging.api.shaded.google.gson.JsonParseException;
import org.infobip.mobile.messaging.api.shaded.google.gson.JsonSyntaxException;
import org.infobip.mobile.messaging.api.shaded.google.gson.internal.Streams;
import org.infobip.mobile.messaging.api.shaded.google.gson.stream.JsonReader;
import org.infobip.mobile.messaging.api.shaded.google.gson.stream.JsonToken;
import org.infobip.mobile.messaging.api.shaded.google.gson.stream.MalformedJsonException;

public final class JsonParser {
    public JsonElement parse(String json) throws JsonSyntaxException {
        return this.parse(new StringReader(json));
    }

    public JsonElement parse(Reader json) throws JsonIOException, JsonSyntaxException {
        try {
            JsonReader jsonReader = new JsonReader(json);
            JsonElement element = this.parse(jsonReader);
            if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return element;
        }
        catch (MalformedJsonException e) {
            throw new JsonSyntaxException(e);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException(e);
        }
    }

    public JsonElement parse(JsonReader json) throws JsonIOException, JsonSyntaxException {
        boolean lenient = json.isLenient();
        json.setLenient(true);
        try {
            JsonElement jsonElement = Streams.parse(json);
            return jsonElement;
        }
        catch (StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", e);
        }
        catch (OutOfMemoryError e) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", e);
        }
        finally {
            json.setLenient(lenient);
        }
    }
}

