/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.api.support.http.client;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import org.infobip.mobile.messaging.api.support.ApiBackendException;
import org.infobip.mobile.messaging.api.support.ApiBackendExceptionWithContent;
import org.infobip.mobile.messaging.api.support.ApiException;
import org.infobip.mobile.messaging.api.support.ApiIOException;
import org.infobip.mobile.messaging.api.support.Tuple;
import org.infobip.mobile.messaging.api.support.http.client.ApiClient;
import org.infobip.mobile.messaging.api.support.http.client.HttpMethod;
import org.infobip.mobile.messaging.api.support.http.client.Logger;
import org.infobip.mobile.messaging.api.support.http.client.Request;
import org.infobip.mobile.messaging.api.support.http.client.RequestInterceptor;
import org.infobip.mobile.messaging.api.support.http.client.ResponsePreProcessor;
import org.infobip.mobile.messaging.api.support.http.client.UntrustedSSLHelper;
import org.infobip.mobile.messaging.api.support.http.client.model.ApiResponse;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.api.support.util.Base64Encoder;
import org.infobip.mobile.messaging.api.support.util.StreamUtils;
import org.infobip.mobile.messaging.api.support.util.StringUtils;

public class DefaultApiClient
implements ApiClient {
    public static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    public static final int DEFAULT_READ_TIMEOUT = 60000;
    public static final JsonSerializer JSON_SERIALIZER = new JsonSerializer();
    private static final JsonSerializer JSON_SERIALIZER_WITH_NULLS = new JsonSerializer(true, new JsonSerializer.ObjectAdapter[0]);
    private final int connectTimeout;
    private final int readTimeout;
    private final String libraryVersion;
    private final String[] userAgentAdditions;
    private final RequestInterceptor[] requestInterceptors;
    private final ResponsePreProcessor[] responsePreProcessors;
    private final Logger logger;
    private final boolean allowUntrustedSSLOnError;
    private String userAgent;

    public DefaultApiClient() {
        this(5000, 60000, null, new RequestInterceptor[0], new ResponsePreProcessor[0], new Logger(), false, new String[0]);
    }

    public DefaultApiClient(int connectTimeout, int readTimeout, String libraryVersion, RequestInterceptor[] interceptors, ResponsePreProcessor[] responsePreProcessors, Logger logger, boolean allowUntrustedSSLOnError, String ... userAgentAdditions) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.libraryVersion = libraryVersion;
        this.requestInterceptors = interceptors;
        this.responsePreProcessors = responsePreProcessors;
        this.userAgentAdditions = userAgentAdditions;
        this.logger = logger;
        this.allowUntrustedSSLOnError = allowUntrustedSSLOnError;
    }

    @Override
    public <B, R> R execute(HttpMethod method, String uri, String apiKey, Tuple<String, String> credentials, Map<String, Collection<Object>> queryParams, Map<String, Collection<Object>> headers, B body, Class<R> responseType) {
        Request request = new Request(method, uri, apiKey, credentials, headers, queryParams, body);
        for (RequestInterceptor interceptor : this.requestInterceptors) {
            try {
                request = interceptor.intercept(request);
            }
            catch (Exception e) {
                this.logger.e("Request interceptor " + interceptor + " thrown an exception " + e);
            }
        }
        this.logger.d("REQUEST: " + request);
        try {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Collection<Object>> entry : request.queryParams.entrySet()) {
                this.appendValue(sb, entry);
            }
            try {
                return this.executeHTTP(request, responseType, false);
            }
            catch (SSLHandshakeException ex) {
                this.logger.w("Got SSL handshake exception " + ex);
                if (this.allowUntrustedSSLOnError) {
                    this.logger.w("Will re-try in untrusted mode");
                    return this.executeHTTP(request, responseType, true);
                }
                throw ex;
            }
        }
        catch (Exception e) {
            this.interceptErrorResponse(e);
            if (e instanceof ApiIOException) {
                throw (ApiIOException)e;
            }
            throw new ApiIOException(ErrorCode.API_IO_ERROR.value, ErrorCode.API_IO_ERROR.description + " : " + request.uri, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R executeHTTP(Request request, Class<R> responseType, boolean tryUntrustedSSL) throws IOException {
        HttpURLConnection urlConnection = null;
        try {
            ApiResponse apiResponse;
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Collection<Object>> entry : request.queryParams.entrySet()) {
                this.appendValue(sb, entry);
            }
            urlConnection = (HttpURLConnection)new URL(request.uri + sb.toString()).openConnection();
            if (request.httpMethod == HttpMethod.PATCH) {
                urlConnection.setRequestProperty("X-HTTP-Method-Override", HttpMethod.PATCH.name());
                urlConnection.setRequestMethod(HttpMethod.POST.name());
            } else {
                urlConnection.setRequestMethod(request.httpMethod.name());
            }
            if (request.httpMethod != HttpMethod.GET) {
                urlConnection.setDoOutput(true);
            }
            urlConnection.setUseCaches(false);
            urlConnection.setDoInput(true);
            urlConnection.setConnectTimeout(this.connectTimeout);
            urlConnection.setReadTimeout(this.readTimeout);
            if (tryUntrustedSSL && urlConnection instanceof HttpsURLConnection) {
                UntrustedSSLHelper.trustAllCerts((HttpsURLConnection)urlConnection);
            }
            if (null != request.headers) {
                for (Map.Entry<String, Collection<Object>> entry : request.headers.entrySet()) {
                    String key;
                    Collection<Object> value = entry.getValue();
                    if (null == value || value.isEmpty() || (key = entry.getKey().trim()).equalsIgnoreCase("Content-Length")) continue;
                    for (Object v : value) {
                        if (v == null) continue;
                        urlConnection.setRequestProperty(key, v.toString());
                    }
                }
            }
            if (StringUtils.isNotBlank(request.apiKey)) {
                urlConnection.setRequestProperty("Authorization", "App " + request.apiKey);
            } else if (request.credentials != null && StringUtils.isNotBlank(request.credentials.getLeft()) && StringUtils.isNotBlank(request.credentials.getRight())) {
                String basicApiKey = Base64Encoder.encode(request.credentials.getLeft() + ":" + request.credentials.getRight());
                urlConnection.setRequestProperty("Authorization", "Basic " + basicApiKey);
            }
            urlConnection.setRequestProperty("Accept", "application/json");
            String userAgent = urlConnection.getRequestProperty("User-Agent");
            if (null == userAgent) {
                urlConnection.setRequestProperty("User-Agent", this.getUserAgent());
            }
            if (null != request.body) {
                byte[] bytes = DefaultApiClient.jsonSerializer(request.httpMethod).serialize(request.body).getBytes("UTF-8");
                urlConnection.setRequestProperty("Content-Length", "" + bytes.length);
                urlConnection.setRequestProperty("Content-Type", "application/json");
                BufferedOutputStream outputStream = null;
                try {
                    outputStream = new BufferedOutputStream(urlConnection.getOutputStream());
                    ((OutputStream)outputStream).write(bytes);
                    ((OutputStream)outputStream).flush();
                }
                catch (Throwable throwable) {
                    StreamUtils.closeSafely(outputStream);
                    throw throwable;
                }
                StreamUtils.closeSafely(outputStream);
            }
            int responseCode = urlConnection.getResponseCode();
            this.interceptResponse(responseCode, urlConnection.getHeaderFields());
            int contentLength = urlConnection.getContentLength();
            if (responseCode >= 400) {
                Tuple<String, String> tuple;
                apiResponse = new ApiResponse(ErrorCode.UNKNOWN_ERROR.value, ErrorCode.UNKNOWN_ERROR.description);
                if (contentLength > 0) {
                    InputStream inputStream = urlConnection.getErrorStream();
                    String s = StreamUtils.readToString(inputStream, "UTF-8", contentLength);
                    apiResponse = DefaultApiClient.jsonSerializer(request.httpMethod).deserialize(s, ApiResponse.class);
                }
                if (responseCode >= 500) {
                    tuple = this.safeGetErrorInfo(apiResponse, ErrorCode.UNKNOWN_API_BACKEND_ERROR.value, ErrorCode.UNKNOWN_API_BACKEND_ERROR.description);
                    throw new ApiBackendException(tuple.getLeft(), tuple.getRight());
                }
                tuple = this.safeGetErrorInfo(apiResponse, ErrorCode.UNKNOWN_API_ERROR.value, ErrorCode.UNKNOWN_API_ERROR.description);
                throw new ApiException(tuple.getLeft(), tuple.getRight());
            }
            if (Void.class.equals(responseType) || Void.TYPE.equals(responseType) || responseType == null) {
                apiResponse = null;
                return (R)apiResponse;
            }
            InputStream inputStream = urlConnection.getInputStream();
            String s = StreamUtils.readToString(inputStream, "UTF-8", contentLength);
            inputStream.close();
            R response = DefaultApiClient.jsonSerializer(request.httpMethod).deserialize(s, responseType);
            ApiResponse apiResponse2 = null;
            try {
                apiResponse2 = DefaultApiClient.jsonSerializer(request.httpMethod).deserialize(s, ApiResponse.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (apiResponse2 != null && apiResponse2.getRequestError() != null) {
                Tuple<String, String> tuple = this.safeGetErrorInfo(apiResponse2, ErrorCode.UNKNOWN_API_BACKEND_ERROR.value, ErrorCode.UNKNOWN_API_BACKEND_ERROR.description);
                throw new ApiBackendExceptionWithContent(tuple.getLeft(), tuple.getRight(), response);
            }
            R r = response;
            return r;
        }
        finally {
            try {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
            }
            catch (Exception tuple) {}
        }
    }

    private void interceptErrorResponse(Exception error) {
        for (ResponsePreProcessor responsePreProcessor : this.responsePreProcessors) {
            try {
                responsePreProcessor.beforeResponse(error);
            }
            catch (Exception e) {
                this.logger.e("Response interceptor " + responsePreProcessor + " thrown an exception " + e);
            }
        }
    }

    private void interceptResponse(int httpStatusCode, Map<String, List<String>> responseHeaders) {
        for (ResponsePreProcessor responsePreProcessor : this.responsePreProcessors) {
            try {
                responsePreProcessor.beforeResponse(httpStatusCode, responseHeaders);
            }
            catch (Exception e) {
                this.logger.e("Response interceptor " + responsePreProcessor + " thrown an exception " + e);
            }
        }
    }

    private String getUserAgent() {
        if (null != this.userAgent) {
            return this.userAgent;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Infobip Mobile API Client");
        if (StringUtils.isNotBlank(this.libraryVersion)) {
            sb.append("/").append(this.libraryVersion);
        }
        sb.append("(");
        if (null != this.userAgentAdditions) {
            sb.append(StringUtils.join(";", this.userAgentAdditions));
        }
        sb.append(")");
        this.userAgent = sb.toString();
        return this.userAgent;
    }

    private Tuple<String, String> safeGetErrorInfo(ApiResponse apiResponse, String code, String message) {
        if (null == apiResponse) {
            return new Tuple<String, String>(code, message);
        }
        if (null == apiResponse.getRequestError()) {
            return new Tuple<String, String>(code, message);
        }
        if (null == apiResponse.getRequestError().getServiceException()) {
            return new Tuple<String, String>(code, message);
        }
        return new Tuple<String, String>(apiResponse.getRequestError().getServiceException().getMessageId(), apiResponse.getRequestError().getServiceException().getText());
    }

    private void appendValue(StringBuilder sb, Map.Entry<String, Collection<Object>> entry) throws UnsupportedEncodingException {
        if (null == entry) {
            return;
        }
        Collection<Object> value = entry.getValue();
        if (null == value || value.isEmpty()) {
            return;
        }
        for (Object v : value) {
            String s = v.toString();
            if (StringUtils.isBlank(s)) {
                s = "";
            }
            sb.append(sb.length() == 0 ? "?" : "&").append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(s, "UTF-8"));
        }
    }

    private static JsonSerializer jsonSerializer(HttpMethod httpMethod) {
        if (httpMethod == HttpMethod.PATCH) {
            return JSON_SERIALIZER_WITH_NULLS;
        }
        return JSON_SERIALIZER;
    }

    public static enum ErrorCode {
        UNKNOWN_ERROR("-1", "Unknown error"),
        UNKNOWN_API_BACKEND_ERROR("-2", "Unknown API backend error"),
        UNKNOWN_API_ERROR("-3", "Unknown API error"),
        API_IO_ERROR("-4", "Can't access URI");

        private final String value;
        private final String description;

        private ErrorCode(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

