/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.api.support.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class CollectionUtils {
    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    @SafeVarargs
    public static <C extends Collection<T>, T> C concat(C ... cs) {
        LinkedList<C> collections = new LinkedList<C>(Arrays.asList(cs));
        Iterator iterator = collections.iterator();
        while (iterator.hasNext()) {
            Collection collection = (Collection)iterator.next();
            if (collection != null) continue;
            iterator.remove();
        }
        if (collections.isEmpty()) {
            return null;
        }
        Collection result = (Collection)collections.get(0);
        for (int i = 1; i < collections.size(); ++i) {
            result.addAll((Collection)collections.get(i));
        }
        return (C)result;
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... ts) {
        return new HashSet<T>(Arrays.asList(ts));
    }
}

