/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import java.security.InvalidParameterException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.infobip.mobile.messaging.util.DateTimeUtil;

public class CustomAttributeValue {
    private Object value;
    private final Type type;

    public CustomAttributeValue(String someString) {
        this.value = someString;
        this.type = Type.String;
    }

    public CustomAttributeValue(Number someNumber) {
        this.value = someNumber;
        this.type = Type.Number;
    }

    public CustomAttributeValue(Date someDate) {
        this.value = DateTimeUtil.dateToISO8601String(someDate);
        this.type = Type.Date;
    }

    public CustomAttributeValue(Boolean someBoolean) {
        this.value = someBoolean;
        this.type = Type.Boolean;
    }

    public CustomAttributeValue(String stringValue, Type type) throws ParseException, InvalidParameterException {
        this.type = type;
        switch (type) {
            case String: {
                this.value = stringValue;
                break;
            }
            case Number: {
                this.value = NumberFormat.getNumberInstance(Locale.getDefault()).parse(stringValue);
                break;
            }
            case Date: {
                DateTimeUtil.dateFromYMDString(stringValue);
                this.value = stringValue;
                break;
            }
            case Boolean: {
                this.value = Boolean.valueOf(stringValue);
                break;
            }
            default: {
                throw new InvalidParameterException();
            }
        }
    }

    protected CustomAttributeValue(CustomAttributeValue that) {
        this.value = that.value;
        this.type = that.type;
    }

    public String stringValue() {
        if (!(this.value instanceof String) || this.type != Type.String) {
            throw new ClassCastException();
        }
        return (String)this.value;
    }

    public Number numberValue() {
        if (!(this.value instanceof Number) || this.type != Type.Number) {
            throw new ClassCastException();
        }
        return (Number)this.value;
    }

    public Date dateValue() {
        if (!(this.value instanceof String) || this.type != Type.Date) {
            throw new ClassCastException();
        }
        try {
            return DateTimeUtil.dateFromISO8601DateUTCString((String)this.value);
        }
        catch (ParseException ex1) {
            try {
                return DateTimeUtil.dateFromYMDString((String)this.value);
            }
            catch (ParseException ex2) {
                throw new ClassCastException(ex2.getMessage());
            }
        }
    }

    public Boolean booleanValue() {
        if (!(this.value instanceof Boolean) || this.type != Type.Boolean) {
            throw new ClassCastException();
        }
        return Boolean.valueOf("" + this.value);
    }

    public Type getType() {
        return this.type;
    }

    protected Object getValue() {
        return this.value;
    }

    public String toString() {
        if (this.type == null) {
            return super.toString();
        }
        switch (this.type) {
            case String: {
                return this.stringValue();
            }
            case Date: {
                return DateTimeUtil.dateToYMDString(this.dateValue());
            }
            case Number: {
                return "" + this.numberValue();
            }
            case Boolean: {
                return "" + this.booleanValue();
            }
        }
        return super.toString();
    }

    public static enum Type {
        String,
        Number,
        Date,
        Boolean;

    }
}

