/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.cloud.hms;

import android.content.Context;
import com.huawei.hms.aaid.HmsInstanceId;
import com.huawei.hms.common.ApiException;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.cloud.RegistrationTokenHandler;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.util.StringUtils;

public class HmsRegistrationTokenHandler
extends RegistrationTokenHandler {
    private static final String TAG = HmsRegistrationTokenHandler.class.getSimpleName();
    private final Broadcaster broadcaster;

    public HmsRegistrationTokenHandler(MobileMessagingCore mobileMessagingCore, Broadcaster broadcaster) {
        super(mobileMessagingCore);
        this.broadcaster = broadcaster;
    }

    @Override
    public void handleNewToken(String senderId, String token) {
        MobileMessagingLogger.v(TAG, (Object)"RECEIVED HMS TOKEN", token);
        this.broadcaster.tokenReceived(token);
        this.sendRegistrationToServer(token);
    }

    @Override
    public void cleanupToken(String senderId, Context context) {
        if (StringUtils.isBlank(senderId)) {
            return;
        }
        try {
            HmsInstanceId.getInstance((Context)context).deleteToken(senderId, "HCM");
        }
        catch (ApiException e) {
            MobileMessagingLogger.e(TAG, "Error while deleting token", e);
        }
    }

    @Override
    public void acquireNewToken(String senderId, Context context) {
        try {
            MobileMessagingLogger.i(TAG, "Try to get token for senderId: " + senderId);
            String token = HmsInstanceId.getInstance((Context)context).getToken(senderId, "HCM");
            if (StringUtils.isNotBlank(token)) {
                this.handleNewToken(senderId, token);
            }
        }
        catch (ApiException e) {
            MobileMessagingLogger.e(TAG, "Error while acquiring token", e);
        }
    }
}

