/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.cloud.hms;

import android.content.Context;
import com.huawei.hms.push.HmsMessageService;
import com.huawei.hms.push.RemoteMessage;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.cloud.MobileMessagingCloudService;
import org.infobip.mobile.messaging.cloud.hms.HmsMessageMapper;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;

public class MobileMessagingHmsService
extends HmsMessageService {
    private static final String TAG = MobileMessagingHmsService.class.getSimpleName();
    private static HmsMessageMapper messageMapper;

    public static HmsMessageMapper getMessageMapper() {
        if (null == messageMapper) {
            messageMapper = new HmsMessageMapper();
        }
        return messageMapper;
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        MobileMessagingHmsService.onMessageReceived((Context)this, remoteMessage);
    }

    public void onNewToken(String token) {
        MobileMessagingHmsService.onNewToken((Context)this, token);
    }

    public static boolean onMessageReceived(Context context, RemoteMessage remoteMessage) {
        Message message = MobileMessagingHmsService.getMessageMapper().createMessage(remoteMessage);
        MobileMessagingLogger.v(TAG, (Object)"RECEIVED MESSAGE FROM HMS", message);
        if (message != null) {
            MobileMessagingCloudService.enqueueNewMessage(context, message);
            return true;
        }
        MobileMessagingLogger.w("Cannot process message");
        return false;
    }

    public static void onNewToken(Context context, String token) {
        MobileMessagingLogger.v(TAG, (Object)"RECEIVED NEW HMS TOKEN", token);
        String senderId = MobileMessagingCore.getSenderId(context);
        MobileMessagingCloudService.enqueueNewToken(context, senderId, token);
    }
}

