/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.interactive.inapp.cache;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.interactive.inapp.cache.OneMessageCache;
import org.infobip.mobile.messaging.interactive.inapp.cache.PreferenceHelperWrapper;

public class OneMessagePreferenceCache
implements OneMessageCache {
    private static final String MESSAGE_KEY = "org.infobip.mobile.messaging.interactive.inapp.cache.MESSAGE";
    private static volatile Message runtimeCachedMessage = null;
    private final PreferenceHelperWrapper preferenceHelperWrapper;
    private final JsonSerializer jsonSerializer;

    public OneMessagePreferenceCache(Context context) {
        this.preferenceHelperWrapper = new PreferenceHelperWrapper(context);
        this.jsonSerializer = new JsonSerializer(false, new JsonSerializer.ObjectAdapter[0]);
    }

    @VisibleForTesting
    OneMessagePreferenceCache(PreferenceHelperWrapper preferenceHelperWrapper, JsonSerializer jsonSerializer) {
        this.preferenceHelperWrapper = preferenceHelperWrapper;
        this.jsonSerializer = jsonSerializer;
    }

    @Override
    public void save(Message message) {
        runtimeCachedMessage = message;
        if (this.canStoreOnDisk()) {
            this.preferenceHelperWrapper.set(MESSAGE_KEY, this.jsonSerializer.serialize((Object)message));
        }
    }

    @Override
    public void remove(Message message) {
        Message storedMessage = this.getAndRemove();
        if (storedMessage == null) {
            return;
        }
        if (!storedMessage.getMessageId().equals(message.getMessageId())) {
            this.save(storedMessage);
        }
    }

    @Override
    public Message getAndRemove() {
        Message message = runtimeCachedMessage;
        if (message != null) {
            runtimeCachedMessage = null;
            this.preferenceHelperWrapper.remove(MESSAGE_KEY);
            return message;
        }
        return this.getFromPreferences();
    }

    @Nullable
    private Message getFromPreferences() {
        String value = this.preferenceHelperWrapper.getAndRemove(MESSAGE_KEY);
        if (TextUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return (Message)this.jsonSerializer.deserialize(value, Message.class);
    }

    private boolean canStoreOnDisk() {
        return this.preferenceHelperWrapper.get(MobileMessagingProperty.SAVE_USER_DATA_ON_DISK.getKey(), true);
    }
}

