/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobileapi;

import java.util.Timer;
import java.util.TimerTask;
import org.infobip.mobile.messaging.platform.SystemTimeProvider;
import org.infobip.mobile.messaging.platform.TimeProvider;

public class BatchReporter {
    private final long delay;
    private final TimeProvider timeProvider;
    private final Timer timer = new Timer();
    private volatile TimerTask timerTask = null;
    private volatile long lastSubmitted = 0L;

    public BatchReporter(Long batchReportingDelay, TimeProvider timeProvider) {
        this.delay = batchReportingDelay;
        this.timeProvider = timeProvider;
    }

    public BatchReporter(Long batchReportingDelay) {
        this(batchReportingDelay, new SystemTimeProvider());
    }

    public synchronized void put(Runnable task) {
        long now;
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timer.purge();
        }
        if ((now = this.timeProvider.now()) - this.lastSubmitted >= this.delay) {
            this.runNow(task);
            return;
        }
        long after = this.lastSubmitted + this.delay - now;
        this.scheduleWithDelay(task, after);
    }

    private void runNow(Runnable task) {
        this.lastSubmitted = this.timeProvider.now();
        task.run();
    }

    private void scheduleWithDelay(final Runnable task, long delay) {
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                BatchReporter.this.runNow(task);
            }
        };
        this.timer.schedule(this.timerTask, delay);
    }
}

