/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;

public class ModuleLoader {
    private final Context context;

    public ModuleLoader(Context context) {
        this.context = context;
    }

    public <T> Map<String, T> loadModulesFromManifest(Class<T> cls) {
        HashMap<String, T> modules = new HashMap<String, T>();
        for (Class<T> implementation : this.loadModuleClassesFromManifest(cls)) {
            T module;
            try {
                module = implementation.newInstance();
            }
            catch (Exception e) {
                MobileMessagingLogger.e("Cannot create module for class: " + cls.getName());
                continue;
            }
            modules.put(implementation.getName(), module);
        }
        return modules;
    }

    public <T> T createModule(Class<T> cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception e) {
            MobileMessagingLogger.e("Cannot create module for class: " + cls.getName());
            return null;
        }
    }

    private <T> Set<Class<T>> loadModuleClassesFromManifest(Class<T> cls) {
        Bundle metaData;
        try {
            ApplicationInfo ai = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
            if (ai.metaData == null) {
                throw new RuntimeException("Meta data is null");
            }
            metaData = ai.metaData;
        }
        catch (Exception e) {
            MobileMessagingLogger.e("Failed to read meta data of application: " + e.getMessage());
            return new HashSet<Class<T>>();
        }
        HashSet<Class<T>> classes = new HashSet<Class<T>>();
        for (String key : metaData.keySet()) {
            try {
                Object o = metaData.get(key);
                if (!(o instanceof String)) continue;
                String className = (String)o;
                if (!cls.getName().equals(className)) continue;
                classes.add(Class.forName(key));
            }
            catch (Exception ignored) {
                MobileMessagingLogger.e("Cannot create class for: " + key);
            }
        }
        return classes;
    }
}

