/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.view;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.TypedValue;
import android.view.Menu;
import android.view.MenuItem;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.net.URISyntaxException;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.R;
import org.infobip.mobile.messaging.app.WebViewSettingsResolver;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.util.StringUtils;

public class WebViewActivity
extends AppCompatActivity {
    public static final String EXTRA_URL = "ib_webview_url";
    private ProgressBar progressBar;
    private WebView webView;

    public void onCreate(Bundle savedInstanceState) {
        WebViewSettingsResolver webViewSettingsResolver = new WebViewSettingsResolver((Context)this);
        this.setTheme(webViewSettingsResolver.getWebViewTheme());
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.ib_activity_webview);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.ib_toolbar_webview);
        this.setSupportActionBar(toolbar);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar == null) {
            this.onBackPressed();
            return;
        }
        actionBar.setDisplayHomeAsUpEnabled(false);
        actionBar.setDisplayShowTitleEnabled(false);
        final TextView tvToolbarTitle = (TextView)toolbar.findViewById(R.id.ib_tv_webview_toolbar_title);
        tvToolbarTitle.setText(toolbar.getTitle());
        this.applyStylesFromConfig(toolbar, tvToolbarTitle);
        Intent webViewIntent = this.getIntent();
        String url = webViewIntent.getStringExtra(EXTRA_URL);
        this.webView = (WebView)this.findViewById(R.id.ib_webview);
        WebSettings settings = this.webView.getSettings();
        settings.setBuiltInZoomControls(true);
        settings.setJavaScriptEnabled(true);
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String innerUrl) {
                return WebViewActivity.this.shouldOverrideUrlLoading(innerUrl);
            }

            public void onPageFinished(WebView view, String url) {
                try {
                    WebViewActivity.this.progressBar.setVisibility(8);
                    tvToolbarTitle.setText((CharSequence)view.getTitle());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.webView.loadUrl(url);
    }

    private boolean shouldOverrideUrlLoading(String innerUrl) {
        Intent parsedUriIntent;
        Uri parsedUri;
        if (StringUtils.isBlank(innerUrl)) {
            return false;
        }
        PackageManager packageManager = this.getPackageManager();
        if (innerUrl.startsWith("intent://")) {
            try {
                Intent intent = Intent.parseUri((String)innerUrl, (int)1);
                if (intent.resolveActivity(packageManager) != null) {
                    this.startActivity(intent);
                    return true;
                }
                String fallbackUrl = intent.getStringExtra("browser_fallback_url");
                if (fallbackUrl != null) {
                    this.webView.loadUrl(fallbackUrl);
                    return true;
                }
                Intent marketIntent = new Intent("android.intent.action.VIEW").setData(Uri.parse((String)("market://details?id=" + intent.getPackage())));
                if (marketIntent.resolveActivity(packageManager) != null) {
                    this.startActivity(marketIntent);
                    return true;
                }
                Intent appMarketIntent = new Intent("android.intent.action.VIEW").setData(Uri.parse((String)("appmarket://details?id=" + intent.getPackage())));
                if (appMarketIntent.resolveActivity(packageManager) != null) {
                    this.startActivity(appMarketIntent);
                    return true;
                }
            }
            catch (URISyntaxException e) {
                MobileMessagingLogger.w("Failed to resolve intent:// for web view URL " + innerUrl, e);
            }
        }
        if ((parsedUri = Uri.parse((String)innerUrl)) != null && (parsedUriIntent = new Intent("android.intent.action.VIEW", parsedUri)).resolveActivity(packageManager) != null) {
            this.startActivity(parsedUriIntent);
            return true;
        }
        return false;
    }

    private void applyStylesFromConfig(Toolbar toolbar, TextView tvToolbarTitle) {
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = this.getTheme();
        theme.resolveAttribute(R.attr.colorPrimary, typedValue, true);
        toolbar.setBackgroundColor(typedValue.data);
        tvToolbarTitle.setTextAppearance((Context)this, R.style.TextAppearance_AppCompat_Widget_ActionBar_Title);
        theme.resolveAttribute(R.attr.titleTextColor, typedValue, true);
        tvToolbarTitle.setTextColor(typedValue.data);
        this.progressBar = (ProgressBar)this.findViewById(R.id.ib_pb_webview);
        theme.resolveAttribute(R.attr.colorPrimaryDark, typedValue, true);
        try {
            this.progressBar.getIndeterminateDrawable().setColorFilter(typedValue.data, PorterDuff.Mode.SRC_IN);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.ib_menu_cancel) {
            this.goBack();
            this.webView.freeMemory();
            this.webView.removeAllViews();
            this.webView.destroy();
        }
        return true;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.ib_menu_webview, menu2);
        Drawable drawable2 = this.tintXButton(menu2);
        menu2.findItem(R.id.ib_menu_cancel).setIcon(drawable2);
        return true;
    }

    @NonNull
    private Drawable tintXButton(Menu menu2) {
        Drawable drawable2 = menu2.findItem(R.id.ib_menu_cancel).getIcon();
        drawable2 = DrawableCompat.wrap((Drawable)drawable2);
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = this.getTheme();
        theme.resolveAttribute(R.attr.colorControlNormal, typedValue, true);
        drawable2.setColorFilter(typedValue.data, PorterDuff.Mode.SRC_IN);
        return drawable2;
    }

    public void onBackPressed() {
        if (!this.webView.canGoBack()) {
            this.goBack();
            return;
        }
        this.webView.goBack();
    }

    private void goBack() {
        NotificationSettings notificationSettings;
        if (this.isTaskRoot() && (notificationSettings = MobileMessagingCore.getInstance((Context)this).getNotificationSettings()) != null) {
            Class<?> callbackActivity = notificationSettings.getCallbackActivity();
            Intent startParentActivity = new Intent((Context)this, callbackActivity);
            this.startActivity(startParentActivity);
        }
        super.onBackPressed();
    }
}

