/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.scale;

import android.graphics.Bitmap;
import java.nio.Buffer;
import java.nio.IntBuffer;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;

public class BitmapUtil {
    private static ThreadLocal<int[]> buffer = new ThreadLocal();

    public static Picture fromBitmap(Bitmap src) {
        if (src == null) {
            return null;
        }
        Picture dst = Picture.create((int)src.getWidth(), (int)src.getHeight(), (ColorSpace)ColorSpace.RGB);
        BitmapUtil.fromBitmap(src, dst);
        return dst;
    }

    public static void fromBitmap(Bitmap src, Picture dst) {
        int[] dstData = dst.getPlaneData(0);
        int[] packed = new int[src.getWidth() * src.getHeight()];
        src.getPixels(packed, 0, src.getWidth(), 0, 0, src.getWidth(), src.getHeight());
        int srcOff = 0;
        int dstOff = 0;
        for (int i = 0; i < src.getHeight(); ++i) {
            int j = 0;
            while (j < src.getWidth()) {
                int rgb = packed[srcOff];
                dstData[dstOff] = rgb >> 16 & 0xFF;
                dstData[dstOff + 1] = rgb >> 8 & 0xFF;
                dstData[dstOff + 2] = rgb & 0xFF;
                ++j;
                ++srcOff;
                dstOff += 3;
            }
        }
    }

    public static Bitmap toBitmap(Picture pic) {
        if (pic == null) {
            return null;
        }
        Bitmap dst = Bitmap.createBitmap((int)pic.getCroppedWidth(), (int)pic.getCroppedHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        BitmapUtil.toBitmap(pic, dst);
        return dst;
    }

    public static void toBitmap(Picture src, Bitmap dst) {
        int[] srcData = src.getPlaneData(0);
        int[] packed = BitmapUtil.getBuffer(src);
        int dstOff = 0;
        int srcOff = 0;
        for (int i = 0; i < src.getCroppedHeight(); ++i) {
            int j = 0;
            while (j < src.getCroppedWidth()) {
                packed[dstOff] = 0xFF000000 | srcData[srcOff] << 16 | srcData[srcOff + 1] << 8 | srcData[srcOff + 2];
                ++j;
                ++dstOff;
                srcOff += 3;
            }
            srcOff += src.getWidth() - src.getCroppedWidth();
        }
        dst.copyPixelsFromBuffer((Buffer)IntBuffer.wrap(packed));
    }

    private static int[] getBuffer(Picture src) {
        int[] result = buffer.get();
        if (result == null) {
            result = new int[src.getWidth() * src.getHeight()];
            buffer.set(result);
        }
        return result;
    }
}

