/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.api.android;

import android.graphics.Bitmap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.jcodec.api.FrameGrab;
import org.jcodec.api.JCodecException;
import org.jcodec.api.PictureWithMetadata;
import org.jcodec.api.android.BitmapWithMetadata;
import org.jcodec.api.specific.ContainerAdaptor;
import org.jcodec.common.AndroidUtil;
import org.jcodec.common.SeekableDemuxerTrack;
import org.jcodec.common.io.FileChannelWrapper;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.Picture;

public class AndroidFrameGrab
extends FrameGrab {
    public static AndroidFrameGrab createAndroidFrameGrab(SeekableByteChannel in) throws IOException, JCodecException {
        FrameGrab frameGrab = AndroidFrameGrab.createFrameGrab((SeekableByteChannel)in);
        return new AndroidFrameGrab(frameGrab.getVideoTrack(), frameGrab.getDecoder());
    }

    public AndroidFrameGrab(SeekableDemuxerTrack videoTrack, ContainerAdaptor decoder) {
        super(videoTrack, decoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getFrame(File file, double second) throws IOException, JCodecException {
        FileChannelWrapper ch = null;
        try {
            ch = NIOUtils.readableChannel((File)file);
            Bitmap bitmap = ((AndroidFrameGrab)AndroidFrameGrab.createAndroidFrameGrab((SeekableByteChannel)ch).seekToSecondPrecise(second)).getFrame();
            return bitmap;
        }
        finally {
            NIOUtils.closeQuietly((Closeable)ch);
        }
    }

    public static Bitmap getFrame(SeekableByteChannel file, double second) throws JCodecException, IOException {
        return ((AndroidFrameGrab)AndroidFrameGrab.createAndroidFrameGrab(file).seekToSecondPrecise(second)).getFrame();
    }

    public BitmapWithMetadata getFrameWithMetadata() throws IOException {
        PictureWithMetadata pictureWithMeta = this.getNativeFrameWithMetadata();
        if (pictureWithMeta == null) {
            return null;
        }
        Bitmap bitmap = AndroidUtil.toBitmap(pictureWithMeta.getPicture());
        return new BitmapWithMetadata(bitmap, pictureWithMeta.getTimestamp(), pictureWithMeta.getDuration());
    }

    public Bitmap getFrame() throws IOException {
        return AndroidUtil.toBitmap(this.getNativeFrame());
    }

    public void getFrame(Bitmap bmp) throws IOException {
        Picture picture = this.getNativeFrame();
        AndroidUtil.toBitmap(picture, bmp);
    }

    public BitmapWithMetadata getFrameWithMetadata(Bitmap bmp) throws IOException {
        PictureWithMetadata pictureWithMetadata = this.getNativeFrameWithMetadata();
        if (pictureWithMetadata == null) {
            return null;
        }
        AndroidUtil.toBitmap(pictureWithMetadata.getPicture(), bmp);
        return new BitmapWithMetadata(bmp, pictureWithMetadata.getTimestamp(), pictureWithMetadata.getDuration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getFrame(File file, int frameNumber) throws IOException, JCodecException {
        FileChannelWrapper ch = null;
        try {
            ch = NIOUtils.readableChannel((File)file);
            Bitmap bitmap = ((AndroidFrameGrab)AndroidFrameGrab.createAndroidFrameGrab((SeekableByteChannel)ch).seekToFramePrecise(frameNumber)).getFrame();
            return bitmap;
        }
        finally {
            NIOUtils.closeQuietly((Closeable)ch);
        }
    }

    public static Bitmap getFrame(SeekableByteChannel file, int frameNumber) throws JCodecException, IOException {
        return ((AndroidFrameGrab)AndroidFrameGrab.createAndroidFrameGrab(file).seekToFramePrecise(frameNumber)).getFrame();
    }

    public static Bitmap getFrame(SeekableDemuxerTrack vt, ContainerAdaptor decoder, int frameNumber) throws IOException, JCodecException {
        return ((AndroidFrameGrab)new AndroidFrameGrab(vt, decoder).seekToFramePrecise(frameNumber)).getFrame();
    }

    public static Bitmap getFrame(SeekableDemuxerTrack vt, ContainerAdaptor decoder, double second) throws IOException, JCodecException {
        return ((AndroidFrameGrab)new AndroidFrameGrab(vt, decoder).seekToSecondPrecise(second)).getFrame();
    }

    public static Bitmap getFrameSloppy(SeekableDemuxerTrack vt, ContainerAdaptor decoder, int frameNumber) throws IOException, JCodecException {
        return ((AndroidFrameGrab)new AndroidFrameGrab(vt, decoder).seekToFrameSloppy(frameNumber)).getFrame();
    }

    public static Bitmap getFrameSloppy(SeekableDemuxerTrack vt, ContainerAdaptor decoder, double second) throws IOException, JCodecException {
        return ((AndroidFrameGrab)new AndroidFrameGrab(vt, decoder).seekToSecondSloppy(second)).getFrame();
    }
}

