/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common;

import android.graphics.Bitmap;
import org.jcodec.common.VideoEncoder;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.common.model.Rect;
import org.jcodec.scale.BitmapUtil;
import org.jcodec.scale.ColorUtil;
import org.jcodec.scale.Transform;

public class AndroidUtil {
    private static AndroidUtil inst;
    private BitmapUtil bitmapUtil;

    public AndroidUtil(BitmapUtil bitmapUtil) {
        this.bitmapUtil = bitmapUtil;
    }

    private static AndroidUtil inst() {
        if (inst == null) {
            inst = new AndroidUtil(new BitmapUtil());
        }
        return inst;
    }

    public static Bitmap toBitmap(Picture pic) {
        return AndroidUtil.inst().toBitmapImpl(pic);
    }

    public static void toBitmap(Picture pic, Bitmap out) {
        AndroidUtil.inst().toBitmapImpl(pic, out);
    }

    public static Picture fromBitmap(Bitmap bitmap, ColorSpace colorSpace) {
        return AndroidUtil.inst().fromBitmapImpl(bitmap, colorSpace);
    }

    public static Picture fromBitmap(Bitmap bitmap, VideoEncoder encoder) {
        return AndroidUtil.inst().fromBitmapImpl(bitmap, encoder);
    }

    public static void fromBitmap(Bitmap bitmap, Picture out) {
        AndroidUtil.inst().fromBitmapImpl(bitmap, out);
    }

    public Bitmap toBitmapImpl(Picture pic) {
        if (pic == null) {
            return null;
        }
        Transform transform = ColorUtil.getTransform((ColorSpace)pic.getColor(), (ColorSpace)ColorSpace.RGB);
        Picture rgb = Picture.createCropped((int)pic.getWidth(), (int)pic.getHeight(), (ColorSpace)ColorSpace.RGB, (Rect)pic.getCrop());
        transform.transform(pic, rgb);
        return this.bitmapUtil.toBitmapImpl(rgb);
    }

    public void toBitmapImpl(Picture pic, Bitmap out) {
        if (pic == null) {
            throw new IllegalArgumentException("Input pic is null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Out bitmap is null");
        }
        Transform transform = ColorUtil.getTransform((ColorSpace)pic.getColor(), (ColorSpace)ColorSpace.RGB);
        Picture rgb = Picture.createCropped((int)pic.getWidth(), (int)pic.getHeight(), (ColorSpace)ColorSpace.RGB, (Rect)pic.getCrop());
        transform.transform(pic, rgb);
        this.bitmapUtil.toBitmapImpl(rgb, out);
    }

    public Picture fromBitmapImpl(Bitmap bitmap, ColorSpace colorSpace) {
        if (bitmap == null) {
            return null;
        }
        Picture out = Picture.create((int)bitmap.getWidth(), (int)bitmap.getHeight(), (ColorSpace)colorSpace);
        this.fromBitmapImpl(bitmap, out);
        return out;
    }

    public Picture fromBitmapImpl(Bitmap bitmap, VideoEncoder encoder) {
        if (bitmap == null) {
            return null;
        }
        ColorSpace selectedColorSpace = null;
        for (ColorSpace colorSpace : encoder.getSupportedColorSpaces()) {
            if (ColorUtil.getTransform((ColorSpace)ColorSpace.RGB, (ColorSpace)colorSpace) == null) continue;
            selectedColorSpace = colorSpace;
            break;
        }
        if (selectedColorSpace == null) {
            throw new RuntimeException("Could not find a transform to convert to a codec-supported colorspace.");
        }
        Picture out = Picture.create((int)bitmap.getWidth(), (int)bitmap.getHeight(), selectedColorSpace);
        this.fromBitmapImpl(bitmap, out);
        return out;
    }

    public void fromBitmapImpl(Bitmap bitmap, Picture out) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Input pic is null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Out bitmap is null");
        }
        if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
            throw new RuntimeException("Unsupported bitmap config: " + bitmap.getConfig());
        }
        Picture rgb = this.bitmapUtil.fromBitmapImpl(bitmap);
        Transform transform = ColorUtil.getTransform((ColorSpace)ColorSpace.RGB, (ColorSpace)out.getColor());
        transform.transform(rgb, out);
    }
}

