/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.io;

import android.util.Log;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.jcodec.common.io.SeekableByteChannel;

public class HttpChannel
implements SeekableByteChannel {
    private static final String LOG_TAG_HTTP_CHANNEL = "HttpChannel";
    private URL url;
    private ReadableByteChannel ch;
    private long pos;
    private long length;

    public HttpChannel(URL url) {
        this.url = url;
    }

    public long position() throws IOException {
        return this.pos;
    }

    public SeekableByteChannel setPosition(long newPosition) throws IOException {
        if (newPosition == this.pos) {
            return this;
        }
        if (this.ch != null) {
            this.ch.close();
            this.ch = null;
        }
        this.pos = newPosition;
        Log.d((String)LOG_TAG_HTTP_CHANNEL, (String)("Seeking to: " + newPosition));
        return this;
    }

    public long size() throws IOException {
        return this.length;
    }

    public SeekableByteChannel truncate(long size) throws IOException {
        throw new IOException("Truncate on HTTP is not supported.");
    }

    public int read(ByteBuffer buffer) throws IOException {
        this.ensureOpen();
        int read = this.ch.read(buffer);
        if (read != -1) {
            this.pos += (long)read;
        }
        return read;
    }

    public int write(ByteBuffer buffer) throws IOException {
        throw new IOException("Write to HTTP is not supported.");
    }

    public boolean isOpen() {
        return this.ch != null && this.ch.isOpen();
    }

    public void close() throws IOException {
        this.ch.close();
    }

    private void ensureOpen() throws IOException {
        if (this.ch == null) {
            URLConnection connection = this.url.openConnection();
            if (this.pos > 0L) {
                connection.addRequestProperty("Range", "bytes=" + this.pos + "-");
            }
            this.ch = Channels.newChannel(connection.getInputStream());
            String resp = connection.getHeaderField("Content-Range");
            if (resp != null) {
                Log.d((String)LOG_TAG_HTTP_CHANNEL, (String)resp);
                this.length = Long.parseLong(resp.split("/")[1]);
            } else {
                resp = connection.getHeaderField("Content-Length");
                Log.d((String)LOG_TAG_HTTP_CHANNEL, (String)resp);
                this.length = Long.parseLong(resp);
            }
        }
    }
}

