/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.io;

import android.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.jcodec.common.io.SeekableByteChannel;

public class TiledChannel
implements SeekableByteChannel {
    private static final String LOG_TAG_TILED_CHANNEL = "TiledChannel";
    private static final int TILE_CAPACITY = 524288;
    private SeekableByteChannel ch;
    private Tile cur;
    private long pos;

    public TiledChannel(SeekableByteChannel ch) {
        this.ch = ch;
        this.cur = new Tile();
    }

    public long position() throws IOException {
        return this.pos;
    }

    public SeekableByteChannel setPosition(long newPosition) throws IOException {
        if (newPosition > this.size()) {
            newPosition = this.size();
        }
        if (newPosition < 0L) {
            newPosition = 0L;
        }
        this.pos = newPosition;
        if (this.cur.in(newPosition)) {
            return this;
        }
        long tileStart = newPosition - newPosition % 524288L;
        this.cur.reset(tileStart);
        this.ch.setPosition(tileStart);
        Log.d((String)LOG_TAG_TILED_CHANNEL, (String)("Seeking to: " + newPosition + ", tile @" + this.cur.tileStart));
        return this;
    }

    public long size() throws IOException {
        return this.ch.size();
    }

    public SeekableByteChannel truncate(long size) throws IOException {
        throw new IOException("Truncate on HTTP is not supported.");
    }

    public int read(ByteBuffer buffer) throws IOException {
        int read;
        if (this.cur.eof()) {
            return -1;
        }
        int startRem = buffer.remaining();
        do {
            read = this.cur.readTo(buffer);
            if (buffer.hasRemaining()) {
                this.cur.fetch((ReadableByteChannel)this.ch);
                if (this.cur.eof()) break;
            }
            this.pos += (long)read;
        } while (buffer.hasRemaining());
        read = startRem - buffer.remaining();
        Log.d((String)LOG_TAG_TILED_CHANNEL, (String)("Read: " + read));
        return read == 0 && this.cur.eof() ? -1 : read;
    }

    public int write(ByteBuffer buffer) throws IOException {
        throw new IOException("Write to HTTP is not supported.");
    }

    public boolean isOpen() {
        return this.ch.isOpen();
    }

    public void close() throws IOException {
        this.ch.close();
    }

    private class Tile {
        private byte[] data = new byte[524288];
        private long tileStart;
        private int tileLength;

        public boolean in(long newPosition) {
            return newPosition >= this.tileStart && newPosition < this.tileStart + (long)this.tileLength;
        }

        public void reset(long newStart) {
            this.tileLength = 0;
            this.tileStart = newStart;
        }

        public int readTo(ByteBuffer buffer) {
            int tilePos = (int)(TiledChannel.this.pos - this.tileStart);
            int tileRemaining = Math.max(0, this.tileLength - tilePos);
            int toRead = 0;
            if (tileRemaining > 0) {
                toRead = Math.min(buffer.remaining(), tileRemaining);
                buffer.put(this.data, tilePos, toRead);
            }
            return toRead;
        }

        public boolean eof() {
            return this.tileLength == -1;
        }

        public void fetch(ReadableByteChannel ch) throws IOException {
            ByteBuffer wrap = ByteBuffer.wrap(this.data);
            int r = 0;
            while (wrap.hasRemaining() && (r = ch.read(wrap)) != -1) {
            }
            this.tileStart += (long)this.tileLength;
            int read = this.data.length - wrap.remaining();
            this.tileLength = read == 0 && r == -1 ? -1 : read;
            Log.d((String)TiledChannel.LOG_TAG_TILED_CHANNEL, (String)("Tile " + this.tileStart + " - " + (this.tileStart + (long)this.tileLength)));
        }
    }
}

