/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.scale;

import android.graphics.Bitmap;
import java.nio.Buffer;
import java.nio.IntBuffer;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;

public class BitmapUtil {
    private static ThreadLocal<BitmapUtil> inst = new ThreadLocal();
    private int[] buffer;

    private static BitmapUtil inst() {
        BitmapUtil i = inst.get();
        if (i == null) {
            i = new BitmapUtil();
            inst.set(i);
        }
        return i;
    }

    public static Picture fromBitmap(Bitmap src) {
        return BitmapUtil.inst().fromBitmapImpl(src);
    }

    public static void fromBitmap(Bitmap src, Picture dst) {
        BitmapUtil.inst().fromBitmapImpl(src, dst);
    }

    public static Bitmap toBitmap(Picture pic) {
        return BitmapUtil.inst().toBitmapImpl(pic);
    }

    public static void toBitmap(Picture src, Bitmap dst) {
        BitmapUtil.inst().toBitmapImpl(src, dst);
    }

    public Picture fromBitmapImpl(Bitmap src) {
        if (src == null) {
            return null;
        }
        Picture dst = Picture.create((int)src.getWidth(), (int)src.getHeight(), (ColorSpace)ColorSpace.RGB);
        this.fromBitmapImpl(src, dst);
        return dst;
    }

    public void fromBitmapImpl(Bitmap src, Picture dst) {
        byte[] dstData = dst.getPlaneData(0);
        int[] packed = this.getBuffer(src.getWidth(), src.getHeight());
        src.getPixels(packed, 0, src.getWidth(), 0, 0, src.getWidth(), src.getHeight());
        int srcOff = 0;
        int dstOff = 0;
        for (int i = 0; i < src.getHeight(); ++i) {
            int j = 0;
            while (j < src.getWidth()) {
                int rgb = packed[srcOff];
                dstData[dstOff] = (byte)((rgb >> 16 & 0xFF) - 128);
                dstData[dstOff + 1] = (byte)((rgb >> 8 & 0xFF) - 128);
                dstData[dstOff + 2] = (byte)((rgb & 0xFF) - 128);
                ++j;
                ++srcOff;
                dstOff += 3;
            }
        }
    }

    public Bitmap toBitmapImpl(Picture pic) {
        if (pic == null) {
            return null;
        }
        Bitmap dst = Bitmap.createBitmap((int)pic.getCroppedWidth(), (int)pic.getCroppedHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.toBitmapImpl(pic, dst);
        return dst;
    }

    public void toBitmapImpl(Picture src, Bitmap dst) {
        byte[] srcData = src.getPlaneData(0);
        int[] packed = this.getBuffer(src.getWidth(), src.getHeight());
        int dstOff = 0;
        int srcOff = 0;
        for (int i = 0; i < src.getCroppedHeight(); ++i) {
            int j = 0;
            while (j < src.getCroppedWidth()) {
                packed[dstOff] = 0xFF000000 | srcData[srcOff + 2] + 128 << 16 | srcData[srcOff + 1] + 128 << 8 | srcData[srcOff] + 128;
                ++j;
                ++dstOff;
                srcOff += 3;
            }
            srcOff += src.getWidth() - src.getCroppedWidth();
        }
        dst.copyPixelsFromBuffer((Buffer)IntBuffer.wrap(packed));
    }

    private int[] getBuffer(int width, int height) {
        if (this.buffer == null || this.buffer.length != width * height) {
            this.buffer = new int[width * height];
        }
        return this.buffer;
    }
}

