/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GitTool
extends ToolInstallation
implements NodeSpecific<GitTool>,
EnvironmentSpecific<GitTool> {
    public static final transient String DEFAULT = "Default";
    private static final Logger LOGGER = Logger.getLogger(GitTool.class.getName());

    @DataBoundConstructor
    public GitTool(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public String getGitExe() {
        return this.getHome();
    }

    private static GitTool[] getInstallations(DescriptorImpl descriptor) {
        GitTool[] installations = null;
        try {
            installations = (GitTool[])descriptor.getInstallations();
        }
        catch (NullPointerException e) {
            installations = new GitTool[]{};
        }
        return installations;
    }

    public GitTool forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new GitTool(this.getName(), this.translateFor(node, log), Collections.emptyList());
    }

    public GitTool forEnvironment(EnvVars environment) {
        return new GitTool(this.getName(), environment.expand(this.getHome()), Collections.emptyList());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptor(GitTool.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<GitTool> {
        public DescriptorImpl() {
            this.setInstallations(new GitTool[0]);
            this.load();
            GitTool[] installations = (GitTool[])this.getInstallations();
            if (installations == null || installations.length == 0) {
                String defaultGitExe = Functions.isWindows() ? "git.exe" : "git";
                GitTool tool = new GitTool(GitTool.DEFAULT, defaultGitExe, Collections.emptyList());
                this.setInstallations(new GitTool[]{tool});
                this.save();
            }
        }

        public String getDisplayName() {
            return "Git";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            super.configure(req, json);
            this.save();
            return true;
        }

        public FormValidation doCheckHome(@QueryParameter File value) throws IOException, ServletException {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            String path = value.getPath();
            return FormValidation.validateExecutable((String)path);
        }

        public GitTool getInstallation(String name) {
            for (GitTool i : (GitTool[])this.getInstallations()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }
    }
}

