/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import hudson.EnvVars;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CliGitAPIImpl
implements IGitAPI {
    Launcher launcher;
    File workspace;
    TaskListener listener;
    String gitExe;
    EnvVars environment;

    public CliGitAPIImpl(String gitExe, File workspace, TaskListener listener, EnvVars environment) {
        this.workspace = workspace;
        this.listener = listener;
        this.gitExe = gitExe;
        this.environment = environment;
        this.launcher = new Launcher.LocalLauncher(IGitAPI.verbose ? listener : TaskListener.NULL);
    }

    @Override
    public IGitAPI subGit(String subdir) {
        return new CliGitAPIImpl(this.gitExe, new File(this.workspace, subdir), this.listener, this.environment);
    }

    private int[] getGitVersion() {
        int minorVer = 1;
        int majorVer = 6;
        try {
            String v = this.firstLine(this.launchCommand("--version")).trim();
            this.listener.getLogger().println("git --version\n" + v);
            Pattern p = Pattern.compile("git version ([0-9]+)\\.([0-9+])\\..*");
            Matcher m = p.matcher(v);
            if (m.matches() && m.groupCount() >= 2) {
                try {
                    majorVer = Integer.parseInt(m.group(1));
                    minorVer = Integer.parseInt(m.group(2));
                }
                catch (NumberFormatException e) {}
            }
        }
        catch (GitException ex) {
            this.listener.getLogger().println("Error trying to determine the git version: " + ex.getMessage());
            this.listener.getLogger().println("Assuming 1.6");
        }
        return new int[]{majorVer, minorVer};
    }

    @Override
    public void init() throws GitException {
        if (this.hasGitRepo()) {
            throw new GitException(".git directory already exists! Has it already been initialised?");
        }
        try {
            Repository repo = this.getRepository();
            repo.create();
        }
        catch (IOException ioe) {
            throw new GitException("Error initiating git repo.", ioe);
        }
    }

    @Override
    public boolean hasGitRepo() throws GitException {
        if (this.hasGitRepo(".git")) {
            try {
                this.launchCommand("rev-parse", "--is-inside-work-tree");
            }
            catch (Exception ex) {
                ex.printStackTrace(this.listener.error("Workspace has a .git repository, but it appears to be corrupt."));
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasGitRepo(String GIT_DIR) throws GitException {
        try {
            File dotGit = new File(this.workspace, GIT_DIR);
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .git. Are you sure you have correct permissions?", ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .git", e);
        }
    }

    @Override
    public boolean hasGitModules() throws GitException {
        try {
            File dotGit = new File(this.workspace, ".gitmodules");
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .gitmodules. Are you sure you have correct permissions?", ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .gitmodules", e);
        }
    }

    @Override
    public List<IndexEntry> getSubmodules(String treeIsh) throws GitException {
        List<IndexEntry> submodules = this.lsTree(treeIsh);
        Iterator<IndexEntry> it = submodules.iterator();
        while (it.hasNext()) {
            if (it.next().getMode().equals("160000")) continue;
            it.remove();
        }
        return submodules;
    }

    @Override
    public void fetch(String remote, RefSpec refspec) throws GitException {
        this.listener.getLogger().println("Fetching upstream changes" + (remote != null ? " from " + remote : ""));
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"fetch", "-t"});
        if (remote != null) {
            args.add(remote);
            if (refspec != null) {
                args.add(refspec.toString());
            }
        }
        this.launchCommand(args);
    }

    public void fetch() throws GitException {
        this.fetch(null, null);
    }

    public void reset(boolean hard) throws GitException {
        try {
            this.validateRevision("HEAD");
        }
        catch (GitException e) {
            this.listener.getLogger().println("No valid HEAD. Skipping the resetting");
            return;
        }
        this.listener.getLogger().println("Resetting working tree");
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add("reset");
        if (hard) {
            args.add("--hard");
        }
        this.launchCommand(args);
    }

    @Override
    public void clone(String url, String origin, boolean useShallowClone, String reference) throws GitException {
        this.listener.getLogger().println("Cloning repository " + url);
        int[] gitVer = this.getGitVersion();
        try {
            Util.deleteRecursive((File)this.workspace);
        }
        catch (Exception e) {
            e.printStackTrace(this.listener.error("Failed to clean the workspace"));
            throw new GitException("Failed to delete workspace", e);
        }
        try {
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add("clone");
            if (gitVer[0] >= 1 && gitVer[1] >= 7) {
                args.add("--progress");
            }
            if (reference != null && !reference.equals("")) {
                File referencePath = new File(reference);
                if (!referencePath.exists()) {
                    throw new GitException("Reference path does not exist: " + reference);
                }
                if (!referencePath.isDirectory()) {
                    throw new GitException("Reference path is not a directory: " + reference);
                }
                args.add(new String[]{"--reference", reference});
            }
            args.add(new String[]{"-o", origin});
            if (useShallowClone) {
                args.add(new String[]{"--depth", "1"});
            }
            args.add(url);
            args.add(this.workspace.getAbsolutePath());
            this.launchCommandIn(args, null);
        }
        catch (Exception e) {
            throw new GitException("Could not clone " + url, e);
        }
    }

    @Override
    public void clean() throws GitException {
        this.reset(true);
        this.launchCommand("clean", "-fdx");
    }

    @Override
    public ObjectId revParse(String revName) throws GitException {
        String arg = revName + "^{commit}";
        if (Functions.isWindows()) {
            arg = '\"' + arg + '\"';
        }
        String result = this.launchCommand("rev-parse", arg);
        return ObjectId.fromString((String)this.firstLine(result).trim());
    }

    public ObjectId validateRevision(String revName) throws GitException {
        String result = this.launchCommand("rev-parse", "--verify", revName);
        return ObjectId.fromString((String)this.firstLine(result).trim());
    }

    public String describe(String commitIsh) throws GitException {
        String result = this.launchCommand("describe", "--tags", commitIsh);
        return this.firstLine(result).trim();
    }

    @Override
    public void prune(RemoteConfig repository) throws GitException {
        if (this.getRemoteUrl(repository.getName()) != null && !this.getRemoteUrl(repository.getName()).equals("")) {
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{"remote", "prune", repository.getName()});
            this.launchCommand(args);
        }
    }

    private String firstLine(String result) {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(result));
        try {
            line = reader.readLine();
            if (line == null) {
                return null;
            }
            if (reader.readLine() != null) {
                throw new GitException("Result has multiple lines");
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing result", e);
        }
        return line;
    }

    @Override
    public void changelog(String revFrom, String revTo, OutputStream outputStream) throws GitException {
        String revSpec = revFrom + ".." + revTo;
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.gitExe, "whatchanged"});
        args.add(new String[]{"--no-abbrev", "-M", "--pretty=raw"});
        args.add(revSpec);
        try {
            if (this.launcher.launch().cmds(args).envs((Map)this.environment).stdout(outputStream).pwd(this.workspace).join() != 0) {
                throw new GitException("Error launching git whatchanged");
            }
        }
        catch (Exception e) {
            throw new GitException("Error performing git whatchanged", e);
        }
    }

    @Override
    public List<String> showRevision(ObjectId from, ObjectId to) throws GitException {
        StringWriter writer = new StringWriter();
        if (from != null) {
            writer.write(this.launchCommand("show", "--no-abbrev", "--format=raw", "-M", "--raw", from.name() + ".." + to.name()));
            writer.write("\\n");
        }
        writer.write(this.launchCommand("whatchanged", "--no-abbrev", "-M", "-m", "--pretty=raw", "-1", to.name()));
        String result = writer.toString();
        ArrayList<String> revShow = new ArrayList<String>();
        if (result != null) {
            revShow = new ArrayList<String>(Arrays.asList(result.split("\\n")));
        }
        return revShow;
    }

    @Override
    public void merge(ObjectId revSpec) throws GitException {
        try {
            this.launchCommand("merge", revSpec.name());
        }
        catch (GitException e) {
            throw new GitException("Could not merge " + revSpec, e);
        }
    }

    public void submoduleInit() throws GitException {
        this.launchCommand("submodule", "init");
    }

    public void submoduleSync() throws GitException {
        this.launchCommand("submodule", "sync");
    }

    @Override
    public void submoduleUpdate(boolean recursive) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"submodule", "update"});
        if (recursive) {
            args.add(new String[]{"--init", "--recursive"});
        }
        this.launchCommand(args);
    }

    public void submoduleReset(boolean recursive, boolean hard) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"submodule", "foreach"});
        if (recursive) {
            args.add("--recursive");
        }
        args.add("git reset");
        if (hard) {
            args.add("--hard");
        }
        this.launchCommand(args);
    }

    @Override
    public void submoduleClean(boolean recursive) throws GitException {
        this.submoduleReset(true, true);
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"submodule", "foreach"});
        if (recursive) {
            args.add("--recursive");
        }
        args.add("git clean -fdx");
        this.launchCommand(args);
    }

    public String getSubmoduleUrl(String name) throws GitException {
        String result = this.launchCommand("config", "--get", "submodule." + name + ".url");
        return this.firstLine(result).trim();
    }

    public void setSubmoduleUrl(String name, String url) throws GitException {
        this.launchCommand("config", "submodule." + name + ".url", url);
    }

    @Override
    public String getRemoteUrl(String name) throws GitException {
        String result = this.launchCommand("config", "--get", "remote." + name + ".url");
        return this.firstLine(result).trim();
    }

    @Override
    public void setRemoteUrl(String name, String url) throws GitException {
        this.launchCommand("config", "remote." + name + ".url", url);
    }

    public String getRemoteUrl(String name, String GIT_DIR) throws GitException {
        String result = this.launchCommand("--git-dir=" + GIT_DIR, "config", "--get", "remote." + name + ".url");
        return this.firstLine(result).trim();
    }

    public void setRemoteUrl(String name, String url, String GIT_DIR) throws GitException {
        this.launchCommand("--git-dir=" + GIT_DIR, "config", "remote." + name + ".url", url);
    }

    public String getDefaultRemote(String _default_) throws GitException {
        BufferedReader rdr = new BufferedReader(new StringReader(this.launchCommand("remote")));
        ArrayList<String> remotes = new ArrayList<String>();
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                remotes.add(line);
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing remotes", e);
        }
        if (remotes.contains(_default_)) {
            return _default_;
        }
        if (remotes.size() >= 1) {
            return (String)remotes.get(0);
        }
        throw new GitException("No remotes found!");
    }

    public String getDefaultRemote() throws GitException {
        return this.getDefaultRemote("origin");
    }

    public boolean isBareRepository() throws GitException {
        return this.isBareRepository("");
    }

    public boolean isBareRepository(String GIT_DIR) throws GitException {
        String ret = null;
        if ("".equals(GIT_DIR)) {
            ret = this.launchCommand("rev-parse", "--is-bare-repository");
        } else {
            String gitDir = "--git-dir=" + GIT_DIR;
            ret = this.launchCommand(gitDir, "rev-parse", "--is-bare-repository");
        }
        return !"false".equals(this.firstLine(ret).trim());
    }

    private String pathJoin(String a, String b) {
        return new File(a, b).toString();
    }

    public void fixSubmoduleUrls(String remote, TaskListener listener) throws GitException {
        URI origin;
        boolean is_bare = true;
        try {
            String url = this.getRemoteUrl(remote);
            String gitEnd = this.pathJoin("", ".git");
            if (url.endsWith(gitEnd)) {
                url = url.substring(0, url.length() - gitEnd.length());
                is_bare = false;
            }
            origin = new URI(url);
        }
        catch (URISyntaxException e) {
            return;
        }
        catch (Exception e) {
            throw new GitException("Could determine remote.origin.url", e);
        }
        if (origin.getScheme() == null || "file".equalsIgnoreCase(origin.getScheme()) && (origin.getHost() == null || "".equals(origin.getHost()))) {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(origin.getPath());
            paths.add(this.pathJoin(origin.getPath(), ".git"));
            for (String path : paths) {
                try {
                    is_bare = this.isBareRepository(path);
                    break;
                }
                catch (GitException e) {
                }
            }
        }
        if (!is_bare) {
            try {
                List<IndexEntry> submodules = this.getSubmodules("HEAD");
                for (IndexEntry submodule : submodules) {
                    String sUrl = this.pathJoin(origin.getPath(), submodule.getFile());
                    this.setSubmoduleUrl(submodule.getFile(), sUrl);
                    String subGitDir = this.pathJoin(submodule.getFile(), ".git");
                    if (!this.hasGitRepo(subGitDir) || "".equals(this.getRemoteUrl("origin", subGitDir))) continue;
                    this.setRemoteUrl("origin", sUrl, subGitDir);
                }
            }
            catch (GitException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void setupSubmoduleUrls(Revision rev, TaskListener listener) throws GitException {
        String remote = null;
        for (Branch br : rev.getBranches()) {
            int slash;
            String b = br.getName();
            if (b != null && (slash = b.indexOf(47)) != -1) {
                remote = this.getDefaultRemote(b.substring(0, slash));
            }
            if (remote == null) continue;
            break;
        }
        if (remote == null) {
            remote = this.getDefaultRemote();
        }
        if (remote != null) {
            this.setupSubmoduleUrls(remote, listener);
        }
    }

    private void setupSubmoduleUrls(String remote, TaskListener listener) throws GitException {
        this.submoduleInit();
        this.submoduleSync();
        this.fixSubmoduleUrls(remote, listener);
    }

    @Override
    public void tag(String tagName, String comment) throws GitException {
        tagName = tagName.replace(' ', '_');
        try {
            this.launchCommand("tag", "-a", "-f", "-m", comment, tagName);
        }
        catch (GitException e) {
            throw new GitException("Could not apply tag " + tagName, e);
        }
    }

    @Override
    public void appendNote(String note, String namespace) throws GitException {
        try {
            this.launchCommand("notes", "--ref=" + namespace, "append", "-m", "'" + note + "'");
        }
        catch (GitException e) {
            throw new GitException("Could not apply note " + note, e);
        }
    }

    @Override
    public void addNote(String note, String namespace) throws GitException {
        try {
            this.launchCommand("notes", "--ref=" + namespace, "add", "-m", "'" + note + "'");
        }
        catch (GitException e) {
            throw new GitException("Could not apply note " + note, e);
        }
    }

    public String launchCommand(ArgumentListBuilder args) throws GitException {
        return this.launchCommandIn(args, this.workspace);
    }

    public String launchCommand(String ... args) throws GitException {
        return this.launchCommand(new ArgumentListBuilder(args));
    }

    private String launchCommandIn(ArgumentListBuilder args, File workDir) throws GitException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            this.environment.put("GIT_ASKPASS", this.launcher.isUnix() ? "/bin/echo" : "echo");
            args.prepend(new String[]{this.gitExe});
            Launcher.ProcStarter p = this.launcher.launch().cmds(args.toCommandArray()).envs((Map)this.environment).stdout((OutputStream)fos).stderr((OutputStream)err);
            if (workDir != null) {
                p.pwd(workDir);
            }
            int status = p.join();
            String result = fos.toString();
            if (status != 0) {
                throw new GitException("Command \"" + StringUtils.join((Object[])args.toCommandArray(), (String)" ") + "\" returned status code " + status + ":\nstdout: " + result + "\nstderr: " + err.toString());
            }
            return result;
        }
        catch (GitException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GitException("Error performing command: " + StringUtils.join((Object[])args.toCommandArray(), (String)" "), e);
        }
    }

    @Override
    public void push(String remoteName, String refspec) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"push", remoteName});
        if (refspec != null) {
            args.add(refspec);
        }
        this.launchCommand(args);
    }

    private Set<Branch> parseBranches(String fos) throws GitException {
        HashSet<Branch> branches = new HashSet<Branch>();
        BufferedReader rdr = new BufferedReader(new StringReader(fos));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                if ((line = line.substring(2)).startsWith("(") || line.indexOf(" -> ") != -1) continue;
                branches.add(new Branch(line, this.revParse(line)));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing branches", e);
        }
        return branches;
    }

    @Override
    public Set<Branch> getBranches() throws GitException {
        return this.parseBranches(this.launchCommand("branch", "-a"));
    }

    @Override
    public Set<Branch> getRemoteBranches() throws GitException {
        try {
            Repository db = this.getRepository();
            Map refs = db.getAllRefs();
            HashSet<Branch> branches = new HashSet<Branch>();
            for (Ref candidate : refs.values()) {
                if (!candidate.getName().startsWith("refs/remotes/")) continue;
                Branch buildBranch = new Branch(candidate);
                this.listener.getLogger().println("Seen branch in repository " + buildBranch.getName());
                branches.add(buildBranch);
            }
            return branches;
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void checkout(String commit) throws GitException {
        this.launchCommand("checkout", "-f", commit);
    }

    @Override
    public void checkout(String ref, String branch) throws GitException {
        this.launchCommand("checkout", "-b", branch, ref);
    }

    @Override
    public boolean tagExists(String tagName) throws GitException {
        return this.launchCommand("tag", "-l", tagName).trim().equals(tagName);
    }

    @Override
    public void deleteBranch(String name) throws GitException {
        try {
            this.launchCommand("branch", "-D", name);
        }
        catch (GitException e) {
            throw new GitException("Could not delete branch " + name, e);
        }
    }

    @Override
    public void deleteTag(String tagName) throws GitException {
        tagName = tagName.replace(' ', '_');
        try {
            this.launchCommand("tag", "-d", tagName);
        }
        catch (GitException e) {
            throw new GitException("Could not delete tag " + tagName, e);
        }
    }

    public List<IndexEntry> lsTree(String treeIsh) throws GitException {
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        String result = this.launchCommand("ls-tree", treeIsh);
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                String[] entry = line.split("\\s+");
                entries.add(new IndexEntry(entry[0], entry[1], entry[2], entry[3]));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing ls tree", e);
        }
        return entries;
    }

    @Override
    public List<ObjectId> revListAll() throws GitException {
        return this.revList("--all");
    }

    public List<ObjectId> revList(String ... extraArgs) throws GitException {
        ArrayList<ObjectId> entries = new ArrayList<ObjectId>();
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"rev-list"});
        args.add(extraArgs);
        String result = this.launchCommand(args);
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                entries.add(ObjectId.fromString((String)line));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing rev list", e);
        }
        return entries;
    }

    @Override
    public boolean isCommitInRepo(ObjectId commit) {
        try {
            List<ObjectId> revs = this.revList(commit.name());
            return revs.size() != 0;
        }
        catch (GitException e) {
            return false;
        }
    }

    @Override
    public void add(String filePattern) throws GitException {
        try {
            this.launchCommand("add", filePattern);
        }
        catch (GitException e) {
            throw new GitException("Cannot add " + filePattern, e);
        }
    }

    @Override
    public void branch(String name) throws GitException {
        try {
            this.launchCommand("branch", name);
        }
        catch (GitException e) {
            throw new GitException("Cannot create branch " + name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(String message) throws GitException {
        File f = null;
        try {
            f = File.createTempFile("gitcommit", ".txt");
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                fos.write(message.getBytes());
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
            this.launchCommand("commit", "-F", f.getAbsolutePath());
        }
        catch (GitException e) {
            throw new GitException("Cannot commit " + message, e);
        }
        catch (FileNotFoundException e) {
            throw new GitException("Cannot commit " + message, e);
        }
        catch (IOException e) {
            throw new GitException("Cannot commit " + message, e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    @Override
    public Repository getRepository() throws IOException {
        return new FileRepository(new File(this.workspace, ".git"));
    }

    @Override
    public Set<String> getTagNames(String tagPattern) throws GitException {
        try {
            String tag;
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{"tag", "-l", tagPattern});
            String result = this.launchCommandIn(args, this.workspace);
            HashSet<String> tags = new HashSet<String>();
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            while ((tag = rdr.readLine()) != null) {
                tags.add(tag);
            }
            return tags;
        }
        catch (Exception e) {
            throw new GitException("Error retrieving tag names", e);
        }
    }

    @Override
    public ObjectId getHeadRev(String remoteRepoUrl, String branch) throws GitException {
        String[] branchExploded = branch.split("/");
        branch = branchExploded[branchExploded.length - 1];
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"ls-remote"});
        args.add("-h");
        args.add(remoteRepoUrl);
        args.add(branch);
        String result = this.launchCommand(args);
        return result.length() >= 40 ? ObjectId.fromString((String)result.substring(0, 40)) : null;
    }
}

