/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.jenkinsci.plugins.gitclient.CliGitAPIImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGitAPIImpl
implements IGitAPI {
    private final IGitAPI delegate;
    private final File workspace;
    private final TaskListener listener;

    public JGitAPIImpl(String gitExe, File workspace, TaskListener listener, EnvVars environment) {
        this(new CliGitAPIImpl(gitExe, workspace, listener, environment), workspace, listener);
    }

    private JGitAPIImpl(IGitAPI delegate, File workspace, TaskListener listener) {
        this.delegate = delegate;
        this.workspace = workspace;
        this.listener = listener;
    }

    @Override
    public IGitAPI subGit(String subdir) {
        return new JGitAPIImpl(this.delegate, new File(this.workspace, subdir), this.listener);
    }

    @Override
    public void init() throws GitException {
        try {
            Git.init().setDirectory(this.workspace).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkout(String commit) throws GitException {
        try {
            Git git = Git.open((File)this.workspace);
            Repository repo = git.getRepository();
            Ref head = repo.getRef("HEAD");
            RevWalk revWalk = new RevWalk(repo);
            ObjectId headId = head.getObjectId();
            RevCommit headCommit = headId == null ? null : revWalk.parseCommit((AnyObjectId)headId);
            RevTree headTree = headCommit == null ? null : headCommit.getTree();
            ObjectId target = ObjectId.fromString((String)commit);
            RevCommit newCommit = revWalk.parseCommit((AnyObjectId)target);
            DirCache dc = repo.lockDirCache();
            try {
                DirCacheCheckout dco = new DirCacheCheckout(repo, (ObjectId)headTree, dc, (ObjectId)newCommit.getTree());
                dco.setFailOnConflict(true);
                dco.checkout();
            }
            finally {
                dc.unlock();
            }
            RefUpdate refUpdate = repo.updateRef("HEAD", true);
            refUpdate.setForceUpdate(true);
            refUpdate.setRefLogMessage("checkout: moving to " + commit, false);
            refUpdate.setNewObjectId((AnyObjectId)newCommit);
            refUpdate.forceUpdate();
        }
        catch (IOException e) {
            throw new GitException("Could not checkout " + commit, e);
        }
    }

    @Override
    public void checkout(String ref, String branch) throws GitException {
        try {
            Git git = Git.open((File)this.workspace);
            git.checkout().setName(branch).setForce(true).setStartPoint(ref).call();
        }
        catch (IOException e) {
            throw new GitException("Could not checkout " + branch + " with start point " + ref, e);
        }
        catch (GitAPIException e) {
            throw new GitException("Could not checkout " + branch + " with start point " + ref, e);
        }
    }

    @Override
    public void add(String filePattern) throws GitException {
        try {
            Git git = Git.open((File)this.workspace);
            git.add().addFilepattern(filePattern).call();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void commit(String message) throws GitException {
        try {
            Git git = Git.open((File)this.workspace);
            git.commit().setMessage(message).call();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void branch(String name) throws GitException {
        try {
            Git git = Git.open((File)this.workspace);
            git.branchCreate().setName(name).call();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void deleteBranch(String name) throws GitException {
        try {
            Git git = Git.open((File)this.workspace);
            git.branchDelete().setBranchNames(new String[]{name}).call();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public Set<Branch> getBranches() throws GitException {
        try {
            Git git = Git.open((File)this.workspace);
            List refs = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
            HashSet<Branch> branches = new HashSet<Branch>(refs.size());
            for (Ref ref : refs) {
                branches.add(new Branch(ref));
            }
            return branches;
        }
        catch (IOException e) {
            throw new GitException(e);
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public Set<Branch> getRemoteBranches() throws GitException {
        try {
            Git git = Git.open((File)this.workspace);
            List refs = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
            HashSet<Branch> branches = new HashSet<Branch>(refs.size());
            for (Ref ref : refs) {
                branches.add(new Branch(ref));
            }
            return branches;
        }
        catch (IOException e) {
            throw new GitException(e);
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void tag(String name, String message) throws GitException {
        try {
            Git git = Git.open((File)this.workspace);
            git.tag().setName(name).setMessage(message).call();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public boolean tagExists(String tagName) throws GitException {
        try {
            Git git = Git.open((File)this.workspace);
            Ref tag = git.getRepository().getRefDatabase().getRef("refs/tags/" + tagName);
            return tag != null;
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void fetch(String remote, RefSpec refspec) throws GitException {
        this.delegate.fetch(remote, refspec);
    }

    @Override
    public ObjectId getHeadRev(String remoteRepoUrl, String branch) throws GitException {
        return this.delegate.getHeadRev(remoteRepoUrl, branch);
    }

    @Override
    public String getRemoteUrl(String name) throws GitException {
        try {
            Git git = Git.open((File)this.workspace);
            return git.getRepository().getConfig().getString("remote", name, "url");
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public Repository getRepository() throws IOException {
        try {
            Git git = Git.open((File)this.workspace);
            return git.getRepository();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void addNote(String note, String namespace) throws GitException {
        this.delegate.addNote(note, namespace);
    }

    @Override
    public void appendNote(String note, String namespace) throws GitException {
        this.delegate.appendNote(note, namespace);
    }

    @Override
    public void changelog(String revFrom, String revTo, OutputStream fos) throws GitException {
        this.delegate.changelog(revFrom, revTo, fos);
    }

    @Override
    public void clean() throws GitException {
        this.delegate.clean();
    }

    @Override
    public void clone(String url, String origin, boolean useShallowClone, String reference) throws GitException {
        this.delegate.clone(url, origin, useShallowClone, reference);
    }

    @Override
    public void deleteTag(String tagName) throws GitException {
        this.delegate.deleteTag(tagName);
    }

    @Override
    public List<IndexEntry> getSubmodules(String treeIsh) throws GitException {
        return this.delegate.getSubmodules(treeIsh);
    }

    @Override
    public Set<String> getTagNames(String tagPattern) throws GitException {
        return this.delegate.getTagNames(tagPattern);
    }

    @Override
    public boolean hasGitModules() throws GitException {
        return this.delegate.hasGitModules();
    }

    @Override
    public boolean hasGitRepo() throws GitException {
        return this.delegate.hasGitRepo();
    }

    @Override
    public boolean isCommitInRepo(ObjectId commit) throws GitException {
        return this.delegate.isCommitInRepo(commit);
    }

    @Override
    public void merge(ObjectId revSpec) throws GitException {
        try {
            Git git = Git.open((File)this.workspace);
            Repository db = git.getRepository();
            git.merge().include((AnyObjectId)revSpec).call();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
        catch (GitAPIException e) {
            throw new GitException("Failed to merge " + revSpec, e);
        }
    }

    @Override
    public void prune(RemoteConfig repository) throws GitException {
        this.delegate.prune(repository);
    }

    @Override
    public void push(String remoteName, String revspec) throws GitException {
        this.delegate.push(remoteName, revspec);
    }

    @Override
    public List<ObjectId> revListAll() throws GitException {
        return this.delegate.revListAll();
    }

    @Override
    public ObjectId revParse(String revName) throws GitException {
        return this.delegate.revParse(revName);
    }

    @Override
    public void setRemoteUrl(String name, String url) throws GitException {
        this.delegate.setRemoteUrl(name, url);
    }

    @Override
    public void setupSubmoduleUrls(Revision rev, TaskListener listener) throws GitException {
        this.delegate.setupSubmoduleUrls(rev, listener);
    }

    @Override
    public List<String> showRevision(ObjectId from, ObjectId to) throws GitException {
        return this.delegate.showRevision(from, to);
    }

    @Override
    public void submoduleClean(boolean recursive) throws GitException {
        this.delegate.submoduleClean(recursive);
    }

    @Override
    public void submoduleUpdate(boolean recursive) throws GitException {
        this.delegate.submoduleUpdate(recursive);
    }
}

