/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.css;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.css.Color;
import kotlinx.css.CssValue;
import kotlinx.css.ExtensionsKt;
import kotlinx.css.StyleEnumsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001c\u001d\u001eB\u0017\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\r\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\r\u0010\u0017\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0018J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lkotlinx/css/Color;", "Lkotlinx/css/CssValue;", "value", "", "rgb", "(Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "blend", "backgroundColor", "darken", "percent", "", "desaturate", "fromHSLANotation", "Lkotlinx/css/Color$HSLA;", "fromHSLANotation$kotlin_css", "fromRGBANotation", "Lkotlinx/css/Color$RGBA;", "fromRGBANotation$kotlin_css", "lighten", "saturate", "toRGBA", "toRGBA$kotlin_css", "withAlpha", "alpha", "", "Companion", "HSLA", "RGBA", "kotlin-css"})
public final class Color
extends CssValue {
    private String rgb;
    @NotNull
    private final String value;
    @NotNull
    private static final Color initial;
    @NotNull
    private static final Color inherit;
    @NotNull
    private static final Color unset;
    @NotNull
    private static final Color transparent;
    @NotNull
    private static final Color currentColor;
    @NotNull
    private static final Color aliceBlue;
    @NotNull
    private static final Color antiqueWhite;
    @NotNull
    private static final Color aqua;
    @NotNull
    private static final Color aquamarine;
    @NotNull
    private static final Color azure;
    @NotNull
    private static final Color beige;
    @NotNull
    private static final Color bisque;
    @NotNull
    private static final Color black;
    @NotNull
    private static final Color blanchedAlmond;
    @NotNull
    private static final Color blue;
    @NotNull
    private static final Color blueViolet;
    @NotNull
    private static final Color brown;
    @NotNull
    private static final Color burlyWood;
    @NotNull
    private static final Color cadetBlue;
    @NotNull
    private static final Color chartreuse;
    @NotNull
    private static final Color chocolate;
    @NotNull
    private static final Color coral;
    @NotNull
    private static final Color cornflowerBlue;
    @NotNull
    private static final Color cornsilk;
    @NotNull
    private static final Color crimson;
    @NotNull
    private static final Color cyan;
    @NotNull
    private static final Color darkBlue;
    @NotNull
    private static final Color darkCyan;
    @NotNull
    private static final Color darkGoldenrod;
    @NotNull
    private static final Color darkGray;
    @NotNull
    private static final Color darkGreen;
    @NotNull
    private static final Color darkGrey;
    @NotNull
    private static final Color darkKhaki;
    @NotNull
    private static final Color darkMagenta;
    @NotNull
    private static final Color darkOliveGreen;
    @NotNull
    private static final Color darkOrange;
    @NotNull
    private static final Color darkOrchid;
    @NotNull
    private static final Color darkRed;
    @NotNull
    private static final Color darkSalmon;
    @NotNull
    private static final Color darkSeaGreen;
    @NotNull
    private static final Color darkSlateBlue;
    @NotNull
    private static final Color darkSlateGray;
    @NotNull
    private static final Color darkSlateGrey;
    @NotNull
    private static final Color darkTurquoise;
    @NotNull
    private static final Color darkViolet;
    @NotNull
    private static final Color deepPink;
    @NotNull
    private static final Color deepSkyBlue;
    @NotNull
    private static final Color dimGray;
    @NotNull
    private static final Color dimGrey;
    @NotNull
    private static final Color dodgerBlue;
    @NotNull
    private static final Color firebrick;
    @NotNull
    private static final Color floralWhite;
    @NotNull
    private static final Color forestGreen;
    @NotNull
    private static final Color fuchsia;
    @NotNull
    private static final Color gainsboro;
    @NotNull
    private static final Color ghostWhite;
    @NotNull
    private static final Color gold;
    @NotNull
    private static final Color goldenrod;
    @NotNull
    private static final Color gray;
    @NotNull
    private static final Color green;
    @NotNull
    private static final Color greenYellow;
    @NotNull
    private static final Color grey;
    @NotNull
    private static final Color honeydew;
    @NotNull
    private static final Color hotPink;
    @NotNull
    private static final Color indianRed;
    @NotNull
    private static final Color indigo;
    @NotNull
    private static final Color ivory;
    @NotNull
    private static final Color khaki;
    @NotNull
    private static final Color lavender;
    @NotNull
    private static final Color lavenderBlush;
    @NotNull
    private static final Color lawnGreen;
    @NotNull
    private static final Color lemonChiffon;
    @NotNull
    private static final Color lightBlue;
    @NotNull
    private static final Color lightCoral;
    @NotNull
    private static final Color lightCyan;
    @NotNull
    private static final Color lightGoldenrodYellow;
    @NotNull
    private static final Color lightGray;
    @NotNull
    private static final Color lightGreen;
    @NotNull
    private static final Color lightGrey;
    @NotNull
    private static final Color lightPink;
    @NotNull
    private static final Color lightSalmon;
    @NotNull
    private static final Color lightSeaGreen;
    @NotNull
    private static final Color lightSkyBlue;
    @NotNull
    private static final Color lightSlateGray;
    @NotNull
    private static final Color lightSlateGrey;
    @NotNull
    private static final Color lightSteelBlue;
    @NotNull
    private static final Color lightYellow;
    @NotNull
    private static final Color lime;
    @NotNull
    private static final Color limeGreen;
    @NotNull
    private static final Color linen;
    @NotNull
    private static final Color magenta;
    @NotNull
    private static final Color maroon;
    @NotNull
    private static final Color mediumAquamarine;
    @NotNull
    private static final Color mediumBlue;
    @NotNull
    private static final Color mediumOrchid;
    @NotNull
    private static final Color mediumPurple;
    @NotNull
    private static final Color mediumSeaGreen;
    @NotNull
    private static final Color mediumSlateBlue;
    @NotNull
    private static final Color mediumSpringGreen;
    @NotNull
    private static final Color mediumTurquoise;
    @NotNull
    private static final Color mediumVioletRed;
    @NotNull
    private static final Color midnightBlue;
    @NotNull
    private static final Color mintCream;
    @NotNull
    private static final Color mistyRose;
    @NotNull
    private static final Color moccasin;
    @NotNull
    private static final Color navajoWhite;
    @NotNull
    private static final Color navy;
    @NotNull
    private static final Color oldLace;
    @NotNull
    private static final Color olive;
    @NotNull
    private static final Color oliveDrab;
    @NotNull
    private static final Color orange;
    @NotNull
    private static final Color orangeRed;
    @NotNull
    private static final Color orchid;
    @NotNull
    private static final Color paleGoldenrod;
    @NotNull
    private static final Color paleGreen;
    @NotNull
    private static final Color paleTurquoise;
    @NotNull
    private static final Color paleVioletRed;
    @NotNull
    private static final Color papayaWhip;
    @NotNull
    private static final Color peachPuff;
    @NotNull
    private static final Color peru;
    @NotNull
    private static final Color pink;
    @NotNull
    private static final Color plum;
    @NotNull
    private static final Color powderBlue;
    @NotNull
    private static final Color purple;
    @NotNull
    private static final Color red;
    @NotNull
    private static final Color rosyBrown;
    @NotNull
    private static final Color royalBlue;
    @NotNull
    private static final Color saddleBrown;
    @NotNull
    private static final Color salmon;
    @NotNull
    private static final Color sandyBrown;
    @NotNull
    private static final Color seaGreen;
    @NotNull
    private static final Color seaShell;
    @NotNull
    private static final Color sienna;
    @NotNull
    private static final Color silver;
    @NotNull
    private static final Color skyBlue;
    @NotNull
    private static final Color slateBlue;
    @NotNull
    private static final Color slateGray;
    @NotNull
    private static final Color slateGrey;
    @NotNull
    private static final Color snow;
    @NotNull
    private static final Color springGreen;
    @NotNull
    private static final Color steelBlue;
    @NotNull
    private static final Color tan;
    @NotNull
    private static final Color teal;
    @NotNull
    private static final Color thistle;
    @NotNull
    private static final Color tomato;
    @NotNull
    private static final Color turquoise;
    @NotNull
    private static final Color violet;
    @NotNull
    private static final Color wheat;
    @NotNull
    private static final Color white;
    @NotNull
    private static final Color whiteSmoke;
    @NotNull
    private static final Color yellow;
    @NotNull
    private static final Color yellowGreen;
    private static final Lazy HSLA_REGEX$delegate;
    private static final Lazy RGBA_REGEX$delegate;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Color withAlpha(double alpha) {
        Color color;
        if (StringsKt.startsWith((String)this.getValue(), (String)"hsl", (boolean)true)) {
            HSLA hSLA = this.fromHSLANotation$kotlin_css();
            boolean bl = false;
            boolean bl2 = false;
            HSLA $this$with = hSLA;
            boolean bl3 = false;
            color = StyleEnumsKt.hsla($this$with.getHue(), $this$with.getSaturation(), $this$with.getLightness(), Companion.normalizeAlpha(alpha) * $this$with.getAlpha());
        } else {
            RGBA rGBA = this.toRGBA$kotlin_css();
            boolean bl = false;
            boolean bl4 = false;
            RGBA $this$with = rGBA;
            boolean bl5 = false;
            color = StyleEnumsKt.rgba($this$with.getRed(), $this$with.getGreen(), $this$with.getBlue(), Companion.normalizeAlpha(alpha) * $this$with.getAlpha());
        }
        return color;
    }

    @NotNull
    public final Color blend(@NotNull Color backgroundColor) {
        Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
        RGBA source = this.toRGBA$kotlin_css();
        RGBA background = backgroundColor.toRGBA$kotlin_css();
        double targetR = (1.0 - source.getAlpha()) * (double)background.getRed() + source.getAlpha() * (double)source.getRed();
        double targetG = (1.0 - source.getAlpha()) * (double)background.getGreen() + source.getAlpha() * (double)source.getGreen();
        double targetB = (1.0 - source.getAlpha()) * (double)background.getBlue() + source.getAlpha() * (double)source.getBlue();
        return StyleEnumsKt.rgb(MathKt.roundToInt((double)targetR), MathKt.roundToInt((double)targetG), MathKt.roundToInt((double)targetB));
    }

    @NotNull
    public final Color lighten(int percent) {
        Color color;
        boolean isHSLA = StringsKt.startsWith((String)this.getValue(), (String)"hsl", (boolean)true);
        HSLA hsla = isHSLA ? this.fromHSLANotation$kotlin_css() : this.toRGBA$kotlin_css().asHSLA();
        int lightness = hsla.getLightness() + MathKt.roundToInt((double)((double)hsla.getLightness() * ((double)Companion.normalizePercent(percent) / 100.0)));
        HSLA newHSLa = HSLA.copy$default(hsla, 0, 0, Companion.normalizePercent(lightness), 0.0, 11, null);
        if (isHSLA) {
            color = StyleEnumsKt.hsla(newHSLa.getHue(), newHSLa.getSaturation(), newHSLa.getLightness(), newHSLa.getAlpha());
        } else {
            RGBA rGBA = newHSLa.asRGBA();
            boolean bl = false;
            boolean bl2 = false;
            RGBA $this$with = rGBA;
            boolean bl3 = false;
            color = StyleEnumsKt.rgba($this$with.getRed(), $this$with.getGreen(), $this$with.getBlue(), $this$with.getAlpha());
        }
        return color;
    }

    @NotNull
    public final Color darken(int percent) {
        Color color;
        boolean isHSLA = StringsKt.startsWith((String)this.getValue(), (String)"hsl", (boolean)true);
        HSLA hsla = isHSLA ? this.fromHSLANotation$kotlin_css() : this.toRGBA$kotlin_css().asHSLA();
        int darkness = hsla.getLightness() - MathKt.roundToInt((double)((double)hsla.getLightness() * ((double)Companion.normalizePercent(percent) / 100.0)));
        HSLA newHSLa = HSLA.copy$default(hsla, 0, 0, Companion.normalizePercent(darkness), 0.0, 11, null);
        if (isHSLA) {
            color = StyleEnumsKt.hsla(newHSLa.getHue(), newHSLa.getSaturation(), newHSLa.getLightness(), newHSLa.getAlpha());
        } else {
            RGBA rGBA = newHSLa.asRGBA();
            boolean bl = false;
            boolean bl2 = false;
            RGBA $this$with = rGBA;
            boolean bl3 = false;
            color = StyleEnumsKt.rgba($this$with.getRed(), $this$with.getGreen(), $this$with.getBlue(), $this$with.getAlpha());
        }
        return color;
    }

    @NotNull
    public final Color saturate(int percent) {
        Color color;
        boolean isHSLA = StringsKt.startsWith((String)this.getValue(), (String)"hsl", (boolean)true);
        HSLA hsla = isHSLA ? this.fromHSLANotation$kotlin_css() : this.toRGBA$kotlin_css().asHSLA();
        int saturation = hsla.getSaturation() + MathKt.roundToInt((double)((double)hsla.getSaturation() * ((double)Companion.normalizePercent(percent) / 100.0)));
        HSLA newHSLa = HSLA.copy$default(hsla, 0, Companion.normalizePercent(saturation), 0, 0.0, 13, null);
        if (isHSLA) {
            color = StyleEnumsKt.hsla(newHSLa.getHue(), newHSLa.getSaturation(), newHSLa.getLightness(), newHSLa.getAlpha());
        } else {
            RGBA rGBA = newHSLa.asRGBA();
            boolean bl = false;
            boolean bl2 = false;
            RGBA $this$with = rGBA;
            boolean bl3 = false;
            color = StyleEnumsKt.rgba($this$with.getRed(), $this$with.getGreen(), $this$with.getBlue(), $this$with.getAlpha());
        }
        return color;
    }

    @NotNull
    public final Color desaturate(int percent) {
        Color color;
        boolean isHSLA = StringsKt.startsWith((String)this.getValue(), (String)"hsl", (boolean)true);
        HSLA hsla = isHSLA ? this.fromHSLANotation$kotlin_css() : this.toRGBA$kotlin_css().asHSLA();
        int desaturation = hsla.getSaturation() - MathKt.roundToInt((double)((double)hsla.getSaturation() * ((double)Companion.normalizePercent(percent) / 100.0)));
        HSLA newHSLa = HSLA.copy$default(hsla, 0, Companion.normalizePercent(desaturation), 0, 0.0, 13, null);
        if (isHSLA) {
            color = StyleEnumsKt.hsla(newHSLa.getHue(), newHSLa.getSaturation(), newHSLa.getLightness(), newHSLa.getAlpha());
        } else {
            RGBA rGBA = newHSLa.asRGBA();
            boolean bl = false;
            boolean bl2 = false;
            RGBA $this$with = rGBA;
            boolean bl3 = false;
            color = StyleEnumsKt.rgba($this$with.getRed(), $this$with.getGreen(), $this$with.getBlue(), $this$with.getAlpha());
        }
        return color;
    }

    @NotNull
    public final HSLA fromHSLANotation$kotlin_css() {
        double d;
        double d2;
        boolean bl;
        String string;
        MatchResult match = Regex.find$default((Regex)Color.Companion.getHSLA_REGEX(), (CharSequence)this.getValue(), (int)0, (int)2, null);
        Function1<Integer, String> $fun$getHSLParameter$1 = new Function1<Integer, String>(this, match){
            final /* synthetic */ Color this$0;
            final /* synthetic */ MatchResult $match;

            @NotNull
            public final String invoke(int index) {
                Object object = this.$match;
                if (object == null || (object = object.getGroups()) == null || (object = object.get(index)) == null || (object = object.getValue()) == null) {
                    throw (Throwable)new IllegalArgumentException("Expected hsl or hsla notation, got " + this.this$0.getValue());
                }
                return object;
            }
            {
                this.this$0 = color;
                this.$match = matchResult;
                super(1);
            }
        };
        String hueShape = $fun$getHSLParameter$1.invoke(1);
        if (StringsKt.endsWith((String)hueShape, (String)"grad", (boolean)true)) {
            string = StringsKt.substringBefore$default((String)hueShape, (String)"grad", null, (int)2, null);
            bl = false;
            d2 = Double.parseDouble(string) * 0.9;
        } else if (StringsKt.endsWith((String)hueShape, (String)"rad", (boolean)true)) {
            string = StringsKt.substringBefore$default((String)hueShape, (String)"rad", null, (int)2, null);
            bl = false;
            d2 = Double.parseDouble(string) * (double)180 / Math.PI;
        } else if (StringsKt.endsWith((String)hueShape, (String)"turn", (boolean)true)) {
            string = StringsKt.substringBefore$default((String)hueShape, (String)"turn", null, (int)2, null);
            bl = false;
            d2 = Double.parseDouble(string) * 360.0;
        } else if (StringsKt.endsWith((String)hueShape, (String)"deg", (boolean)true)) {
            string = StringsKt.substringBefore$default((String)hueShape, (String)"deg", null, (int)2, null);
            bl = false;
            d2 = Double.parseDouble(string);
        } else {
            string = hueShape;
            bl = false;
            d2 = Double.parseDouble(string);
        }
        int hue = Companion.normalizeHue(d2);
        String string2 = $fun$getHSLParameter$1.invoke(2);
        boolean bl2 = false;
        int saturation = Companion.normalizePercent(Integer.parseInt(string2));
        String string3 = $fun$getHSLParameter$1.invoke(3);
        boolean bl3 = false;
        int lightness = Companion.normalizePercent(Integer.parseInt(string3));
        Object object = match;
        if (object != null && (object = object.getGroups()) != null && (object = object.get(4)) != null && (object = object.getValue()) != null) {
            Object object2 = object;
            boolean bl4 = false;
            d = Double.parseDouble((String)object2);
        } else {
            d = 1.0;
        }
        double alpha = Companion.normalizeAlpha(d);
        return new HSLA(hue, saturation, lightness, alpha);
    }

    @NotNull
    public final RGBA fromRGBANotation$kotlin_css() {
        double d;
        MatchResult match = Regex.find$default((Regex)Color.Companion.getRGBA_REGEX(), (CharSequence)this.getValue(), (int)0, (int)2, null);
        Function1<Integer, Integer> $fun$getRGBParameter$1 = new Function1<Integer, Integer>(this, match){
            final /* synthetic */ Color this$0;
            final /* synthetic */ MatchResult $match;

            public final int invoke(int index) {
                int n;
                Object object = this.$match;
                if (object == null || (object = object.getGroups()) == null || (object = object.get(index)) == null || (object = object.getValue()) == null) {
                    throw (Throwable)new IllegalArgumentException("Expected rgb or rgba notation, got " + this.this$0.getValue());
                }
                Object group = object;
                if (StringsKt.endsWith$default((CharSequence)((CharSequence)group), (char)'%', (boolean)false, (int)2, null)) {
                    String string = StringsKt.substringBefore$default((String)group, (char)'%', null, (int)2, null);
                    boolean bl = false;
                    n = (int)(Color.Companion.normalizeFractionalPercent(Double.parseDouble(string) / 100.0) * 255.0);
                } else {
                    Object object2 = group;
                    boolean bl = false;
                    n = Color.Companion.normalizeRGB(Integer.parseInt((String)object2));
                }
                return n;
            }
            {
                this.this$0 = color;
                this.$match = matchResult;
                super(1);
            }
        };
        int red = $fun$getRGBParameter$1.invoke(1);
        int green = $fun$getRGBParameter$1.invoke(2);
        int blue = $fun$getRGBParameter$1.invoke(3);
        Object object = match;
        if (object != null && (object = object.getGroups()) != null && (object = object.get(4)) != null && (object = object.getValue()) != null) {
            Object object2 = object;
            boolean bl = false;
            d = Double.parseDouble((String)object2);
        } else {
            d = 1.0;
        }
        double alpha = Companion.normalizeAlpha(d);
        return new RGBA(red, green, blue, alpha);
    }

    @NotNull
    public final RGBA toRGBA$kotlin_css() {
        RGBA rGBA;
        String string = this.rgb;
        if (string == null) {
            string = this.getValue();
        }
        String v = string;
        if (StringsKt.startsWith$default((String)v, (String)"rgb", (boolean)false, (int)2, null)) {
            rGBA = this.fromRGBANotation$kotlin_css();
        } else if (StringsKt.startsWith$default((String)v, (String)"#", (boolean)false, (int)2, null) && v.length() == 4) {
            String string2 = ExtensionsKt.times(String.valueOf(v.charAt(1)), 2);
            int n = 16;
            boolean bl = false;
            int n2 = Integer.parseInt(string2, CharsKt.checkRadix((int)n));
            string2 = ExtensionsKt.times(String.valueOf(v.charAt(2)), 2);
            n = 16;
            bl = false;
            int n3 = Integer.parseInt(string2, CharsKt.checkRadix((int)n));
            string2 = ExtensionsKt.times(String.valueOf(v.charAt(3)), 2);
            n = 16;
            bl = false;
            RGBA rGBA2 = new RGBA(n2, n3, Integer.parseInt(string2, CharsKt.checkRadix((int)n)), 0.0, 8, null);
            rGBA = rGBA2;
        } else if (StringsKt.startsWith$default((String)v, (String)"#", (boolean)false, (int)2, null) && (v.length() == 7 || v.length() == 9)) {
            int n = 1;
            String string3 = StringsKt.substring((String)v, (IntRange)new IntRange(n, 2));
            int n4 = 16;
            boolean bl = false;
            int n5 = Integer.parseInt(string3, CharsKt.checkRadix((int)n4));
            int n6 = 3;
            String string4 = StringsKt.substring((String)v, (IntRange)new IntRange(n6, 4));
            n4 = 16;
            bl = false;
            int n7 = Integer.parseInt(string4, CharsKt.checkRadix((int)n4));
            int n8 = 5;
            String string5 = StringsKt.substring((String)v, (IntRange)new IntRange(n8, 6));
            n4 = 16;
            bl = false;
            RGBA rGBA3 = new RGBA(n5, n7, Integer.parseInt(string5, CharsKt.checkRadix((int)n4)), 0.0, 8, null);
            rGBA = rGBA3;
        } else {
            throw (Throwable)new IllegalArgumentException("Only hexadecimal, rgb, and rgba notations are accepted, got " + v);
        }
        return rGBA;
    }

    @Override
    @NotNull
    public String getValue() {
        return this.value;
    }

    public Color(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(value);
        this.value = value;
    }

    private Color(String value, String rgb) {
        this(value);
        this.rgb = rgb;
    }

    static {
        Companion = new Companion(null);
        initial = new Color("initial");
        inherit = new Color("inherit");
        unset = new Color("unset");
        transparent = new Color("transparent");
        currentColor = new Color("currentColor");
        aliceBlue = new Color("aliceblue", "#f0f8ff");
        antiqueWhite = new Color("antiquewhite", "#faebd7");
        aqua = new Color("aqua", "#00ffff");
        aquamarine = new Color("aquamarine", "#7fffd4");
        azure = new Color("azure", "#f0ffff");
        beige = new Color("beige", "#f5f5dc");
        bisque = new Color("bisque", "#ffe4c4");
        black = new Color("black", "#000000");
        blanchedAlmond = new Color("blanchedalmond", "#ffebcd");
        blue = new Color("blue", "#0000ff");
        blueViolet = new Color("blueviolet", "#8a2be2");
        brown = new Color("brown", "#a52a2a");
        burlyWood = new Color("burlywood", "#deb887");
        cadetBlue = new Color("cadetblue", "#5f9ea0");
        chartreuse = new Color("chartreuse", "#7fff00");
        chocolate = new Color("chocolate", "#d2691e");
        coral = new Color("coral", "#ff7f50");
        cornflowerBlue = new Color("cornflowerblue", "#6495ed");
        cornsilk = new Color("cornsilk", "#fff8dc");
        crimson = new Color("crimson", "#dc143c");
        cyan = new Color("cyan", "#00ffff");
        darkBlue = new Color("darkblue", "#00008b");
        darkCyan = new Color("darkcyan", "#008b8b");
        darkGoldenrod = new Color("darkgoldenrod", "#b8860b");
        darkGray = new Color("darkgray", "#a9a9a9");
        darkGreen = new Color("darkgreen", "#006400");
        darkGrey = new Color("darkgrey", "#a9a9a9");
        darkKhaki = new Color("darkkhaki", "#bdb76b");
        darkMagenta = new Color("darkmagenta", "#8b008b");
        darkOliveGreen = new Color("darkolivegreen", "#556b2f");
        darkOrange = new Color("darkorange", "#ff8c00");
        darkOrchid = new Color("darkorchid", "#9932cc");
        darkRed = new Color("darkred", "#8b0000");
        darkSalmon = new Color("darksalmon", "#e9967a");
        darkSeaGreen = new Color("darkseagreen", "#8fbc8f");
        darkSlateBlue = new Color("darkslateblue", "#483d8b");
        darkSlateGray = new Color("darkslategray", "#2f4f4f");
        darkSlateGrey = new Color("darkslategrey", "#2f4f4f");
        darkTurquoise = new Color("darkturquoise", "#00ced1");
        darkViolet = new Color("darkviolet", "#9400d3");
        deepPink = new Color("deeppink", "#ff1493");
        deepSkyBlue = new Color("deepskyblue", "#00bfff");
        dimGray = new Color("dimgray", "#696969");
        dimGrey = new Color("dimgrey", "#696969");
        dodgerBlue = new Color("dodgerblue", "#1e90ff");
        firebrick = new Color("firebrick", "#b22222");
        floralWhite = new Color("floralwhite", "#fffaf0");
        forestGreen = new Color("forestgreen", "#228b22");
        fuchsia = new Color("fuchsia", "#ff00ff");
        gainsboro = new Color("gainsboro", "#dcdcdc");
        ghostWhite = new Color("ghostwhite", "#f8f8ff");
        gold = new Color("gold", "#ffd700");
        goldenrod = new Color("goldenrod", "#daa520");
        gray = new Color("gray", "#808080");
        green = new Color("green", "#008000");
        greenYellow = new Color("greenyellow", "#adff2f");
        grey = new Color("grey", "#808080");
        honeydew = new Color("honeydew", "#f0fff0");
        hotPink = new Color("hotpink", "#ff69b4");
        indianRed = new Color("indianred", "#cd5c5c");
        indigo = new Color("indigo", "#4b0082");
        ivory = new Color("ivory", "#fffff0");
        khaki = new Color("khaki", "#f0e68c");
        lavender = new Color("lavender", "#e6e6fa");
        lavenderBlush = new Color("lavenderblush", "#fff0f5");
        lawnGreen = new Color("lawngreen", "#7cfc00");
        lemonChiffon = new Color("lemonchiffon", "#fffacd");
        lightBlue = new Color("lightblue", "#add8e6");
        lightCoral = new Color("lightcoral", "#f08080");
        lightCyan = new Color("lightcyan", "#e0ffff");
        lightGoldenrodYellow = new Color("lightgoldenrodyellow", "#fafad2");
        lightGray = new Color("lightgray", "#d3d3d3");
        lightGreen = new Color("lightgreen", "#90ee90");
        lightGrey = new Color("lightgrey", "#d3d3d3");
        lightPink = new Color("lightpink", "#ffb6c1");
        lightSalmon = new Color("lightsalmon", "#ffa07a");
        lightSeaGreen = new Color("lightseagreen", "#20b2aa");
        lightSkyBlue = new Color("lightskyblue", "#87cefa");
        lightSlateGray = new Color("lightslategray", "#778899");
        lightSlateGrey = new Color("lightslategrey", "#778899");
        lightSteelBlue = new Color("lightsteelblue", "#b0c4de");
        lightYellow = new Color("lightyellow", "#ffffe0");
        lime = new Color("lime", "#00ff00");
        limeGreen = new Color("limegreen", "#32cd32");
        linen = new Color("linen", "#faf0e6");
        magenta = new Color("magenta", "#ff00ff");
        maroon = new Color("maroon", "#800000");
        mediumAquamarine = new Color("mediumaquamarine", "#66cdaa");
        mediumBlue = new Color("mediumblue", "#0000cd");
        mediumOrchid = new Color("mediumorchid", "#ba55d3");
        mediumPurple = new Color("mediumpurple", "#9370d8");
        mediumSeaGreen = new Color("mediumseagreen", "#3cb371");
        mediumSlateBlue = new Color("mediumslateblue", "#7b68ee");
        mediumSpringGreen = new Color("mediumspringgreen", "#00fa9a");
        mediumTurquoise = new Color("mediumturquoise", "#48d1cc");
        mediumVioletRed = new Color("mediumvioletred", "#c71585");
        midnightBlue = new Color("midnightblue", "#191970");
        mintCream = new Color("mintcream", "#f5fffa");
        mistyRose = new Color("mistyrose", "#ffe4e1");
        moccasin = new Color("moccasin", "#ffe4b5");
        navajoWhite = new Color("navajowhite", "#ffdead");
        navy = new Color("navy", "#000080");
        oldLace = new Color("oldlace", "#fdf5e6");
        olive = new Color("olive", "#808000");
        oliveDrab = new Color("olivedrab", "#6b8e23");
        orange = new Color("orange", "#ffa500");
        orangeRed = new Color("orangered", "#ff4500");
        orchid = new Color("orchid", "#da70d6");
        paleGoldenrod = new Color("palegoldenrod", "#eee8aa");
        paleGreen = new Color("palegreen", "#98fb98");
        paleTurquoise = new Color("paleturquoise", "#afeeee");
        paleVioletRed = new Color("palevioletred", "#db7093");
        papayaWhip = new Color("papayawhip", "#ffefd5");
        peachPuff = new Color("peachpuff", "#ffdab9");
        peru = new Color("peru", "#cd853f");
        pink = new Color("pink", "#ffc0cb");
        plum = new Color("plum", "#dda0dd");
        powderBlue = new Color("powderblue", "#b0e0e6");
        purple = new Color("purple", "#800080");
        red = new Color("red", "#ff0000");
        rosyBrown = new Color("rosybrown", "#bc8f8f");
        royalBlue = new Color("royalblue", "#4169e1");
        saddleBrown = new Color("saddlebrown", "#8b4513");
        salmon = new Color("salmon", "#fa8072");
        sandyBrown = new Color("sandybrown", "#f4a460");
        seaGreen = new Color("seagreen", "#2e8b57");
        seaShell = new Color("seashell", "#fff5ee");
        sienna = new Color("sienna", "#a0522d");
        silver = new Color("silver", "#c0c0c0");
        skyBlue = new Color("skyblue", "#87ceeb");
        slateBlue = new Color("slateblue", "#6a5acd");
        slateGray = new Color("slategray", "#708090");
        slateGrey = new Color("slategrey", "#708090");
        snow = new Color("snow", "#fffafa");
        springGreen = new Color("springgreen", "#00ff7f");
        steelBlue = new Color("steelblue", "#4682b4");
        tan = new Color("tan", "#d2b48c");
        teal = new Color("teal", "#008080");
        thistle = new Color("thistle", "#d8bfd8");
        tomato = new Color("tomato", "#ff6347");
        turquoise = new Color("turquoise", "#40e0d0");
        violet = new Color("violet", "#ee82ee");
        wheat = new Color("wheat", "#f5deb3");
        white = new Color("white", "#ffffff");
        whiteSmoke = new Color("whitesmoke", "#f5f5f5");
        yellow = new Color("yellow", "#ffff00");
        yellowGreen = new Color("yellowgreen", "#9acd32");
        HSLA_REGEX$delegate = LazyKt.lazy((Function0)Companion.HSLA_REGEX.2.INSTANCE);
        RGBA_REGEX$delegate = LazyKt.lazy((Function0)Companion.RGBA_REGEX.2.INSTANCE);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001c"}, d2={"Lkotlinx/css/Color$RGBA;", "", "red", "", "green", "blue", "alpha", "", "(IIID)V", "getAlpha", "()D", "getBlue", "()I", "getGreen", "getRed", "asHSLA", "Lkotlinx/css/Color$HSLA;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "kotlin-css"})
    public static final class RGBA {
        private final int red;
        private final int green;
        private final int blue;
        private final double alpha;

        @NotNull
        public final HSLA asHSLA() {
            double d;
            double d2;
            double r = (double)this.red / 255.0;
            double g = (double)this.green / 255.0;
            double b = (double)this.blue / 255.0;
            boolean bl = false;
            boolean bl2 = false;
            double d3 = Math.max(g, b);
            boolean bl3 = false;
            double cMax = Math.max(r, d3);
            boolean bl4 = false;
            boolean bl5 = false;
            double d4 = Math.min(g, b);
            boolean bl6 = false;
            double cMin = Math.min(r, d4);
            double chroma = cMax - cMin;
            double lg = Companion.normalizeFractionalPercent((cMax + cMin) / (double)2);
            if (chroma != 0.0) {
                double d5 = 2.0 * lg - 1.0;
                boolean bl7 = false;
                d2 = Companion.normalizeFractionalPercent(chroma / (1.0 - Math.abs(d5)));
            } else {
                d2 = 0.0;
            }
            double s = d2;
            double d6 = cMax;
            if (d6 == cMin) {
                d = 0.0;
            } else if (d6 == r) {
                d = (double)60 * ((g - b) / chroma % 6.0);
            } else if (d6 == g) {
                d = (double)60 * ((b - r) / chroma + (double)2);
            } else if (d6 == b) {
                d = (double)60 * ((r - g) / chroma + (double)4);
            } else {
                String string = "Unexpected value for max";
                boolean bl8 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            double h = d;
            return new HSLA(Companion.normalizeHue(h), MathKt.roundToInt((double)(s * (double)100)), MathKt.roundToInt((double)(lg * (double)100)), this.alpha);
        }

        public final int getRed() {
            return this.red;
        }

        public final int getGreen() {
            return this.green;
        }

        public final int getBlue() {
            return this.blue;
        }

        public final double getAlpha() {
            return this.alpha;
        }

        public RGBA(int red, int green, int blue, double alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public /* synthetic */ RGBA(int n, int n2, int n3, double d, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 8) != 0) {
                d = 1.0;
            }
            this(n, n2, n3, d);
        }

        public final int component1() {
            return this.red;
        }

        public final int component2() {
            return this.green;
        }

        public final int component3() {
            return this.blue;
        }

        public final double component4() {
            return this.alpha;
        }

        @NotNull
        public final RGBA copy(int red, int green, int blue, double alpha) {
            return new RGBA(red, green, blue, alpha);
        }

        public static /* synthetic */ RGBA copy$default(RGBA rGBA, int n, int n2, int n3, double d, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = rGBA.red;
            }
            if ((n4 & 2) != 0) {
                n2 = rGBA.green;
            }
            if ((n4 & 4) != 0) {
                n3 = rGBA.blue;
            }
            if ((n4 & 8) != 0) {
                d = rGBA.alpha;
            }
            return rGBA.copy(n, n2, n3, d);
        }

        @NotNull
        public String toString() {
            return "RGBA(red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + ")";
        }

        public int hashCode() {
            long l = Double.doubleToLongBits(this.alpha);
            return ((this.red * 31 + this.green) * 31 + this.blue) * 31 + (int)(l ^ l >>> 32);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RGBA)) break block3;
                    RGBA rGBA = (RGBA)object;
                    if (this.red != rGBA.red || this.green != rGBA.green || this.blue != rGBA.blue || Double.compare(this.alpha, rGBA.alpha) != 0) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001c"}, d2={"Lkotlinx/css/Color$HSLA;", "", "hue", "", "saturation", "lightness", "alpha", "", "(IIID)V", "getAlpha", "()D", "getHue", "()I", "getLightness", "getSaturation", "asRGBA", "Lkotlinx/css/Color$RGBA;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "kotlin-css"})
    public static final class HSLA {
        private final int hue;
        private final int saturation;
        private final int lightness;
        private final double alpha;

        @NotNull
        public final RGBA asRGBA() {
            asRGBA.1 $fun$hueToRGB$1 = asRGBA.1.INSTANCE;
            if (this.saturation == 0) {
                return new RGBA(this.lightness, this.lightness, this.lightness, 0.0, 8, null);
            }
            double h = (double)this.hue % 360.0 / 360.0;
            double s = (double)this.saturation / 100.0;
            double lg = (double)this.lightness / 100.0;
            double m2 = lg < 0.5 ? lg * (1.0 + s) : lg + s - lg * s;
            double m1 = (double)2 * lg - m2;
            double r = Companion.normalizeFractionalPercent($fun$hueToRGB$1.invoke(m1, m2, h + 0.3333333333333333));
            double g = Companion.normalizeFractionalPercent($fun$hueToRGB$1.invoke(m1, m2, h));
            double b = Companion.normalizeFractionalPercent($fun$hueToRGB$1.invoke(m1, m2, h - 0.3333333333333333));
            return new RGBA(MathKt.roundToInt((double)(r * (double)255)), MathKt.roundToInt((double)(g * (double)255)), MathKt.roundToInt((double)(b * (double)255)), this.alpha);
        }

        public final int getHue() {
            return this.hue;
        }

        public final int getSaturation() {
            return this.saturation;
        }

        public final int getLightness() {
            return this.lightness;
        }

        public final double getAlpha() {
            return this.alpha;
        }

        public HSLA(int hue, int saturation, int lightness, double alpha) {
            this.hue = hue;
            this.saturation = saturation;
            this.lightness = lightness;
            this.alpha = alpha;
        }

        public /* synthetic */ HSLA(int n, int n2, int n3, double d, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 8) != 0) {
                d = 1.0;
            }
            this(n, n2, n3, d);
        }

        public final int component1() {
            return this.hue;
        }

        public final int component2() {
            return this.saturation;
        }

        public final int component3() {
            return this.lightness;
        }

        public final double component4() {
            return this.alpha;
        }

        @NotNull
        public final HSLA copy(int hue, int saturation, int lightness, double alpha) {
            return new HSLA(hue, saturation, lightness, alpha);
        }

        public static /* synthetic */ HSLA copy$default(HSLA hSLA, int n, int n2, int n3, double d, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = hSLA.hue;
            }
            if ((n4 & 2) != 0) {
                n2 = hSLA.saturation;
            }
            if ((n4 & 4) != 0) {
                n3 = hSLA.lightness;
            }
            if ((n4 & 8) != 0) {
                d = hSLA.alpha;
            }
            return hSLA.copy(n, n2, n3, d);
        }

        @NotNull
        public String toString() {
            return "HSLA(hue=" + this.hue + ", saturation=" + this.saturation + ", lightness=" + this.lightness + ", alpha=" + this.alpha + ")";
        }

        public int hashCode() {
            long l = Double.doubleToLongBits(this.alpha);
            return ((this.hue * 31 + this.saturation) * 31 + this.lightness) * 31 + (int)(l ^ l >>> 32);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof HSLA)) break block3;
                    HSLA hSLA = (HSLA)object;
                    if (this.hue != hSLA.hue || this.saturation != hSLA.saturation || this.lightness != hSLA.lightness || Double.compare(this.alpha, hSLA.alpha) != 0) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000-\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0003\b\u00b1\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u00be\u0002\u001a\u00030\u00bf\u00022\b\u0010\u00c0\u0002\u001a\u00030\u00bf\u0002J\u0012\u0010\u00c1\u0002\u001a\u00030\u00bf\u00022\b\u0010\u00c0\u0002\u001a\u00030\u00bf\u0002J\u0012\u0010\u00c2\u0002\u001a\u00030\u00c3\u00022\b\u0010\u00c0\u0002\u001a\u00030\u00bf\u0002J\u0012\u0010\u00c4\u0002\u001a\u00030\u00c3\u00022\b\u0010\u00c0\u0002\u001a\u00030\u00c3\u0002J\u0012\u0010\u00c5\u0002\u001a\u00030\u00c3\u00022\b\u0010\u00c0\u0002\u001a\u00030\u00c3\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\u001a\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000fR\u0011\u0010\u001c\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000fR\u0011\u0010\u001e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000fR\u0011\u0010 \u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000fR\u0011\u0010\"\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000fR\u0011\u0010$\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000fR\u0011\u0010&\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u000fR\u0011\u0010(\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u000fR\u0011\u0010*\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u000fR\u0011\u0010,\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u000fR\u0011\u0010.\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u000fR\u0011\u00100\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u000fR\u0011\u00102\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u000fR\u0011\u00104\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u000fR\u0011\u00106\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u000fR\u0011\u00108\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u000fR\u0011\u0010:\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u000fR\u0011\u0010<\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u000fR\u0011\u0010>\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\u000fR\u0011\u0010@\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u000fR\u0011\u0010B\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u000fR\u0011\u0010D\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010\u000fR\u0011\u0010F\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010\u000fR\u0011\u0010H\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\u000fR\u0011\u0010J\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\u000fR\u0011\u0010L\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010\u000fR\u0011\u0010N\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\u000fR\u0011\u0010P\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010\u000fR\u0011\u0010R\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010\u000fR\u0011\u0010T\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\u000fR\u0011\u0010V\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010\u000fR\u0011\u0010X\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010\u000fR\u0011\u0010Z\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\u000fR\u0011\u0010\\\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010\u000fR\u0011\u0010^\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010\u000fR\u0011\u0010`\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010\u000fR\u0011\u0010b\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010\u000fR\u0011\u0010d\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010\u000fR\u0011\u0010f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010\u000fR\u0011\u0010h\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010\u000fR\u0011\u0010j\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010\u000fR\u0011\u0010l\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bm\u0010\u000fR\u0011\u0010n\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bo\u0010\u000fR\u0011\u0010p\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bq\u0010\u000fR\u0011\u0010r\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bs\u0010\u000fR\u0011\u0010t\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bu\u0010\u000fR\u0011\u0010v\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bw\u0010\u000fR\u0011\u0010x\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\by\u0010\u000fR\u0011\u0010z\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b{\u0010\u000fR\u0011\u0010|\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b}\u0010\u000fR\u0011\u0010~\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u007f\u0010\u000fR\u0013\u0010\u0080\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0081\u0001\u0010\u000fR\u0013\u0010\u0082\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0083\u0001\u0010\u000fR\u0013\u0010\u0084\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0085\u0001\u0010\u000fR\u0013\u0010\u0086\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0087\u0001\u0010\u000fR\u0013\u0010\u0088\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0089\u0001\u0010\u000fR\u0013\u0010\u008a\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008b\u0001\u0010\u000fR\u0013\u0010\u008c\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008d\u0001\u0010\u000fR\u0013\u0010\u008e\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008f\u0001\u0010\u000fR\u0013\u0010\u0090\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0091\u0001\u0010\u000fR\u0013\u0010\u0092\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0093\u0001\u0010\u000fR\u0013\u0010\u0094\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0095\u0001\u0010\u000fR\u0013\u0010\u0096\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0097\u0001\u0010\u000fR\u0013\u0010\u0098\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0099\u0001\u0010\u000fR\u0013\u0010\u009a\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009b\u0001\u0010\u000fR\u0013\u0010\u009c\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009d\u0001\u0010\u000fR\u0013\u0010\u009e\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009f\u0001\u0010\u000fR\u0013\u0010\u00a0\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a1\u0001\u0010\u000fR\u0013\u0010\u00a2\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a3\u0001\u0010\u000fR\u0013\u0010\u00a4\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a5\u0001\u0010\u000fR\u0013\u0010\u00a6\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a7\u0001\u0010\u000fR\u0013\u0010\u00a8\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a9\u0001\u0010\u000fR\u0013\u0010\u00aa\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00ab\u0001\u0010\u000fR\u0013\u0010\u00ac\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00ad\u0001\u0010\u000fR\u0013\u0010\u00ae\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00af\u0001\u0010\u000fR\u0013\u0010\u00b0\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b1\u0001\u0010\u000fR\u0013\u0010\u00b2\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b3\u0001\u0010\u000fR\u0013\u0010\u00b4\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b5\u0001\u0010\u000fR\u0013\u0010\u00b6\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b7\u0001\u0010\u000fR\u0013\u0010\u00b8\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b9\u0001\u0010\u000fR\u0013\u0010\u00ba\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00bb\u0001\u0010\u000fR\u0013\u0010\u00bc\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00bd\u0001\u0010\u000fR\u0013\u0010\u00be\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00bf\u0001\u0010\u000fR\u0013\u0010\u00c0\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00c1\u0001\u0010\u000fR\u0013\u0010\u00c2\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00c3\u0001\u0010\u000fR\u0013\u0010\u00c4\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00c5\u0001\u0010\u000fR\u0013\u0010\u00c6\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00c7\u0001\u0010\u000fR\u0013\u0010\u00c8\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00c9\u0001\u0010\u000fR\u0013\u0010\u00ca\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00cb\u0001\u0010\u000fR\u0013\u0010\u00cc\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00cd\u0001\u0010\u000fR\u0013\u0010\u00ce\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00cf\u0001\u0010\u000fR\u0013\u0010\u00d0\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00d1\u0001\u0010\u000fR\u0013\u0010\u00d2\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00d3\u0001\u0010\u000fR\u0013\u0010\u00d4\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00d5\u0001\u0010\u000fR\u0013\u0010\u00d6\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00d7\u0001\u0010\u000fR\u0013\u0010\u00d8\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00d9\u0001\u0010\u000fR\u0013\u0010\u00da\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00db\u0001\u0010\u000fR\u0013\u0010\u00dc\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00dd\u0001\u0010\u000fR\u0013\u0010\u00de\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00df\u0001\u0010\u000fR\u0013\u0010\u00e0\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00e1\u0001\u0010\u000fR\u0013\u0010\u00e2\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00e3\u0001\u0010\u000fR\u0013\u0010\u00e4\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00e5\u0001\u0010\u000fR\u0013\u0010\u00e6\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00e7\u0001\u0010\u000fR\u0013\u0010\u00e8\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00e9\u0001\u0010\u000fR\u0013\u0010\u00ea\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00eb\u0001\u0010\u000fR\u0013\u0010\u00ec\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00ed\u0001\u0010\u000fR\u0013\u0010\u00ee\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00ef\u0001\u0010\u000fR\u0013\u0010\u00f0\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00f1\u0001\u0010\u000fR\u0013\u0010\u00f2\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00f3\u0001\u0010\u000fR\u0013\u0010\u00f4\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00f5\u0001\u0010\u000fR\u0013\u0010\u00f6\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00f7\u0001\u0010\u000fR\u0013\u0010\u00f8\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00f9\u0001\u0010\u000fR\u0013\u0010\u00fa\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00fb\u0001\u0010\u000fR\u0013\u0010\u00fc\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00fd\u0001\u0010\u000fR\u0013\u0010\u00fe\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00ff\u0001\u0010\u000fR\u0013\u0010\u0080\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0081\u0002\u0010\u000fR\u0013\u0010\u0082\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0083\u0002\u0010\u000fR\u0013\u0010\u0084\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0085\u0002\u0010\u000fR\u0013\u0010\u0086\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0087\u0002\u0010\u000fR\u0013\u0010\u0088\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0089\u0002\u0010\u000fR\u0013\u0010\u008a\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008b\u0002\u0010\u000fR\u0013\u0010\u008c\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008d\u0002\u0010\u000fR\u0013\u0010\u008e\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008f\u0002\u0010\u000fR\u0013\u0010\u0090\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0091\u0002\u0010\u000fR\u0013\u0010\u0092\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0093\u0002\u0010\u000fR\u0013\u0010\u0094\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0095\u0002\u0010\u000fR\u0013\u0010\u0096\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0097\u0002\u0010\u000fR\u0013\u0010\u0098\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0099\u0002\u0010\u000fR\u0013\u0010\u009a\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009b\u0002\u0010\u000fR\u0013\u0010\u009c\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009d\u0002\u0010\u000fR\u0013\u0010\u009e\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009f\u0002\u0010\u000fR\u0013\u0010\u00a0\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a1\u0002\u0010\u000fR\u0013\u0010\u00a2\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a3\u0002\u0010\u000fR\u0013\u0010\u00a4\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a5\u0002\u0010\u000fR\u0013\u0010\u00a6\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a7\u0002\u0010\u000fR\u0013\u0010\u00a8\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a9\u0002\u0010\u000fR\u0013\u0010\u00aa\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00ab\u0002\u0010\u000fR\u0013\u0010\u00ac\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00ad\u0002\u0010\u000fR\u0013\u0010\u00ae\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00af\u0002\u0010\u000fR\u0013\u0010\u00b0\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b1\u0002\u0010\u000fR\u0013\u0010\u00b2\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b3\u0002\u0010\u000fR\u0013\u0010\u00b4\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b5\u0002\u0010\u000fR\u0013\u0010\u00b6\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b7\u0002\u0010\u000fR\u0013\u0010\u00b8\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b9\u0002\u0010\u000fR\u0013\u0010\u00ba\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00bb\u0002\u0010\u000fR\u0013\u0010\u00bc\u0002\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00bd\u0002\u0010\u000f\u00a8\u0006\u00c6\u0002"}, d2={"Lkotlinx/css/Color$Companion;", "", "()V", "HSLA_REGEX", "Lkotlin/text/Regex;", "getHSLA_REGEX", "()Lkotlin/text/Regex;", "HSLA_REGEX$delegate", "Lkotlin/Lazy;", "RGBA_REGEX", "getRGBA_REGEX", "RGBA_REGEX$delegate", "aliceBlue", "Lkotlinx/css/Color;", "getAliceBlue", "()Lkotlinx/css/Color;", "antiqueWhite", "getAntiqueWhite", "aqua", "getAqua", "aquamarine", "getAquamarine", "azure", "getAzure", "beige", "getBeige", "bisque", "getBisque", "black", "getBlack", "blanchedAlmond", "getBlanchedAlmond", "blue", "getBlue", "blueViolet", "getBlueViolet", "brown", "getBrown", "burlyWood", "getBurlyWood", "cadetBlue", "getCadetBlue", "chartreuse", "getChartreuse", "chocolate", "getChocolate", "coral", "getCoral", "cornflowerBlue", "getCornflowerBlue", "cornsilk", "getCornsilk", "crimson", "getCrimson", "currentColor", "getCurrentColor", "cyan", "getCyan", "darkBlue", "getDarkBlue", "darkCyan", "getDarkCyan", "darkGoldenrod", "getDarkGoldenrod", "darkGray", "getDarkGray", "darkGreen", "getDarkGreen", "darkGrey", "getDarkGrey", "darkKhaki", "getDarkKhaki", "darkMagenta", "getDarkMagenta", "darkOliveGreen", "getDarkOliveGreen", "darkOrange", "getDarkOrange", "darkOrchid", "getDarkOrchid", "darkRed", "getDarkRed", "darkSalmon", "getDarkSalmon", "darkSeaGreen", "getDarkSeaGreen", "darkSlateBlue", "getDarkSlateBlue", "darkSlateGray", "getDarkSlateGray", "darkSlateGrey", "getDarkSlateGrey", "darkTurquoise", "getDarkTurquoise", "darkViolet", "getDarkViolet", "deepPink", "getDeepPink", "deepSkyBlue", "getDeepSkyBlue", "dimGray", "getDimGray", "dimGrey", "getDimGrey", "dodgerBlue", "getDodgerBlue", "firebrick", "getFirebrick", "floralWhite", "getFloralWhite", "forestGreen", "getForestGreen", "fuchsia", "getFuchsia", "gainsboro", "getGainsboro", "ghostWhite", "getGhostWhite", "gold", "getGold", "goldenrod", "getGoldenrod", "gray", "getGray", "green", "getGreen", "greenYellow", "getGreenYellow", "grey", "getGrey", "honeydew", "getHoneydew", "hotPink", "getHotPink", "indianRed", "getIndianRed", "indigo", "getIndigo", "inherit", "getInherit", "initial", "getInitial", "ivory", "getIvory", "khaki", "getKhaki", "lavender", "getLavender", "lavenderBlush", "getLavenderBlush", "lawnGreen", "getLawnGreen", "lemonChiffon", "getLemonChiffon", "lightBlue", "getLightBlue", "lightCoral", "getLightCoral", "lightCyan", "getLightCyan", "lightGoldenrodYellow", "getLightGoldenrodYellow", "lightGray", "getLightGray", "lightGreen", "getLightGreen", "lightGrey", "getLightGrey", "lightPink", "getLightPink", "lightSalmon", "getLightSalmon", "lightSeaGreen", "getLightSeaGreen", "lightSkyBlue", "getLightSkyBlue", "lightSlateGray", "getLightSlateGray", "lightSlateGrey", "getLightSlateGrey", "lightSteelBlue", "getLightSteelBlue", "lightYellow", "getLightYellow", "lime", "getLime", "limeGreen", "getLimeGreen", "linen", "getLinen", "magenta", "getMagenta", "maroon", "getMaroon", "mediumAquamarine", "getMediumAquamarine", "mediumBlue", "getMediumBlue", "mediumOrchid", "getMediumOrchid", "mediumPurple", "getMediumPurple", "mediumSeaGreen", "getMediumSeaGreen", "mediumSlateBlue", "getMediumSlateBlue", "mediumSpringGreen", "getMediumSpringGreen", "mediumTurquoise", "getMediumTurquoise", "mediumVioletRed", "getMediumVioletRed", "midnightBlue", "getMidnightBlue", "mintCream", "getMintCream", "mistyRose", "getMistyRose", "moccasin", "getMoccasin", "navajoWhite", "getNavajoWhite", "navy", "getNavy", "oldLace", "getOldLace", "olive", "getOlive", "oliveDrab", "getOliveDrab", "orange", "getOrange", "orangeRed", "getOrangeRed", "orchid", "getOrchid", "paleGoldenrod", "getPaleGoldenrod", "paleGreen", "getPaleGreen", "paleTurquoise", "getPaleTurquoise", "paleVioletRed", "getPaleVioletRed", "papayaWhip", "getPapayaWhip", "peachPuff", "getPeachPuff", "peru", "getPeru", "pink", "getPink", "plum", "getPlum", "powderBlue", "getPowderBlue", "purple", "getPurple", "red", "getRed", "rosyBrown", "getRosyBrown", "royalBlue", "getRoyalBlue", "saddleBrown", "getSaddleBrown", "salmon", "getSalmon", "sandyBrown", "getSandyBrown", "seaGreen", "getSeaGreen", "seaShell", "getSeaShell", "sienna", "getSienna", "silver", "getSilver", "skyBlue", "getSkyBlue", "slateBlue", "getSlateBlue", "slateGray", "getSlateGray", "slateGrey", "getSlateGrey", "snow", "getSnow", "springGreen", "getSpringGreen", "steelBlue", "getSteelBlue", "tan", "getTan", "teal", "getTeal", "thistle", "getThistle", "tomato", "getTomato", "transparent", "getTransparent", "turquoise", "getTurquoise", "unset", "getUnset", "violet", "getViolet", "wheat", "getWheat", "white", "getWhite", "whiteSmoke", "getWhiteSmoke", "yellow", "getYellow", "yellowGreen", "getYellowGreen", "normalizeAlpha", "", "value", "normalizeFractionalPercent", "normalizeHue", "", "normalizePercent", "normalizeRGB", "kotlin-css"})
    public static final class Companion {
        @NotNull
        public final Color getInitial() {
            return initial;
        }

        @NotNull
        public final Color getInherit() {
            return inherit;
        }

        @NotNull
        public final Color getUnset() {
            return unset;
        }

        @NotNull
        public final Color getTransparent() {
            return transparent;
        }

        @NotNull
        public final Color getCurrentColor() {
            return currentColor;
        }

        @NotNull
        public final Color getAliceBlue() {
            return aliceBlue;
        }

        @NotNull
        public final Color getAntiqueWhite() {
            return antiqueWhite;
        }

        @NotNull
        public final Color getAqua() {
            return aqua;
        }

        @NotNull
        public final Color getAquamarine() {
            return aquamarine;
        }

        @NotNull
        public final Color getAzure() {
            return azure;
        }

        @NotNull
        public final Color getBeige() {
            return beige;
        }

        @NotNull
        public final Color getBisque() {
            return bisque;
        }

        @NotNull
        public final Color getBlack() {
            return black;
        }

        @NotNull
        public final Color getBlanchedAlmond() {
            return blanchedAlmond;
        }

        @NotNull
        public final Color getBlue() {
            return blue;
        }

        @NotNull
        public final Color getBlueViolet() {
            return blueViolet;
        }

        @NotNull
        public final Color getBrown() {
            return brown;
        }

        @NotNull
        public final Color getBurlyWood() {
            return burlyWood;
        }

        @NotNull
        public final Color getCadetBlue() {
            return cadetBlue;
        }

        @NotNull
        public final Color getChartreuse() {
            return chartreuse;
        }

        @NotNull
        public final Color getChocolate() {
            return chocolate;
        }

        @NotNull
        public final Color getCoral() {
            return coral;
        }

        @NotNull
        public final Color getCornflowerBlue() {
            return cornflowerBlue;
        }

        @NotNull
        public final Color getCornsilk() {
            return cornsilk;
        }

        @NotNull
        public final Color getCrimson() {
            return crimson;
        }

        @NotNull
        public final Color getCyan() {
            return cyan;
        }

        @NotNull
        public final Color getDarkBlue() {
            return darkBlue;
        }

        @NotNull
        public final Color getDarkCyan() {
            return darkCyan;
        }

        @NotNull
        public final Color getDarkGoldenrod() {
            return darkGoldenrod;
        }

        @NotNull
        public final Color getDarkGray() {
            return darkGray;
        }

        @NotNull
        public final Color getDarkGreen() {
            return darkGreen;
        }

        @NotNull
        public final Color getDarkGrey() {
            return darkGrey;
        }

        @NotNull
        public final Color getDarkKhaki() {
            return darkKhaki;
        }

        @NotNull
        public final Color getDarkMagenta() {
            return darkMagenta;
        }

        @NotNull
        public final Color getDarkOliveGreen() {
            return darkOliveGreen;
        }

        @NotNull
        public final Color getDarkOrange() {
            return darkOrange;
        }

        @NotNull
        public final Color getDarkOrchid() {
            return darkOrchid;
        }

        @NotNull
        public final Color getDarkRed() {
            return darkRed;
        }

        @NotNull
        public final Color getDarkSalmon() {
            return darkSalmon;
        }

        @NotNull
        public final Color getDarkSeaGreen() {
            return darkSeaGreen;
        }

        @NotNull
        public final Color getDarkSlateBlue() {
            return darkSlateBlue;
        }

        @NotNull
        public final Color getDarkSlateGray() {
            return darkSlateGray;
        }

        @NotNull
        public final Color getDarkSlateGrey() {
            return darkSlateGrey;
        }

        @NotNull
        public final Color getDarkTurquoise() {
            return darkTurquoise;
        }

        @NotNull
        public final Color getDarkViolet() {
            return darkViolet;
        }

        @NotNull
        public final Color getDeepPink() {
            return deepPink;
        }

        @NotNull
        public final Color getDeepSkyBlue() {
            return deepSkyBlue;
        }

        @NotNull
        public final Color getDimGray() {
            return dimGray;
        }

        @NotNull
        public final Color getDimGrey() {
            return dimGrey;
        }

        @NotNull
        public final Color getDodgerBlue() {
            return dodgerBlue;
        }

        @NotNull
        public final Color getFirebrick() {
            return firebrick;
        }

        @NotNull
        public final Color getFloralWhite() {
            return floralWhite;
        }

        @NotNull
        public final Color getForestGreen() {
            return forestGreen;
        }

        @NotNull
        public final Color getFuchsia() {
            return fuchsia;
        }

        @NotNull
        public final Color getGainsboro() {
            return gainsboro;
        }

        @NotNull
        public final Color getGhostWhite() {
            return ghostWhite;
        }

        @NotNull
        public final Color getGold() {
            return gold;
        }

        @NotNull
        public final Color getGoldenrod() {
            return goldenrod;
        }

        @NotNull
        public final Color getGray() {
            return gray;
        }

        @NotNull
        public final Color getGreen() {
            return green;
        }

        @NotNull
        public final Color getGreenYellow() {
            return greenYellow;
        }

        @NotNull
        public final Color getGrey() {
            return grey;
        }

        @NotNull
        public final Color getHoneydew() {
            return honeydew;
        }

        @NotNull
        public final Color getHotPink() {
            return hotPink;
        }

        @NotNull
        public final Color getIndianRed() {
            return indianRed;
        }

        @NotNull
        public final Color getIndigo() {
            return indigo;
        }

        @NotNull
        public final Color getIvory() {
            return ivory;
        }

        @NotNull
        public final Color getKhaki() {
            return khaki;
        }

        @NotNull
        public final Color getLavender() {
            return lavender;
        }

        @NotNull
        public final Color getLavenderBlush() {
            return lavenderBlush;
        }

        @NotNull
        public final Color getLawnGreen() {
            return lawnGreen;
        }

        @NotNull
        public final Color getLemonChiffon() {
            return lemonChiffon;
        }

        @NotNull
        public final Color getLightBlue() {
            return lightBlue;
        }

        @NotNull
        public final Color getLightCoral() {
            return lightCoral;
        }

        @NotNull
        public final Color getLightCyan() {
            return lightCyan;
        }

        @NotNull
        public final Color getLightGoldenrodYellow() {
            return lightGoldenrodYellow;
        }

        @NotNull
        public final Color getLightGray() {
            return lightGray;
        }

        @NotNull
        public final Color getLightGreen() {
            return lightGreen;
        }

        @NotNull
        public final Color getLightGrey() {
            return lightGrey;
        }

        @NotNull
        public final Color getLightPink() {
            return lightPink;
        }

        @NotNull
        public final Color getLightSalmon() {
            return lightSalmon;
        }

        @NotNull
        public final Color getLightSeaGreen() {
            return lightSeaGreen;
        }

        @NotNull
        public final Color getLightSkyBlue() {
            return lightSkyBlue;
        }

        @NotNull
        public final Color getLightSlateGray() {
            return lightSlateGray;
        }

        @NotNull
        public final Color getLightSlateGrey() {
            return lightSlateGrey;
        }

        @NotNull
        public final Color getLightSteelBlue() {
            return lightSteelBlue;
        }

        @NotNull
        public final Color getLightYellow() {
            return lightYellow;
        }

        @NotNull
        public final Color getLime() {
            return lime;
        }

        @NotNull
        public final Color getLimeGreen() {
            return limeGreen;
        }

        @NotNull
        public final Color getLinen() {
            return linen;
        }

        @NotNull
        public final Color getMagenta() {
            return magenta;
        }

        @NotNull
        public final Color getMaroon() {
            return maroon;
        }

        @NotNull
        public final Color getMediumAquamarine() {
            return mediumAquamarine;
        }

        @NotNull
        public final Color getMediumBlue() {
            return mediumBlue;
        }

        @NotNull
        public final Color getMediumOrchid() {
            return mediumOrchid;
        }

        @NotNull
        public final Color getMediumPurple() {
            return mediumPurple;
        }

        @NotNull
        public final Color getMediumSeaGreen() {
            return mediumSeaGreen;
        }

        @NotNull
        public final Color getMediumSlateBlue() {
            return mediumSlateBlue;
        }

        @NotNull
        public final Color getMediumSpringGreen() {
            return mediumSpringGreen;
        }

        @NotNull
        public final Color getMediumTurquoise() {
            return mediumTurquoise;
        }

        @NotNull
        public final Color getMediumVioletRed() {
            return mediumVioletRed;
        }

        @NotNull
        public final Color getMidnightBlue() {
            return midnightBlue;
        }

        @NotNull
        public final Color getMintCream() {
            return mintCream;
        }

        @NotNull
        public final Color getMistyRose() {
            return mistyRose;
        }

        @NotNull
        public final Color getMoccasin() {
            return moccasin;
        }

        @NotNull
        public final Color getNavajoWhite() {
            return navajoWhite;
        }

        @NotNull
        public final Color getNavy() {
            return navy;
        }

        @NotNull
        public final Color getOldLace() {
            return oldLace;
        }

        @NotNull
        public final Color getOlive() {
            return olive;
        }

        @NotNull
        public final Color getOliveDrab() {
            return oliveDrab;
        }

        @NotNull
        public final Color getOrange() {
            return orange;
        }

        @NotNull
        public final Color getOrangeRed() {
            return orangeRed;
        }

        @NotNull
        public final Color getOrchid() {
            return orchid;
        }

        @NotNull
        public final Color getPaleGoldenrod() {
            return paleGoldenrod;
        }

        @NotNull
        public final Color getPaleGreen() {
            return paleGreen;
        }

        @NotNull
        public final Color getPaleTurquoise() {
            return paleTurquoise;
        }

        @NotNull
        public final Color getPaleVioletRed() {
            return paleVioletRed;
        }

        @NotNull
        public final Color getPapayaWhip() {
            return papayaWhip;
        }

        @NotNull
        public final Color getPeachPuff() {
            return peachPuff;
        }

        @NotNull
        public final Color getPeru() {
            return peru;
        }

        @NotNull
        public final Color getPink() {
            return pink;
        }

        @NotNull
        public final Color getPlum() {
            return plum;
        }

        @NotNull
        public final Color getPowderBlue() {
            return powderBlue;
        }

        @NotNull
        public final Color getPurple() {
            return purple;
        }

        @NotNull
        public final Color getRed() {
            return red;
        }

        @NotNull
        public final Color getRosyBrown() {
            return rosyBrown;
        }

        @NotNull
        public final Color getRoyalBlue() {
            return royalBlue;
        }

        @NotNull
        public final Color getSaddleBrown() {
            return saddleBrown;
        }

        @NotNull
        public final Color getSalmon() {
            return salmon;
        }

        @NotNull
        public final Color getSandyBrown() {
            return sandyBrown;
        }

        @NotNull
        public final Color getSeaGreen() {
            return seaGreen;
        }

        @NotNull
        public final Color getSeaShell() {
            return seaShell;
        }

        @NotNull
        public final Color getSienna() {
            return sienna;
        }

        @NotNull
        public final Color getSilver() {
            return silver;
        }

        @NotNull
        public final Color getSkyBlue() {
            return skyBlue;
        }

        @NotNull
        public final Color getSlateBlue() {
            return slateBlue;
        }

        @NotNull
        public final Color getSlateGray() {
            return slateGray;
        }

        @NotNull
        public final Color getSlateGrey() {
            return slateGrey;
        }

        @NotNull
        public final Color getSnow() {
            return snow;
        }

        @NotNull
        public final Color getSpringGreen() {
            return springGreen;
        }

        @NotNull
        public final Color getSteelBlue() {
            return steelBlue;
        }

        @NotNull
        public final Color getTan() {
            return tan;
        }

        @NotNull
        public final Color getTeal() {
            return teal;
        }

        @NotNull
        public final Color getThistle() {
            return thistle;
        }

        @NotNull
        public final Color getTomato() {
            return tomato;
        }

        @NotNull
        public final Color getTurquoise() {
            return turquoise;
        }

        @NotNull
        public final Color getViolet() {
            return violet;
        }

        @NotNull
        public final Color getWheat() {
            return wheat;
        }

        @NotNull
        public final Color getWhite() {
            return white;
        }

        @NotNull
        public final Color getWhiteSmoke() {
            return whiteSmoke;
        }

        @NotNull
        public final Color getYellow() {
            return yellow;
        }

        @NotNull
        public final Color getYellowGreen() {
            return yellowGreen;
        }

        public final double normalizeFractionalPercent(double value) {
            return RangesKt.coerceIn((double)value, (double)0.0, (double)1.0);
        }

        public final int normalizePercent(int value) {
            return RangesKt.coerceIn((int)value, (int)0, (int)100);
        }

        public final int normalizeRGB(int value) {
            return RangesKt.coerceIn((int)value, (int)0, (int)255);
        }

        public final int normalizeHue(double value) {
            return MathKt.roundToInt((double)((value % (double)360 + (double)360) % (double)360));
        }

        public final double normalizeAlpha(double value) {
            return this.normalizeFractionalPercent(value);
        }

        private final Regex getHSLA_REGEX() {
            Lazy lazy = HSLA_REGEX$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Regex)lazy.getValue();
        }

        private final Regex getRGBA_REGEX() {
            Lazy lazy = RGBA_REGEX$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Regex)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

