/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.css;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.css.Color;
import kotlinx.css.FlexBasis;
import kotlinx.css.Gap;
import kotlinx.css.LinearDimension;
import kotlinx.css.QuotedString;
import kotlinx.css.VerticalAlign;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u001e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b\u001a&\u0010 \u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001e\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001b\u001a&\u0010%\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010&\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\f\u0010'\u001a\u00020\u000f*\u00020\u000fH\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\b\u00a8\u0006("}, d2={"basis", "Lkotlinx/css/FlexBasis;", "Lkotlinx/css/LinearDimension;", "getBasis", "(Lkotlinx/css/LinearDimension;)Lkotlinx/css/FlexBasis;", "down", "Lkotlinx/css/VerticalAlign;", "getDown", "(Lkotlinx/css/LinearDimension;)Lkotlinx/css/VerticalAlign;", "gap", "Lkotlinx/css/Gap;", "getGap", "(Lkotlinx/css/LinearDimension;)Lkotlinx/css/Gap;", "quoted", "Lkotlinx/css/QuotedString;", "", "getQuoted", "(Ljava/lang/String;)Lkotlinx/css/QuotedString;", "up", "getUp", "blackAlpha", "Lkotlinx/css/Color;", "alpha", "", "formatAlpha", "hex", "value", "", "hsl", "hue", "saturation", "lightness", "hsla", "rgb", "red", "green", "blue", "rgba", "whiteAlpha", "withZeros", "kotlin-css"})
public final class StyleEnumsKt {
    private static final String withZeros(String $this$withZeros) {
        int n = 0;
        int n2 = 3 - $this$withZeros.length();
        boolean bl = false;
        return $this$withZeros + StringsKt.repeat((CharSequence)"0", (int)Math.max(n, n2));
    }

    @NotNull
    public static final Color hex(int value) {
        StringBuilder stringBuilder = new StringBuilder().append('#');
        int n = value;
        int n2 = 16;
        boolean bl = false;
        String string = Integer.toString(n, CharsKt.checkRadix((int)n2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
        return new Color(stringBuilder.append(StyleEnumsKt.withZeros(string)).toString());
    }

    @NotNull
    public static final Color rgb(int red, int green, int blue) {
        return new Color("rgb(" + red + ", " + green + ", " + blue + ')');
    }

    @NotNull
    public static final Color rgba(int red, int green, int blue, double alpha) {
        return new Color("rgba(" + red + ", " + green + ", " + blue + ", " + StyleEnumsKt.formatAlpha(alpha) + ')');
    }

    @NotNull
    public static final Color hsl(int hue, int saturation, int lightness) {
        return new Color("hsl(" + hue + ", " + saturation + "%, " + lightness + "%)");
    }

    @NotNull
    public static final Color hsla(int hue, int saturation, int lightness, double alpha) {
        return new Color("hsla(" + hue + ", " + saturation + "%, " + lightness + "%, " + StyleEnumsKt.formatAlpha(alpha) + ')');
    }

    @NotNull
    public static final Color blackAlpha(double alpha) {
        return Color.Companion.getBlack().withAlpha(alpha);
    }

    @NotNull
    public static final Color whiteAlpha(double alpha) {
        return Color.Companion.getWhite().withAlpha(alpha);
    }

    private static final String formatAlpha(double alpha) {
        String string = String.valueOf(alpha);
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        return StringsKt.contains$default((CharSequence)it, (CharSequence)".", (boolean)false, (int)2, null) ? it : it + ".0";
    }

    @NotNull
    public static final QuotedString getQuoted(@NotNull String $this$quoted) {
        Intrinsics.checkNotNullParameter((Object)$this$quoted, (String)"$this$quoted");
        return new QuotedString($this$quoted);
    }

    @NotNull
    public static final FlexBasis getBasis(@NotNull LinearDimension $this$basis) {
        Intrinsics.checkNotNullParameter((Object)$this$basis, (String)"$this$basis");
        return new FlexBasis($this$basis.toString());
    }

    @NotNull
    public static final Gap getGap(@NotNull LinearDimension $this$gap) {
        Intrinsics.checkNotNullParameter((Object)$this$gap, (String)"$this$gap");
        return new Gap($this$gap.getValue());
    }

    @NotNull
    public static final VerticalAlign getUp(@NotNull LinearDimension $this$up) {
        Intrinsics.checkNotNullParameter((Object)$this$up, (String)"$this$up");
        return new VerticalAlign($this$up.toString());
    }

    @NotNull
    public static final VerticalAlign getDown(@NotNull LinearDimension $this$down) {
        Intrinsics.checkNotNullParameter((Object)$this$down, (String)"$this$down");
        return new VerticalAlign($this$down.unaryMinus().toString());
    }
}

