/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsInheritanceChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "findFakeMethodOverridingExternalWithOptionalParams", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "cls", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isOverridingExternalWithOptionalParams", "", "function", "js.frontend"})
@SourceDebugExtension(value={"SMAP\nJsInheritanceChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsInheritanceChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsInheritanceChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1747#2,3:76\n766#2:79\n857#2,2:80\n1747#2,3:82\n1603#2,9:85\n1855#2:94\n1856#2:96\n1612#2:97\n766#2:98\n857#2,2:99\n288#2,2:101\n1#3:95\n*S KotlinDebug\n*F\n+ 1 JsInheritanceChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsInheritanceChecker\n*L\n50#1:76,3\n60#1:79\n60#1:80,2\n61#1:82,3\n69#1:85,9\n69#1:94\n69#1:96\n69#1:97\n70#1:98\n70#1:99,2\n72#1:101,2\n69#1:95\n*E\n"})
public final class JsInheritanceChecker
implements DeclarationChecker {
    @NotNull
    public static final JsInheritanceChecker INSTANCE = new JsInheritanceChecker();

    private JsInheritanceChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        FunctionDescriptor fakeOverriddenMethod;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (descriptor2 instanceof FunctionDescriptor && !DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2) && this.isOverridingExternalWithOptionalParams((FunctionDescriptor)descriptor2)) {
            context.getTrace().report(ErrorsJs.OVERRIDING_EXTERNAL_FUN_WITH_OPTIONAL_PARAMS.on((KtElement)((PsiElement)declaration)));
        } else if (descriptor2 instanceof ClassDescriptor && !DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2) && (fakeOverriddenMethod = this.findFakeMethodOverridingExternalWithOptionalParams((ClassDescriptor)descriptor2)) != null) {
            context.getTrace().report(ErrorsJs.OVERRIDING_EXTERNAL_FUN_WITH_OPTIONAL_PARAMS_WITH_FAKE.on((KtElement)((PsiElement)declaration), fakeOverriddenMethod));
        }
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowImplementingFunctionInterface) && descriptor2 instanceof ClassDescriptor) {
            boolean bl;
            block8: {
                SimpleType simpleType2 = ((ClassDescriptor)descriptor2).getDefaultType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"descriptor.defaultType");
                Iterable $this$any$iv = TypeUtilsKt.immediateSupertypes(simpleType2);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        boolean bl2 = false;
                        if (!(FunctionTypesKt.isBuiltinFunctionalTypeOrSubtype(it) && !FunctionTypesKt.isSuspendFunctionTypeOrSubtype(it))) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                context.getTrace().report(ErrorsJs.IMPLEMENTING_FUNCTION_INTERFACE.on((KtClassOrObject)((PsiElement)((KtClassOrObject)declaration))));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isOverridingExternalWithOptionalParams(FunctionDescriptor function2) {
        void $this$filterTo$iv$iv;
        if (!function2.getKind().isReal() && function2.getModality() == Modality.ABSTRACT) {
            return false;
        }
        Collection<? extends FunctionDescriptor> collection = function2.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"function.overriddenDescriptors");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!DescriptorUtilsKt.isEffectivelyExternal(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (FunctionDescriptor overriddenFunction : (List)destination$iv$iv) {
            boolean bl;
            block6: {
                List<ValueParameterDescriptor> list2 = overriddenFunction.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"overriddenFunction.valueParameters");
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!ArgumentsUtilsKt.hasDefaultValue(it)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final FunctionDescriptor findFakeMethodOverridingExternalWithOptionalParams(ClassDescriptor cls) {
        Object v1;
        block3: {
            void $this$filterTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            MemberScope memberScope2 = cls.getUnsubstitutedMemberScope();
            Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"cls.unsubstitutedMemberScope");
            Iterable $this$mapNotNull$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(memberScope2, DescriptorKindFilter.CALLABLES, null, 2, null);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FunctionDescriptor it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof FunctionDescriptor ? (FunctionDescriptor)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getContainingDeclaration(), (Object)cls) && !it.getKind().isReal() && it.getOverriddenDescriptors().size() > 1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List members2 = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = members2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FunctionDescriptor it = (FunctionDescriptor)element$iv;
                boolean bl = false;
                if (!INSTANCE.isOverridingExternalWithOptionalParams(it)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }
}

