/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeKlibCommonizerToolRunner;
import org.jetbrains.kotlin.compilerRunner.NativeToolRunnersKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r\u001a\u001e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0010H\u0002\u001a\u001e\u0010\u0017\u001a\u00020\u0010*\u00020\u000b2\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001bH\u0000\u001a\u001e\u0010\u001c\u001a\u00020\u0010*\u00020\u000b2\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0005\u001a\n \u0004*\u0004\u0018\u00010\u00010\u0001*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007*\u0018\b\u0000\u0010\u001d\"\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a8\u0006\u001e"}, d2={"COMMONIZER_TASK_NAME", "", "base64Encoder", "Ljava/util/Base64$Encoder;", "kotlin.jvm.PlatformType", "base64", "getBase64", "(Ljava/lang/String;)Ljava/lang/String;", "callCommonizerCLI", "", "project", "Lorg/gradle/api/Project;", "commandLineArguments", "", "cleanUp", "baseDirectory", "Ljava/io/File;", "excludedDirectories", "renameDirectory", "source", "destination", "renameToTempAndDelete", "directory", "createTempNativeDistributionCommonizerOutputDirectory", "targets", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/KonanTargetGroup;", "nativeDistributionCommonizerOutputDirectory", "KonanTargetGroup", "kotlin-gradle-plugin"})
public final class CommonizerTaskKt {
    @NotNull
    public static final String COMMONIZER_TASK_NAME = "runCommonizer";
    private static final Base64.Encoder base64Encoder = Base64.getEncoder().withoutPadding();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File nativeDistributionCommonizerOutputDirectory(@NotNull Project $this$nativeDistributionCommonizerOutputDirectory, @NotNull Set<? extends KonanTarget> targets) {
        KonanTarget konanTarget2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$nativeDistributionCommonizerOutputDirectory, (String)"<this>");
        Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
        Object object = $this$nativeDistributionCommonizerOutputDirectory.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project");
        object = KotlinPluginWrapperKt.getKotlinPluginVersion(object);
        boolean bl = false;
        boolean bl2 = false;
        if (object == null) {
            boolean bl3 = false;
            String string = "Failed infering Kotlin Plugin version";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Object kotlinVersion = object;
        Iterable $this$map$iv = targets;
        boolean $i$f$map = false;
        Iterable bl3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            konanTarget2 = (KonanTarget)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            String string = it.getName();
            collection.add(string);
        }
        List orderedTargetNames = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl5 = false;
        boolean bl6 = false;
        StringBuilder $this$nativeDistributionCommonizerOutputDirectory_u24lambda_u2d2 = stringBuilder;
        boolean bl7 = false;
        CollectionsKt.joinTo$default((Iterable)orderedTargetNames, (Appendable)$this$nativeDistributionCommonizerOutputDirectory_u24lambda_u2d2, (CharSequence)"-", null, null, (int)0, null, null, (int)124, null);
        $this$nativeDistributionCommonizerOutputDirectory_u24lambda_u2d2.append("-");
        konanTarget2 = kotlinVersion;
        boolean bl8 = false;
        String string = konanTarget2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
        $this$nativeDistributionCommonizerOutputDirectory_u24lambda_u2d2.append(CommonizerTaskKt.getBase64(string));
        String string2 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String discriminator = string2;
        File file = $this$nativeDistributionCommonizerOutputDirectory.getProject().file((Object)NativeToolRunnersKt.getKonanHome($this$nativeDistributionCommonizerOutputDirectory));
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.file(konanHome)");
        return FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)file, (String)"klib"), (String)"commonized"), (String)discriminator);
    }

    @NotNull
    public static final File createTempNativeDistributionCommonizerOutputDirectory(@NotNull Project $this$createTempNativeDistributionCommonizerOutputDirectory, @NotNull Set<? extends KonanTarget> targets) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createTempNativeDistributionCommonizerOutputDirectory, (String)"<this>");
        Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
        File outputDirectory = CommonizerTaskKt.nativeDistributionCommonizerOutputDirectory($this$createTempNativeDistributionCommonizerOutputDirectory, targets);
        outputDirectory.getParentFile().mkdirs();
        File file = Files.createTempDirectory(outputDirectory.getParentFile().toPath(), Intrinsics.stringPlus((String)"tmp-new-", (Object)outputDirectory.getName()), new FileAttribute[0]).toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"createTempDirectory(\n        /* dir = */ outputDirectory.parentFile.toPath(),\n        /* prefix = */ \"tmp-new-${outputDirectory.name}\"\n    ).toFile()");
        return file;
    }

    public static final void callCommonizerCLI(@NotNull Project project, @NotNull List<String> commandLineArguments) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(commandLineArguments, (String)"commandLineArguments");
        if (commandLineArguments.isEmpty()) {
            return;
        }
        new KotlinNativeKlibCommonizerToolRunner(project).run(commandLineArguments);
    }

    private static final void renameDirectory(File source2, File destination) {
        Path sourcePath = source2.toPath();
        Path destinationPath = destination.toPath();
        int n = 0;
        List suppressedExceptions = new ArrayList();
        n = 0;
        while (true) {
            int it = n++;
            try {
                CommonizerTaskKt.renameToTempAndDelete(destination);
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
                Files.move(sourcePath, destinationPath, copyOptionArray);
                return;
            }
            catch (IOException e) {
                Collection collection = suppressedExceptions;
                boolean bl = false;
                collection.add(e);
                if (!(e instanceof AtomicMoveNotSupportedException) && n < 3) continue;
                IllegalStateException illegalStateException = new IllegalStateException("Failed to rename " + source2 + " to " + destination);
                boolean bl2 = false;
                boolean bl3 = false;
                IllegalStateException $this$renameDirectory_u24lambda_u2d3 = illegalStateException;
                boolean bl4 = false;
                Iterable $this$forEach$iv = suppressedExceptions;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Throwable p0 = (Throwable)element$iv;
                    boolean bl5 = false;
                    $this$renameDirectory_u24lambda_u2d3.addSuppressed(p0);
                }
                throw (Throwable)illegalStateException;
            }
            break;
        }
    }

    private static final void renameToTempAndDelete(File directory2) {
        File file;
        if (!directory2.exists()) {
            return;
        }
        String string = directory2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"directory.name");
        if (StringsKt.startsWith$default((String)string, (String)"tmp-", (boolean)false, (int)2, null)) {
            file = directory2;
        } else {
            Path tempDir = Files.createTempFile(directory2.getParentFile().toPath(), Intrinsics.stringPlus((String)"tmp-old-", (Object)directory2.getName()), null, new FileAttribute[0]);
            Files.delete(tempDir);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            Files.move(directory2.toPath(), tempDir, copyOptionArray);
            file = tempDir.toFile();
        }
        File dirToRemove = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)dirToRemove, (String)"dirToRemove");
        FilesKt.deleteRecursively((File)dirToRemove);
    }

    /*
     * WARNING - void declaration
     */
    private static final void cleanUp(File baseDirectory, List<? extends File> excludedDirectories) {
        void $this$mapTo$iv$iv;
        Instant now = Instant.now();
        Instant oneHourAgo = now.minus(Duration.ofHours(1L));
        Instant oneMonthAgo = now.minus(Duration.ofDays(31L));
        Iterable $this$map$iv = excludedDirectories;
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getAbsolutePath();
            collection.add(string);
        }
        Set excludedPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        File[] fileArray = baseDirectory.listFiles();
        if (fileArray != null) {
            void $this$forEach$iv;
            File[] $i$f$map2 = fileArray;
            boolean $i$f$forEach = false;
            void var9_10 = $this$forEach$iv;
            int n = ((void)var9_10).length;
            for (int j = 0; j < n; ++j) {
                void element$iv;
                void file = element$iv = var9_10[j];
                boolean bl = false;
                if (excludedPaths.contains(file.getAbsolutePath())) continue;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"file");
                Object object = CommonizerTaskKt.cleanUp$getAttributes((File)file);
                if (object == null) continue;
                Object attributes = object;
                if (attributes.isDirectory()) {
                    object = file.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"file.name");
                    if (StringsKt.startsWith$default((String)object, (String)"tmp-", (boolean)false, (int)2, null)) {
                        object = attributes.creationTime();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"attributes.creationTime()");
                        Intrinsics.checkExpressionValueIsNotNull((Object)oneHourAgo, (String)"oneHourAgo");
                        if (CommonizerTaskKt.cleanUp$isSameOrAfter((FileTime)object, oneHourAgo)) {
                            continue;
                        }
                    } else {
                        object = attributes.lastAccessTime();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"attributes.lastAccessTime()");
                        Intrinsics.checkExpressionValueIsNotNull((Object)oneMonthAgo, (String)"oneMonthAgo");
                        if (CommonizerTaskKt.cleanUp$isSameOrAfter((FileTime)object, oneMonthAgo)) continue;
                    }
                }
                try {
                    CommonizerTaskKt.renameToTempAndDelete((File)file);
                    continue;
                }
                catch (IOException iOException) {
                }
            }
        }
    }

    private static final String getBase64(String $this$base64) {
        String string = $this$base64;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return base64Encoder.encodeToString(byArray);
    }

    private static final BasicFileAttributes cleanUp$getAttributes(File $this$cleanUp_u24getAttributes) {
        BasicFileAttributes basicFileAttributes;
        try {
            basicFileAttributes = Files.readAttributes($this$cleanUp_u24getAttributes.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException _) {
            basicFileAttributes = null;
        }
        return basicFileAttributes;
    }

    private static final boolean cleanUp$isSameOrAfter(FileTime $this$cleanUp_u24isSameOrAfter, Instant targetInstant) {
        Instant fileInstant = $this$cleanUp_u24isSameOrAfter.toInstant();
        if (fileInstant.atZone(ZoneOffset.UTC).toLocalDate().getYear() <= 1970) {
            return false;
        }
        return fileInstant.compareTo(targetInstant) >= 0;
    }

    public static final /* synthetic */ void access$cleanUp(File baseDirectory, List excludedDirectories) {
        CommonizerTaskKt.cleanUp(baseDirectory, excludedDirectories);
    }

    public static final /* synthetic */ void access$renameToTempAndDelete(File directory2) {
        CommonizerTaskKt.renameToTempAndDelete(directory2);
    }

    public static final /* synthetic */ void access$renameDirectory(File source2, File destination) {
        CommonizerTaskKt.renameDirectory(source2, destination);
    }
}

