/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.model.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.Coroutines;
import org.jetbrains.kotlin.gradle.model.CompilerArguments;
import org.jetbrains.kotlin.gradle.model.ExperimentalFeatures;
import org.jetbrains.kotlin.gradle.model.KotlinProject;
import org.jetbrains.kotlin.gradle.model.SourceSet;
import org.jetbrains.kotlin.gradle.model.impl.CompilerArgumentsImpl;
import org.jetbrains.kotlin.gradle.model.impl.ExperimentalFeaturesImpl;
import org.jetbrains.kotlin.gradle.model.impl.KotlinProjectImpl;
import org.jetbrains.kotlin.gradle.model.impl.SourceSetImpl;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJvmAndroidCompilation;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/model/builder/KotlinModelBuilder;", "Lorg/gradle/tooling/provider/model/ToolingModelBuilder;", "kotlinPluginVersion", "", "androidTarget", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;)V", "buildAll", "", "modelName", "project", "Lorg/gradle/api/Project;", "canBuild", "", "Companion", "kotlin-gradle-plugin"})
public final class KotlinModelBuilder
implements ToolingModelBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String kotlinPluginVersion;
    @Nullable
    private final KotlinAndroidTarget androidTarget;

    public KotlinModelBuilder(@NotNull String kotlinPluginVersion2, @Nullable KotlinAndroidTarget androidTarget) {
        Intrinsics.checkNotNullParameter((Object)kotlinPluginVersion2, (String)"kotlinPluginVersion");
        this.kotlinPluginVersion = kotlinPluginVersion2;
        this.androidTarget = androidTarget;
    }

    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)modelName, (Object)KotlinProject.class.getName());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object buildAll(@NotNull String modelName, @NotNull Project project) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean bl = this.canBuild(modelName);
        if (!bl) {
            boolean $i$a$-require-KotlinModelBuilder$buildAll$22 = false;
            String $i$a$-require-KotlinModelBuilder$buildAll$22 = "buildAll(\"" + modelName + "\") has been called while canBeBuild is false";
            throw (Throwable)new IllegalArgumentException($i$a$-require-KotlinModelBuilder$buildAll$22.toString());
        }
        TaskCollection taskCollection = project.getTasks().withType(AbstractKotlinCompile.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"project.tasks.withType(A\u2026otlinCompile::class.java)");
        List kotlinCompileTasks = CollectionsKt.toList((Iterable)((Iterable)taskCollection));
        KotlinProject.ProjectType projectType = KotlinModelBuilder.Companion.getProjectType(project);
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        Iterable iterable = kotlinCompileTasks;
        KotlinProject.ProjectType projectType2 = projectType;
        String string2 = this.kotlinPluginVersion;
        String string3 = string;
        boolean $i$f$mapNotNull = false;
        void var7_13 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SourceSet sourceSet;
            SourceSet sourceSet2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            AbstractKotlinCompile it = (AbstractKotlinCompile)element$iv$iv;
            boolean bl3 = false;
            if (this.androidTarget != null) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                sourceSet2 = KotlinModelBuilder.Companion.createAndroidSourceSet(it, this.androidTarget);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                sourceSet2 = KotlinModelBuilder.Companion.createSourceSet(it, project, projectType);
            }
            if (sourceSet2 == null) continue;
            SourceSet it$iv$iv = sourceSet = sourceSet2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        Collection collection = list2;
        Collection collection2 = KotlinModelBuilder.Companion.getExpectedByDependencies(project);
        Object object = CollectionsKt.first((List)kotlinCompileTasks);
        Intrinsics.checkNotNull((Object)object);
        ExperimentalFeatures experimentalFeatures = KotlinModelBuilder.Companion.createExperimentalFeatures((AbstractKotlinCompile)object);
        Collection collection3 = collection2;
        Collection collection4 = collection;
        KotlinProject.ProjectType projectType3 = projectType2;
        String string4 = string2;
        String string5 = string3;
        return new KotlinProjectImpl(string5, string4, projectType3, collection4, collection3, experimentalFeatures);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\n\u001a\u00020\u000b*\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\fH\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\tH\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0007H\u0002J\u0014\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u00050\u0005*\u00020\u0007H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/gradle/model/builder/KotlinModelBuilder$Companion;", "", "()V", "getExpectedByDependencies", "", "", "project", "Lorg/gradle/api/Project;", "getProjectType", "Lorg/jetbrains/kotlin/gradle/model/KotlinProject$ProjectType;", "createAndroidSourceSet", "Lorg/jetbrains/kotlin/gradle/model/SourceSet;", "Lorg/jetbrains/kotlin/gradle/tasks/AbstractKotlinCompile;", "androidTarget", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "createCompilerArguments", "Lorg/jetbrains/kotlin/gradle/model/CompilerArguments;", "createExperimentalFeatures", "Lorg/jetbrains/kotlin/gradle/model/ExperimentalFeatures;", "createSourceSet", "projectType", "isAndroid", "", "pathOrName", "kotlin.jvm.PlatformType", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isAndroid(Project $this$isAndroid) {
            return $this$isAndroid.getProject().getPlugins().hasPlugin("kotlin-android");
        }

        private final KotlinProject.ProjectType getProjectType(Project project) {
            return project.getPlugins().hasPlugin("kotlin") || project.getPlugins().hasPlugin("kotlin-platform-jvm") || this.isAndroid(project) ? KotlinProject.ProjectType.PLATFORM_JVM : (project.getPlugins().hasPlugin("kotlin2js") || project.getPlugins().hasPlugin("kotlin-platform-js") ? KotlinProject.ProjectType.PLATFORM_JS : KotlinProject.ProjectType.PLATFORM_COMMON);
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<String> getExpectedByDependencies(Project project) {
            void $this$mapTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Object list$iv$iv;
            String it;
            Iterable $this$flatMapTo$iv$iv;
            Object[] objectArray = new String[]{"expectedBy", "implement"};
            Iterable $this$flatMap$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Set set2;
                DependencySet dependencySet;
                it = (String)element$iv$iv;
                boolean bl = false;
                Configuration configuration2 = (Configuration)project.getConfigurations().findByName(it);
                DependencySet dependencySet2 = dependencySet = configuration2 != null ? configuration2.getDependencies() : null;
                if (dependencySet2 == null) {
                    set2 = SetsKt.emptySet();
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)dependencySet2, (String)"project.configurations.f\u2026?: emptySet<Dependency>()");
                    set2 = (Set)dependencySet;
                }
                list$iv$iv = set2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ProjectDependency)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            list$iv$iv = $this$forEach$iv$iv$iv.iterator();
            while (list$iv$iv.hasNext()) {
                Project project2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
                boolean bl = false;
                ProjectDependency it2 = (ProjectDependency)element$iv$iv;
                boolean bl2 = false;
                if (it2.getDependencyProject() == null) continue;
                Project it$iv$iv = project2;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (Project)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.pathOrName((Project)it));
            }
            return (List)destination$iv$iv;
        }

        private final String pathOrName(Project $this$pathOrName) {
            return Intrinsics.areEqual((Object)$this$pathOrName.getPath(), (Object)":") ? $this$pathOrName.getName() : $this$pathOrName.getPath();
        }

        private final SourceSet createSourceSet(AbstractKotlinCompile<?> $this$createSourceSet, Project project, KotlinProject.ProjectType projectType) {
            SourceSet sourceSet;
            KotlinSourceSet kotlinSourceSet;
            org.gradle.api.tasks.SourceSet javaSourceSet;
            org.gradle.api.tasks.SourceSet sourceSet2;
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPluginConvention != null && (javaPluginConvention = javaPluginConvention.getSourceSets()) != null) {
                Object v1;
                block5: {
                    Iterable iterable;
                    Iterable iterable2 = iterable = (Iterable)javaPluginConvention;
                    for (Object t : iterable2) {
                        org.gradle.api.tasks.SourceSet it = (org.gradle.api.tasks.SourceSet)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)$this$createSourceSet.getSourceSetName$kotlin_gradle_plugin().get())) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                sourceSet2 = v1;
            } else {
                sourceSet2 = null;
            }
            org.gradle.api.tasks.SourceSet sourceSet3 = javaSourceSet = sourceSet2;
            Object object = sourceSet3 != null ? GradleUtilsKt.getConvention(sourceSet3, projectType == KotlinProject.ProjectType.PLATFORM_JS ? KotlinPluginKt.getKOTLIN_JS_DSL_NAME() : KotlinPluginKt.getKOTLIN_DSL_NAME()) : null;
            KotlinSourceSet kotlinSourceSet2 = kotlinSourceSet = object instanceof KotlinSourceSet ? (KotlinSourceSet)object : null;
            if (kotlinSourceSet != null) {
                Object object2 = $this$createSourceSet.getSourceSetName$kotlin_gradle_plugin().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"sourceSetName.get()");
                String string = (String)object2;
                Object object3 = $this$createSourceSet.getSourceSetName$kotlin_gradle_plugin().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"sourceSetName.get()");
                SourceSet.SourceSetType sourceSetType = StringsKt.contains((CharSequence)((CharSequence)object3), (CharSequence)"test", (boolean)true) ? SourceSet.SourceSetType.TEST : SourceSet.SourceSetType.PRODUCTION;
                Object object4 = $this$createSourceSet.getFriendSourceSets$kotlin_gradle_plugin().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"friendSourceSets.get()");
                Collection collection = (Collection)object4;
                Set set2 = kotlinSourceSet.getKotlin().getSrcDirs();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"kotlinSourceSet.kotlin.srcDirs");
                Collection collection2 = set2;
                Set set3 = javaSourceSet.getResources().getSrcDirs();
                Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"javaSourceSet.resources.srcDirs");
                Collection collection3 = set3;
                File file = $this$createSourceSet.getDestinationDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"destinationDir");
                File file2 = javaSourceSet.getOutput().getResourcesDir();
                Intrinsics.checkNotNull((Object)file2);
                sourceSet = new SourceSetImpl(string, sourceSetType, collection, collection2, collection3, file, file2, this.createCompilerArguments($this$createSourceSet));
            } else {
                sourceSet = null;
            }
            return sourceSet;
        }

        /*
         * WARNING - void declaration
         */
        private final SourceSet createAndroidSourceSet(AbstractKotlinCompile<?> $this$createAndroidSourceSet, KotlinAndroidTarget androidTarget) {
            void $this$distinctBy$iv;
            void $this$flatMapTo$iv$iv;
            void $this$distinctBy$iv2;
            void $this$flatMapTo$iv$iv2;
            String variantName = (String)$this$createAndroidSourceSet.getSourceSetName$kotlin_gradle_plugin().get();
            KotlinJvmAndroidCompilation compilation2 = (KotlinJvmAndroidCompilation)androidTarget.getCompilations().getByName(variantName);
            Iterable $this$flatMap$iv = compilation2.getAllKotlinSourceSets();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                KotlinSourceSet it = (KotlinSourceSet)element$iv$iv;
                boolean bl = false;
                Set set2 = it.getKotlin().getSrcDirs();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"it.kotlin.srcDirs");
                Iterable list$iv$iv = set2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            Iterable list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv2) {
                File it = (File)e$iv;
                boolean bl = false;
                String key$iv = it.getAbsolutePath();
                if (!set$iv.add(key$iv)) continue;
                ((ArrayList)list$iv).add(e$iv);
            }
            List sources = (List)list$iv;
            Iterable $this$flatMap$iv2 = compilation2.getAllKotlinSourceSets();
            boolean $i$f$flatMap2 = false;
            list$iv = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                KotlinSourceSet it = (KotlinSourceSet)element$iv$iv;
                boolean bl = false;
                Set set3 = it.getResources().getSrcDirs();
                Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"it.resources.srcDirs");
                Iterable list$iv$iv = set3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv2 = (List)destination$iv$iv2;
            boolean $i$f$distinctBy2 = false;
            HashSet<String> set$iv2 = new HashSet<String>();
            ArrayList list$iv2 = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                File it = (File)e$iv;
                boolean bl = false;
                String key$iv = it.getAbsolutePath();
                if (!set$iv2.add(key$iv)) continue;
                list$iv2.add(e$iv);
            }
            List resources = list$iv2;
            Object object = $this$createAndroidSourceSet.getSourceSetName$kotlin_gradle_plugin().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceSetName.get()");
            String string = (String)object;
            Object object2 = $this$createAndroidSourceSet.getSourceSetName$kotlin_gradle_plugin().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"sourceSetName.get()");
            SourceSet.SourceSetType sourceSetType = StringsKt.contains((CharSequence)((CharSequence)object2), (CharSequence)"test", (boolean)true) ? SourceSet.SourceSetType.TEST : SourceSet.SourceSetType.PRODUCTION;
            Object object3 = $this$createAndroidSourceSet.getFriendSourceSets$kotlin_gradle_plugin().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"friendSourceSets.get()");
            Collection collection = (Collection)object3;
            Collection collection2 = sources;
            Collection collection3 = resources;
            File file = $this$createAndroidSourceSet.getDestinationDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"destinationDir");
            return new SourceSetImpl(string, sourceSetType, collection, collection2, collection3, file, compilation2.getOutput().getResourcesDir(), this.createCompilerArguments($this$createAndroidSourceSet));
        }

        private final CompilerArguments createCompilerArguments(AbstractKotlinCompile<?> $this$createCompilerArguments) {
            return new CompilerArgumentsImpl($this$createCompilerArguments.getSerializedCompilerArguments(), $this$createCompilerArguments.getDefaultSerializedCompilerArguments(), CollectionsKt.toList((Iterable)((Iterable)$this$createCompilerArguments.getClasspath())));
        }

        private final ExperimentalFeatures createExperimentalFeatures(AbstractKotlinCompile<?> $this$createExperimentalFeatures) {
            return new ExperimentalFeaturesImpl(((Coroutines)((Object)$this$createExperimentalFeatures.getCoroutines$kotlin_gradle_plugin().get())).name());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

