/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleBuildServices;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.report.BuildMetricsReporterService;
import org.jetbrains.kotlin.gradle.report.BuildReportMode;
import org.jetbrains.kotlin.gradle.report.ConfigureReporingKt;
import org.jetbrains.kotlin.gradle.report.MetricsWriter;
import org.jetbrains.kotlin.gradle.report.PlainTextBuildReportWriterDataProcessor;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;
import org.jetbrains.kotlin.gradle.report.TaskRecord;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionData;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionDataProcessor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0005J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\tH\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\u0012\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00110\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildMetricsReporterService;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/kotlin/gradle/report/BuildMetricsReporterService$Parameters;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Ljava/lang/AutoCloseable;", "()V", "buildMetricsMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "failureMessages", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "taskClass", "taskRecords", "Lorg/jetbrains/kotlin/gradle/report/TaskRecord;", "add", "", "taskPath", "type", "metrics", "close", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "Companion", "Parameters", "kotlin-gradle-plugin"})
public abstract class BuildMetricsReporterService
implements BuildService<Parameters>,
OperationCompletionListener,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log = Logging.getLogger(this.getClass());
    @NotNull
    private final ConcurrentHashMap<String, BuildMetricsReporter> buildMetricsMap = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, TaskRecord> taskRecords = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentLinkedQueue<String> failureMessages = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentHashMap<String, String> taskClass = new ConcurrentHashMap();

    public void add(@NotNull String taskPath, @NotNull String type, @NotNull BuildMetricsReporter metrics) {
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        if (this.buildMetricsMap.containsKey(taskPath)) {
            this.log.warn("Duplicate path " + taskPath);
        }
        ((Map)this.buildMetricsMap).put(taskPath, metrics);
        ((Map)this.taskClass).put(taskPath, type);
    }

    /*
     * WARNING - void declaration
     */
    public void onFinish(@Nullable FinishEvent event) {
        if (event instanceof TaskFinishEvent) {
            TaskExecutionResult taskExecutionResult;
            Object icLogLines;
            TaskExecutionResult it;
            Object object;
            TaskOperationResult result2 = ((TaskFinishEvent)event).getResult();
            String taskPath = ((TaskFinishEvent)event).getDescriptor().getTaskPath();
            long startMs = ((TaskFinishEvent)event).getResult().getStartTime();
            long finishMs = ((TaskFinishEvent)event).getResult().getEndTime();
            if (result2 instanceof TaskFailureResult) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list2 = ((TaskFailureResult)result2).getFailures();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"result.failures");
                Iterable iterable = list2;
                ConcurrentLinkedQueue<String> concurrentLinkedQueue = this.failureMessages;
                boolean $i$f$map = false;
                void var10_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    object = (Failure)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getMessage());
                }
                concurrentLinkedQueue.addAll((List)destination$iv$iv);
            }
            String skipMessage = result2 instanceof TaskSkippedResult ? ((TaskSkippedResult)result2).getSkipMessage() : null;
            boolean didWork = result2 instanceof org.gradle.tooling.events.task.TaskExecutionResult;
            BuildMetrics buildMetrics = new BuildMetrics(null, null, null, 7, null);
            buildMetrics.getBuildTimes().add(BuildTime.GRADLE_TASK, finishMs - startMs);
            BuildMetricsReporter buildMetricsReporter = this.buildMetricsMap.get(taskPath);
            if (buildMetricsReporter != null) {
                BuildMetricsReporter $i$f$mapTo;
                BuildMetricsReporter it2 = $i$f$mapTo = buildMetricsReporter;
                boolean bl = false;
                buildMetrics.addAll(it2.getMetrics());
            }
            Intrinsics.checkNotNullExpressionValue((Object)taskPath, (String)"taskPath");
            TaskExecutionResult taskExecutionResult2 = TaskExecutionResults.INSTANCE.get(taskPath);
            Object object2 = taskExecutionResult2;
            if (object2 == null || (object2 = ((TaskExecutionResult)object2).getIcLogLines()) == null) {
                object2 = icLogLines = CollectionsKt.emptyList();
            }
            if ((taskExecutionResult = taskExecutionResult2) != null && (taskExecutionResult = taskExecutionResult.getBuildMetrics()) != null) {
                TaskExecutionResult taskExecutionResult3;
                it = taskExecutionResult3 = taskExecutionResult;
                boolean bl = false;
                buildMetrics.addAll((BuildMetrics)it);
            }
            Map map = this.taskRecords;
            String string = taskPath;
            String string2 = this.taskClass.get(taskPath);
            if (string2 == null) {
                string2 = "unknown";
            }
            object = new TaskRecord(taskPath, startMs, finishMs, skipMessage, didWork, (List<String>)icLogLines, buildMetrics, string2);
            map.put(string, object);
        }
    }

    @Override
    public void close() {
        Collection collection = ((Parameters)this.getParameters()).getStartParameters();
        List list2 = CollectionsKt.toList((Iterable)this.failureMessages);
        Collection<TaskRecord> collection2 = this.taskRecords.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"taskRecords.values");
        Iterable $this$sortedBy$iv = collection2;
        boolean $i$f$sortedBy = false;
        BuildExecutionData buildData = new BuildExecutionData(collection, list2, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                TaskRecord it = (TaskRecord)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getStartMs());
                it = (TaskRecord)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getStartMs()));
            }
        }));
        Iterable $this$forEach$iv = ((Parameters)this.getParameters()).getBuildDataProcessors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildExecutionDataProcessor it = (BuildExecutionDataProcessor)element$iv;
            boolean bl = false;
            Logger logger = this.log;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
            it.process(buildData, logger);
        }
        this.buildMetricsMap.clear();
        this.taskRecords.clear();
        this.failureMessages.clear();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u001e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\nX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0006\"\u0004\b\u0012\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildMetricsReporterService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "buildDataProcessors", "", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionDataProcessor;", "getBuildDataProcessors", "()Ljava/util/List;", "setBuildDataProcessors", "(Ljava/util/List;)V", "reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "getReportingSettings", "()Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "setReportingSettings", "(Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;)V", "startParameters", "", "getStartParameters", "setStartParameters", "kotlin-gradle-plugin"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public List<BuildExecutionDataProcessor> getBuildDataProcessors();

        public void setBuildDataProcessors(@NotNull List<? extends BuildExecutionDataProcessor> var1);

        @NotNull
        public List<String> getStartParameters();

        public void setStartParameters(@NotNull List<String> var1);

        @NotNull
        public ReportingSettings getReportingSettings();

        public void setReportingSettings(@NotNull ReportingSettings var1);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0006\u0010\u0007\u001a\u00020\bJ$\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildMetricsReporterService$Companion;", "", "()V", "getStartParameters", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "project", "Lorg/gradle/api/Project;", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/report/BuildMetricsReporterService;", "startParameters", "", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ArrayList<String> getStartParameters(@NotNull Project project) {
            StartParameter startParameter;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            StartParameter it = startParameter = project.getGradle().getStartParameter();
            boolean bl = false;
            ArrayList<String> startParameters = new ArrayList<String>();
            StringBuilder stringBuilder = new StringBuilder().append("tasks = ");
            List list2 = it.getTaskRequests();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it.taskRequests");
            startParameters.add(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, (Function1)getStartParameters.1.1.INSTANCE, (int)31, null)).toString());
            startParameters.add("excluded tasks = " + it.getExcludedTaskNames());
            startParameters.add("current dir = " + it.getCurrentDir());
            startParameters.add("project properties args = " + it.getProjectProperties());
            startParameters.add("system properties args = " + it.getSystemPropertiesArgs());
            return startParameters;
        }

        @Nullable
        public final Provider<BuildMetricsReporterService> registerIfAbsent(@NotNull Project project, @NotNull List<String> startParameters) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(startParameters, (String)"startParameters");
            ArrayList<BuildExecutionDataProcessor> buildDataProcessors = new ArrayList<BuildExecutionDataProcessor>();
            Project rootProject = project.getGradle().getRootProject();
            Intrinsics.checkNotNullExpressionValue((Object)rootProject, (String)"rootProject");
            ReportingSettings reportingSettings = ConfigureReporingKt.reportingSettings(rootProject);
            if (reportingSettings.getBuildReportMode() != BuildReportMode.NONE && reportingSettings.getBuildReportDir() != null) {
                File file = reportingSettings.getBuildReportDir();
                String string = rootProject.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rootProject.name");
                buildDataProcessors.add(new PlainTextBuildReportWriterDataProcessor(reportingSettings, file, string));
            }
            if (reportingSettings.getMetricsOutputFile() != null) {
                File file = reportingSettings.getMetricsOutputFile().getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"reportingSettings.metricsOutputFile.absoluteFile");
                buildDataProcessors.add(new MetricsWriter(file));
            }
            if (buildDataProcessors.isEmpty()) {
                return null;
            }
            Provider provider = project.getGradle().getSharedServices().registerIfAbsent("build_metric_service_" + KotlinGradleBuildServices.class.getClassLoader().hashCode(), BuildMetricsReporterService.class, new Action(startParameters, buildDataProcessors, reportingSettings){
                final /* synthetic */ List<String> $startParameters;
                final /* synthetic */ ArrayList<BuildExecutionDataProcessor> $buildDataProcessors;
                final /* synthetic */ ReportingSettings $reportingSettings;
                {
                    this.$startParameters = $startParameters;
                    this.$buildDataProcessors = $buildDataProcessors;
                    this.$reportingSettings = $reportingSettings;
                }

                public final void execute(BuildServiceSpec<Parameters> it) {
                    ((Parameters)it.getParameters()).setStartParameters(this.$startParameters);
                    ((Parameters)it.getParameters()).setBuildDataProcessors((List<? extends BuildExecutionDataProcessor>)this.$buildDataProcessors);
                    ((Parameters)it.getParameters()).setReportingSettings(this.$reportingSettings);
                }
            });
            Intrinsics.checkNotNull((Object)provider);
            return provider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

