/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.sources.SourceSetsVisibilityInferenceKt;
import org.jetbrains.kotlin.gradle.plugin.sources.UnsatisfiedSourceSetVisibilityException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\nR\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/UnsatisfiedSourceSetVisibilityException;", "Lorg/gradle/api/GradleException;", "sourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "compilations", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "visibleSourceSets", "", "requiredButNotVisible", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;Ljava/util/Set;Ljava/util/List;Ljava/util/Set;)V", "getCompilations", "()Ljava/util/Set;", "message", "", "getMessage", "()Ljava/lang/String;", "getRequiredButNotVisible", "getSourceSet", "()Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "getVisibleSourceSets", "()Ljava/util/List;", "kotlin-gradle-plugin_common"})
public final class UnsatisfiedSourceSetVisibilityException
extends GradleException {
    @NotNull
    private final KotlinSourceSet sourceSet;
    @NotNull
    private final Set<KotlinCompilation<?>> compilations;
    @NotNull
    private final List<KotlinSourceSet> visibleSourceSets;
    @NotNull
    private final Set<KotlinSourceSet> requiredButNotVisible;

    public UnsatisfiedSourceSetVisibilityException(@NotNull KotlinSourceSet sourceSet, @NotNull Set<? extends KotlinCompilation<?>> compilations, @NotNull List<? extends KotlinSourceSet> visibleSourceSets, @NotNull Set<? extends KotlinSourceSet> requiredButNotVisible) {
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        Intrinsics.checkNotNullParameter(compilations, (String)"compilations");
        Intrinsics.checkNotNullParameter(visibleSourceSets, (String)"visibleSourceSets");
        Intrinsics.checkNotNullParameter(requiredButNotVisible, (String)"requiredButNotVisible");
        this.sourceSet = sourceSet;
        this.compilations = compilations;
        this.visibleSourceSets = visibleSourceSets;
        this.requiredButNotVisible = requiredButNotVisible;
    }

    @NotNull
    public final KotlinSourceSet getSourceSet() {
        return this.sourceSet;
    }

    @NotNull
    public final Set<KotlinCompilation<?>> getCompilations() {
        return this.compilations;
    }

    @NotNull
    public final List<KotlinSourceSet> getVisibleSourceSets() {
        return this.visibleSourceSets;
    }

    @NotNull
    public final Set<KotlinSourceSet> getRequiredButNotVisible() {
        return this.requiredButNotVisible;
    }

    @Nullable
    public String getMessage() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_message__u24lambda_u2d5 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_message__u24lambda_u2d5.append("The source set " + this.sourceSet.getName() + " requires visibility of the " + UnsatisfiedSourceSetVisibilityException._get_message_$lambda-5$singularOrPlural((Collection)this.requiredButNotVisible, "source set", "source sets:") + ' ' + CollectionsKt.joinToString$default((Iterable)this.requiredButNotVisible, null, null, null, (int)0, null, (Function1)message.1.1.INSTANCE, (int)31, null) + ". This requirement was not satisfied.\n\n");
        $this$_get_message__u24lambda_u2d5.append(this.sourceSet.getName() + " takes part in the " + UnsatisfiedSourceSetVisibilityException._get_message_$lambda-5$singularOrPlural$default(this.compilations, "compilation", null, 4, null) + ":\n");
        Iterable $this$forEach$iv = this.compilations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinCompilation it = (KotlinCompilation)element$iv;
            boolean bl2 = false;
            UnsatisfiedSourceSetVisibilityException._get_message_$lambda-5$appendCompilationRecursively($this$_get_message__u24lambda_u2d5, this, it, 0);
            $this$_get_message__u24lambda_u2d5.append("\n");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final String _get_message_$lambda-5$singularOrPlural(Collection<?> collection, String singular, String plural) {
        return collection.size() == 1 ? singular : plural;
    }

    static /* synthetic */ String _get_message_$lambda-5$singularOrPlural$default(Collection collection, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = string + 's';
        }
        return UnsatisfiedSourceSetVisibilityException._get_message_$lambda-5$singularOrPlural(collection, string, string2);
    }

    private static final String _get_message_$lambda-5$compilationWithTarget(KotlinCompilation<?> compilation2) {
        return compilation2.getName() + " (target " + compilation2.getTarget().getName() + ')';
    }

    /*
     * WARNING - void declaration
     */
    private static final void _get_message_$lambda-5$appendCompilationRecursively(StringBuilder $this_buildString, UnsatisfiedSourceSetVisibilityException this$0, KotlinCompilation<?> compilation2, int depth) {
        String string;
        boolean isAssociatedCompilation = depth > 0;
        Map<KotlinCompilation<?>, Set<KotlinSourceSet>> sourceSetsInAssociatedCompilations = SourceSetsVisibilityInferenceKt.getSourceSetsFromAssociatedCompilations(compilation2);
        Set<KotlinSourceSet> allKotlinSourceSets = compilation2.getAllKotlinSourceSets();
        String indent = StringsKt.repeat((CharSequence)"  ", (int)(depth + 1));
        if (isAssociatedCompilation) {
            String string2;
            String string3 = string2 = "indirectly ";
            StringBuilder stringBuilder = new StringBuilder().append(indent).append("- ");
            boolean bl = false;
            boolean bl2 = depth > 1;
            string2 = bl2 ? string2 : null;
            String string4 = string2;
            if (string4 == null) {
                string4 = "";
            }
            string = stringBuilder.append(string4).append("associated with").toString();
        } else {
            string = indent + '-';
        }
        String prefix = string;
        $this_buildString.append(prefix + ' ' + UnsatisfiedSourceSetVisibilityException._get_message_$lambda-5$compilationWithTarget(compilation2));
        $this_buildString.append(isAssociatedCompilation ? ", which compiles " + UnsatisfiedSourceSetVisibilityException._get_message_$lambda-5$singularOrPlural((Collection)allKotlinSourceSets, "source set ", "source sets: ") + CollectionsKt.joinToString$default((Iterable)allKotlinSourceSets, null, null, null, (int)0, null, (Function1)message.1.appendCompilationRecursively.1.INSTANCE, (int)31, null) + '\n' : "\n");
        Iterable $this$forEach$iv = compilation2.getAssociateWith();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinCompilation it = (KotlinCompilation)element$iv;
            boolean bl = false;
            UnsatisfiedSourceSetVisibilityException._get_message_$lambda-5$appendCompilationRecursively($this_buildString, this$0, it, depth + 1);
        }
        if (!isAssociatedCompilation) {
            void $this$filterTo$iv$iv;
            Object element$iv;
            Iterable $this$filter$iv = this$0.requiredButNotVisible;
            boolean $i$f$filter = false;
            element$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block11: {
                    KotlinSourceSet missingSourceSet = (KotlinSourceSet)element$iv$iv;
                    boolean bl3 = false;
                    Iterable $this$none$iv = sourceSetsInAssociatedCompilations.values();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$none$iv) {
                            Set it = (Set)element$iv2;
                            boolean bl4 = false;
                            if (!it.contains(missingSourceSet)) continue;
                            bl = false;
                            break block11;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List missingRequiredSourceSets = (List)destination$iv$iv;
            if (missingRequiredSourceSets.isEmpty()) {
                $this_buildString.append(indent + "The compilation " + UnsatisfiedSourceSetVisibilityException._get_message_$lambda-5$compilationWithTarget(compilation2) + " requires no changes.\n");
            } else {
                $this_buildString.append(indent + "To ensure the required visibility, the compilation " + UnsatisfiedSourceSetVisibilityException._get_message_$lambda-5$compilationWithTarget(compilation2) + " must have a direct or indirect associate that compiles the source " + UnsatisfiedSourceSetVisibilityException._get_message_$lambda-5$singularOrPlural(missingRequiredSourceSets, "set ", "sets: ") + CollectionsKt.joinToString$default((Iterable)missingRequiredSourceSets, null, null, null, (int)0, null, (Function1)message.1.appendCompilationRecursively.3.INSTANCE, (int)31, null) + '\n');
            }
        }
    }
}

