/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinNativeBinaryContainer;
import org.jetbrains.kotlin.gradle.plugin.mpp.Framework;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTargetPresetKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBuildType;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.FrameworkCopy;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.XcodeEnvironment;
import org.jetbrains.kotlin.gradle.tasks.FatFrameworkTask;
import org.jetbrains.kotlin.gradle.tasks.TasksProviderKt;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\n*\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000f"}, d2={"namePrefix", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;", "getNamePrefix", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;)Ljava/lang/String;", "appleFrameworkDir", "Ljava/io/File;", "Lorg/gradle/api/Project;", "frameworkSearchDir", "registerAssembleAppleFrameworkTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "framework", "registerEmbedAndSignAppleFrameworkTask", "", "kotlin-gradle-plugin_common"})
public final class AppleXcodeTasksKt {
    /*
     * WARNING - void declaration
     */
    private static final TaskProvider<? extends Task> registerAssembleAppleFrameworkTask(Project $this$registerAssembleAppleFrameworkTask, Framework framework2) {
        TaskProvider taskProvider;
        if (!framework2.getKonanTarget$kotlin_gradle_plugin_common().getFamily().isAppleFamily() || !KotlinNativeTargetPresetKt.getEnabledOnCurrentHost(framework2.getKonanTarget$kotlin_gradle_plugin_common())) {
            return null;
        }
        List<KonanTarget> envTargets = XcodeEnvironment.INSTANCE.getTargets();
        boolean needFatFramework = envTargets.size() > 1;
        NativeBuildType frameworkBuildType = framework2.getBuildType();
        KotlinNativeTarget frameworkTarget = framework2.getTarget();
        boolean isRequestedFramework = envTargets.contains(frameworkTarget.getKonanTarget());
        String[] stringArray = new String[]{"assemble", AppleXcodeTasksKt.getNamePrefix(framework2), frameworkBuildType.getName(), "AppleFrameworkForXcode", isRequestedFramework && needFatFramework ? null : frameworkTarget.getName()};
        String frameworkTaskName = StringUtilsKt.lowerCamelCaseName(stringArray);
        NativeBuildType envBuildType = XcodeEnvironment.INSTANCE.getBuildType();
        File envFrameworkSearchDir = XcodeEnvironment.INSTANCE.getFrameworkSearchDir();
        if (envBuildType == null || envTargets.isEmpty() || envFrameworkSearchDir == null) {
            String envConfiguration = System.getenv("CONFIGURATION");
            if (!((Collection)envTargets).isEmpty() && envConfiguration != null) {
                $this$registerAssembleAppleFrameworkTask.getLogger().warn("Unable to detect Kotlin framework build type for CONFIGURATION=" + envConfiguration + " automatically. Specify 'KOTLIN_FRAMEWORK_BUILD_TYPE' to 'debug' or 'release'");
            } else {
                $this$registerAssembleAppleFrameworkTask.getLogger().debug("Not registering " + frameworkTaskName + ", since not called from Xcode");
            }
            return null;
        }
        if (!isRequestedFramework) {
            TaskProvider taskProvider2;
            void $this$locateOrRegisterTask$iv;
            Project envConfiguration = $this$registerAssembleAppleFrameworkTask;
            Function1 body$iv = (Function1)new Function1<DefaultTask, Unit>(frameworkBuildType, frameworkTarget){
                final /* synthetic */ NativeBuildType $frameworkBuildType;
                final /* synthetic */ KotlinNativeTarget $frameworkTarget;
                {
                    this.$frameworkBuildType = $frameworkBuildType;
                    this.$frameworkTarget = $frameworkTarget;
                    super(1);
                }

                public final void invoke(@NotNull DefaultTask task2) {
                    Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
                    task2.setDescription("Packs " + (Object)((Object)this.$frameworkBuildType) + ' ' + this.$frameworkTarget.getName() + " framework for Xcode");
                    task2.setEnabled(false);
                }
            };
            boolean $i$f$locateOrRegisterTask = false;
            Project project = $this$locateOrRegisterTask$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            Project $this$locateTask$iv$iv = project;
            boolean $i$f$locateTask = false;
            try {
                taskProvider2 = $this$locateTask$iv$iv.getTasks().withType(DefaultTask.class).named(frameworkTaskName);
            }
            catch (UnknownTaskException e$iv$iv) {
                taskProvider2 = null;
            }
            TaskProvider taskProvider3 = taskProvider2;
            taskProvider = taskProvider3;
            if (taskProvider3 == null) {
                Project project2 = $this$locateOrRegisterTask$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                taskProvider = TasksProviderKt.registerTask$default(project2, frameworkTaskName, DefaultTask.class, null, body$iv, 4, null);
            }
        } else if (needFatFramework) {
            TaskProvider taskProvider4;
            Project $this$locateOrRegisterTask$iv = $this$registerAssembleAppleFrameworkTask;
            Function1 body$iv = (Function1)new Function1<FatFrameworkTask, Unit>(frameworkBuildType, framework2, $this$registerAssembleAppleFrameworkTask, envFrameworkSearchDir, envBuildType){
                final /* synthetic */ NativeBuildType $frameworkBuildType;
                final /* synthetic */ Framework $framework;
                final /* synthetic */ Project $this_registerAssembleAppleFrameworkTask;
                final /* synthetic */ File $envFrameworkSearchDir;
                final /* synthetic */ NativeBuildType $envBuildType;
                {
                    this.$frameworkBuildType = $frameworkBuildType;
                    this.$framework = $framework;
                    this.$this_registerAssembleAppleFrameworkTask = $receiver;
                    this.$envFrameworkSearchDir = $envFrameworkSearchDir;
                    this.$envBuildType = $envBuildType;
                    super(1);
                }

                public final void invoke(@NotNull FatFrameworkTask task2) {
                    Intrinsics.checkNotNullParameter((Object)((Object)task2), (String)"task");
                    task2.setDescription("Packs " + (Object)((Object)this.$frameworkBuildType) + " fat framework for Xcode");
                    task2.setBaseName(this.$framework.getBaseName());
                    task2.setDestinationDir(AppleXcodeTasksKt.access$appleFrameworkDir(this.$this_registerAssembleAppleFrameworkTask, this.$envFrameworkSearchDir));
                    task2.setEnabled(this.$frameworkBuildType == this.$envBuildType);
                }
            };
            boolean $i$f$locateOrRegisterTask = false;
            Project project = $this$locateOrRegisterTask$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            Project $this$locateTask$iv$iv = project;
            boolean $i$f$locateTask = false;
            try {
                taskProvider4 = $this$locateTask$iv$iv.getTasks().withType(FatFrameworkTask.class).named(frameworkTaskName);
            }
            catch (UnknownTaskException e$iv$iv) {
                taskProvider4 = null;
            }
            TaskProvider taskProvider5 = taskProvider4;
            TaskProvider taskProvider6 = taskProvider5;
            if (taskProvider5 == null) {
                Project project3 = $this$locateOrRegisterTask$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
                taskProvider6 = TasksProviderKt.registerTask$default(project3, frameworkTaskName, FatFrameworkTask.class, null, body$iv, 4, null);
            }
            Project it = $this$locateOrRegisterTask$iv = taskProvider6;
            boolean bl = false;
            $this$locateTask$iv$iv = (Function1)new Function1<FatFrameworkTask, Unit>(framework2){
                final /* synthetic */ Framework $framework;
                {
                    this.$framework = $framework;
                    super(1);
                }

                public final void invoke(FatFrameworkTask task2) {
                    Framework[] frameworkArray = new Framework[]{this.$framework};
                    task2.from(frameworkArray);
                }
            };
            it.configure(new Action((Function1)$this$locateTask$iv$iv){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void execute(Object p0) {
                    this.function.invoke(p0);
                }
            });
            taskProvider = $this$locateOrRegisterTask$iv;
        } else {
            void $this$registerTask_u24default$iv;
            Project $this$locateOrRegisterTask$iv = $this$registerAssembleAppleFrameworkTask;
            Function1 body$iv = (Function1)new Function1<FrameworkCopy, Unit>(frameworkBuildType, frameworkTarget, envBuildType, framework2, $this$registerAssembleAppleFrameworkTask, envFrameworkSearchDir){
                final /* synthetic */ NativeBuildType $frameworkBuildType;
                final /* synthetic */ KotlinNativeTarget $frameworkTarget;
                final /* synthetic */ NativeBuildType $envBuildType;
                final /* synthetic */ Framework $framework;
                final /* synthetic */ Project $this_registerAssembleAppleFrameworkTask;
                final /* synthetic */ File $envFrameworkSearchDir;
                {
                    this.$frameworkBuildType = $frameworkBuildType;
                    this.$frameworkTarget = $frameworkTarget;
                    this.$envBuildType = $envBuildType;
                    this.$framework = $framework;
                    this.$this_registerAssembleAppleFrameworkTask = $receiver;
                    this.$envFrameworkSearchDir = $envFrameworkSearchDir;
                    super(1);
                }

                public final void invoke(@NotNull FrameworkCopy task2) {
                    Intrinsics.checkNotNullParameter((Object)((Object)task2), (String)"task");
                    task2.setDescription("Packs " + (Object)((Object)this.$frameworkBuildType) + ' ' + this.$frameworkTarget.getName() + " framework for Xcode");
                    task2.setEnabled(this.$frameworkBuildType == this.$envBuildType);
                    Object[] objectArray = new Object[]{this.$framework.getLinkTaskName()};
                    task2.dependsOn(objectArray);
                    Object[] objectArray2 = new Object[]{new Function0<File[]>(this.$framework){
                        final /* synthetic */ Framework $framework;
                        {
                            this.$framework = $framework;
                            super(0);
                        }

                        public final File[] invoke() {
                            return this.$framework.getOutputDirectory().listFiles();
                        }
                    }};
                    ConfigurableFileCollection configurableFileCollection = this.$this_registerAssembleAppleFrameworkTask.files(objectArray2);
                    Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"framework: Framework): T\u2026tDirectory.listFiles() })");
                    task2.setFiles((FileCollection)configurableFileCollection);
                    task2.setDestDir(AppleXcodeTasksKt.access$appleFrameworkDir(this.$this_registerAssembleAppleFrameworkTask, this.$envFrameworkSearchDir));
                }
            };
            List args$iv = CollectionsKt.emptyList();
            boolean $i$f$registerTask = false;
            taskProvider = TasksProviderKt.registerTask((Project)$this$registerTask_u24default$iv, frameworkTaskName, FrameworkCopy.class, args$iv, body$iv);
        }
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    public static final void registerEmbedAndSignAppleFrameworkTask(@NotNull Project $this$registerEmbedAndSignAppleFrameworkTask, @NotNull Framework framework2) {
        TaskProvider taskProvider;
        void $this$locateOrRegisterTask$iv;
        Intrinsics.checkNotNullParameter((Object)$this$registerEmbedAndSignAppleFrameworkTask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)framework2, (String)"framework");
        NativeBuildType envBuildType = XcodeEnvironment.INSTANCE.getBuildType();
        List<KonanTarget> envTargets = XcodeEnvironment.INSTANCE.getTargets();
        File envEmbeddedFrameworksDir = XcodeEnvironment.INSTANCE.getEmbeddedFrameworksDir();
        File envFrameworkSearchDir = XcodeEnvironment.INSTANCE.getFrameworkSearchDir();
        String envSign = XcodeEnvironment.INSTANCE.getSign();
        String[] stringArray = new String[]{"embedAndSign", AppleXcodeTasksKt.getNamePrefix(framework2), "AppleFrameworkForXcode"};
        String frameworkTaskName = StringUtilsKt.lowerCamelCaseName(stringArray);
        if (envBuildType == null || envTargets.isEmpty() || envEmbeddedFrameworksDir == null || envFrameworkSearchDir == null) {
            TaskProvider taskProvider2;
            void $this$locateOrRegisterTask$iv2;
            stringArray = $this$registerEmbedAndSignAppleFrameworkTask;
            Function1 body$iv = (Function1)new Function1<DefaultTask, Unit>(framework2, envBuildType, frameworkTaskName){
                final /* synthetic */ Framework $framework;
                final /* synthetic */ NativeBuildType $envBuildType;
                final /* synthetic */ String $frameworkTaskName;
                {
                    this.$framework = $framework;
                    this.$envBuildType = $envBuildType;
                    this.$frameworkTaskName = $frameworkTaskName;
                    super(1);
                }

                public final void invoke(@NotNull DefaultTask task2) {
                    Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
                    task2.setGroup("build");
                    task2.setDescription("Embed and sign " + AppleXcodeTasksKt.access$getNamePrefix(this.$framework) + " framework as requested by Xcode's environment variables");
                    Function1 function1 = (Function1)new Function1<Task, Unit>(this.$envBuildType, this.$frameworkTaskName){
                        final /* synthetic */ NativeBuildType $envBuildType;
                        final /* synthetic */ String $frameworkTaskName;
                        {
                            this.$envBuildType = $envBuildType;
                            this.$frameworkTaskName = $frameworkTaskName;
                            super(1);
                        }

                        public final void invoke(Task it) {
                            String envConfiguration = System.getenv("CONFIGURATION");
                            if (envConfiguration != null && this.$envBuildType == null) {
                                throw new IllegalStateException("Unable to detect Kotlin framework build type for CONFIGURATION=" + envConfiguration + " automatically. Specify 'KOTLIN_FRAMEWORK_BUILD_TYPE' to 'debug' or 'release'\n" + XcodeEnvironment.INSTANCE);
                            }
                            throw new IllegalStateException("Please run the " + this.$frameworkTaskName + " task from Xcode ('SDK_NAME', 'CONFIGURATION', 'TARGET_BUILD_DIR', 'ARCHS' and 'FRAMEWORKS_FOLDER_PATH' not provided)\n" + XcodeEnvironment.INSTANCE);
                        }
                    };
                    task2.doFirst(new /* invalid duplicate definition of identical inner class */);
                }
            };
            boolean $i$f$locateOrRegisterTask = false;
            Project project = $this$locateOrRegisterTask$iv2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            Project $this$locateTask$iv$iv = project;
            boolean $i$f$locateTask = false;
            try {
                taskProvider2 = $this$locateTask$iv$iv.getTasks().withType(DefaultTask.class).named(frameworkTaskName);
            }
            catch (UnknownTaskException e$iv$iv) {
                taskProvider2 = null;
            }
            TaskProvider taskProvider3 = taskProvider2;
            TaskProvider taskProvider4 = taskProvider3;
            if (taskProvider3 == null) {
                Project project2 = $this$locateOrRegisterTask$iv2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                taskProvider4 = TasksProviderKt.registerTask$default(project2, frameworkTaskName, DefaultTask.class, null, body$iv, 4, null);
            }
            return;
        }
        String[] body$iv = $this$registerEmbedAndSignAppleFrameworkTask;
        Function1 body$iv2 = (Function1)new Function1<FrameworkCopy, Unit>(framework2, envBuildType, envTargets, envEmbeddedFrameworksDir, envSign){
            final /* synthetic */ Framework $framework;
            final /* synthetic */ NativeBuildType $envBuildType;
            final /* synthetic */ List<KonanTarget> $envTargets;
            final /* synthetic */ File $envEmbeddedFrameworksDir;
            final /* synthetic */ String $envSign;
            {
                this.$framework = $framework;
                this.$envBuildType = $envBuildType;
                this.$envTargets = $envTargets;
                this.$envEmbeddedFrameworksDir = $envEmbeddedFrameworksDir;
                this.$envSign = $envSign;
                super(1);
            }

            public final void invoke(@NotNull FrameworkCopy task2) {
                Intrinsics.checkNotNullParameter((Object)((Object)task2), (String)"task");
                task2.setGroup("build");
                task2.setDescription("Embed and sign " + AppleXcodeTasksKt.access$getNamePrefix(this.$framework) + " framework as requested by Xcode's environment variables");
                task2.setEnabled(!this.$framework.isStatic());
                TaskInputsInternal taskInputsInternal = task2.getInputs();
                NativeBuildType nativeBuildType = this.$envBuildType;
                List<KonanTarget> list2 = this.$envTargets;
                File file = this.$envEmbeddedFrameworksDir;
                String string = this.$envSign;
                TaskInputsInternal $this$invoke_u24lambda_u240 = taskInputsInternal;
                boolean bl = false;
                $this$invoke_u24lambda_u240.property("type", (Object)((Object)nativeBuildType));
                $this$invoke_u24lambda_u240.property("targets", list2);
                $this$invoke_u24lambda_u240.property("embeddedFrameworksDir", (Object)file);
                $this$invoke_u24lambda_u240.property("sign", (Object)string);
            }
        };
        boolean $i$f$locateOrRegisterTask = false;
        Project project = $this$locateOrRegisterTask$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Project $this$locateTask$iv$iv = project;
        boolean $i$f$locateTask = false;
        try {
            taskProvider = $this$locateTask$iv$iv.getTasks().withType(FrameworkCopy.class).named(frameworkTaskName);
        }
        catch (UnknownTaskException e$iv$iv) {
            taskProvider = null;
        }
        TaskProvider taskProvider5 = taskProvider;
        TaskProvider taskProvider6 = taskProvider5;
        if (taskProvider5 == null) {
            Project project3 = $this$locateOrRegisterTask$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            taskProvider6 = TasksProviderKt.registerTask$default(project3, frameworkTaskName, FrameworkCopy.class, null, body$iv2, 4, null);
        }
        TaskProvider embedAndSignTask2 = taskProvider6;
        TaskProvider<? extends Task> taskProvider7 = AppleXcodeTasksKt.registerAssembleAppleFrameworkTask((Project)$this$registerEmbedAndSignAppleFrameworkTask, framework2);
        if (taskProvider7 == null) {
            return;
        }
        TaskProvider<? extends Task> assembleTask = taskProvider7;
        if (framework2.getBuildType() != envBuildType || !envTargets.contains(framework2.getKonanTarget$kotlin_gradle_plugin_common())) {
            return;
        }
        Function1 function1 = (Function1)new Function1<FrameworkCopy, Unit>(assembleTask, (Project)$this$registerEmbedAndSignAppleFrameworkTask, envFrameworkSearchDir, framework2, envEmbeddedFrameworksDir, envSign){
            final /* synthetic */ TaskProvider<? extends Task> $assembleTask;
            final /* synthetic */ Project $this_registerEmbedAndSignAppleFrameworkTask;
            final /* synthetic */ File $envFrameworkSearchDir;
            final /* synthetic */ Framework $framework;
            final /* synthetic */ File $envEmbeddedFrameworksDir;
            final /* synthetic */ String $envSign;
            {
                this.$assembleTask = $assembleTask;
                this.$this_registerEmbedAndSignAppleFrameworkTask = $receiver;
                this.$envFrameworkSearchDir = $envFrameworkSearchDir;
                this.$framework = $framework;
                this.$envEmbeddedFrameworksDir = $envEmbeddedFrameworksDir;
                this.$envSign = $envSign;
                super(1);
            }

            public final void invoke(FrameworkCopy task2) {
                Object[] objectArray = new Object[]{this.$assembleTask};
                task2.dependsOn(objectArray);
                Object[] objectArray2 = new Object[]{new File(AppleXcodeTasksKt.access$appleFrameworkDir(this.$this_registerEmbedAndSignAppleFrameworkTask, this.$envFrameworkSearchDir), this.$framework.getOutputFile().getName())};
                ConfigurableFileCollection configurableFileCollection = this.$this_registerEmbedAndSignAppleFrameworkTask.files(objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"files(File(appleFramewor\u2026amework.outputFile.name))");
                task2.setFiles((FileCollection)configurableFileCollection);
                task2.setDestDir(this.$envEmbeddedFrameworksDir);
                if (this.$envSign != null) {
                    objectArray = (Object[])new Function1<Task, Unit>(this.$envEmbeddedFrameworksDir, this.$framework, this.$this_registerEmbedAndSignAppleFrameworkTask, this.$envSign){
                        final /* synthetic */ File $envEmbeddedFrameworksDir;
                        final /* synthetic */ Framework $framework;
                        final /* synthetic */ Project $this_registerEmbedAndSignAppleFrameworkTask;
                        final /* synthetic */ String $envSign;
                        {
                            this.$envEmbeddedFrameworksDir = $envEmbeddedFrameworksDir;
                            this.$framework = $framework;
                            this.$this_registerEmbedAndSignAppleFrameworkTask = $receiver;
                            this.$envSign = $envSign;
                            super(1);
                        }

                        public final void invoke(Task it) {
                            String string = this.$framework.getOutputFile().getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"framework.outputFile.name");
                            File binary = FilesKt.resolve((File)FilesKt.resolve((File)this.$envEmbeddedFrameworksDir, (String)string), (String)FilesKt.getNameWithoutExtension((File)this.$framework.getOutputFile()));
                            Function1 function1 = (Function1)new Function1<ExecSpec, Unit>(this.$envSign, binary){
                                final /* synthetic */ String $envSign;
                                final /* synthetic */ File $binary;
                                {
                                    this.$envSign = $envSign;
                                    this.$binary = $binary;
                                    super(1);
                                }

                                public final void invoke(ExecSpec it) {
                                    Object[] objectArray = new Object[]{"codesign", "--force", "--sign", this.$envSign, "--", this.$binary};
                                    it.commandLine(objectArray);
                                }
                            };
                            this.$this_registerEmbedAndSignAppleFrameworkTask.exec(new /* invalid duplicate definition of identical inner class */);
                        }
                    };
                    task2.doLast(new /* invalid duplicate definition of identical inner class */);
                }
            }
        };
        embedAndSignTask2.configure(new /* invalid duplicate definition of identical inner class */);
    }

    private static final String getNamePrefix(Framework $this$namePrefix) {
        return KotlinNativeBinaryContainer.Companion.extractPrefixFromBinaryName$kotlin_gradle_plugin_common($this$namePrefix.getName(), $this$namePrefix.getBuildType(), $this$namePrefix.getOutputKind().getTaskNameClassifier());
    }

    private static final File appleFrameworkDir(Project $this$appleFrameworkDir, File frameworkSearchDir) {
        File file = $this$appleFrameworkDir.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"buildDir");
        return FilesKt.resolve((File)FilesKt.resolve((File)file, (String)"xcode-frameworks"), (File)frameworkSearchDir);
    }

    public static final /* synthetic */ File access$appleFrameworkDir(Project $receiver, File frameworkSearchDir) {
        return AppleXcodeTasksKt.appleFrameworkDir($receiver, frameworkSearchDir);
    }

    public static final /* synthetic */ String access$getNamePrefix(Framework $receiver) {
        return AppleXcodeTasksKt.getNamePrefix($receiver);
    }
}

