/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources.android.configurator;

import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.api.BaseVariant;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.sources.KotlinSourceSetFactory;
import org.jetbrains.kotlin.gradle.plugin.sources.android.configurator.KotlinAndroidSourceSetConfigurator;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/configurator/MultiplatformAndroidResourceDirConfigurator;", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/configurator/KotlinAndroidSourceSetConfigurator;", "()V", "configure", "", "target", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "kotlinSourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "androidSourceSet", "Lcom/android/build/gradle/api/AndroidSourceSet;", "kotlin-gradle-plugin_common"})
public final class MultiplatformAndroidResourceDirConfigurator
implements KotlinAndroidSourceSetConfigurator {
    @NotNull
    public static final MultiplatformAndroidResourceDirConfigurator INSTANCE = new MultiplatformAndroidResourceDirConfigurator();

    private MultiplatformAndroidResourceDirConfigurator() {
    }

    @Override
    public void configure(@NotNull KotlinAndroidTarget target2, @NotNull KotlinSourceSet kotlinSourceSet, @NotNull AndroidSourceSet androidSourceSet) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)kotlinSourceSet, (String)"kotlinSourceSet");
        Intrinsics.checkNotNullParameter((Object)androidSourceSet, (String)"androidSourceSet");
        if (Intrinsics.areEqual((Object)kotlinSourceSet.getName(), (Object)androidSourceSet.getName())) {
            return;
        }
        Project project = target2.getProject();
        Object[] objectArray = new Object[]{kotlinSourceSet.getResources().getSrcDirs()};
        androidSourceSet.getResources().srcDirs(objectArray);
        Set set2 = androidSourceSet.getResources().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"androidSourceSet.resources.srcDirs");
        if (!((Collection)set2).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getResources();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "resources"));
            objectArray = new Object[]{androidSourceSet.getResources().getSrcDirs()};
            kotlinSourceSet.getResources().srcDirs(objectArray);
        }
        Set set3 = androidSourceSet.getAssets().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"androidSourceSet.assets.srcDirs");
        if (!((Collection)set3).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getAssets();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "assets"));
        }
        Set set4 = androidSourceSet.getRes().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"androidSourceSet.res.srcDirs");
        if (!((Collection)set4).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getRes();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "res"));
        }
        Set set5 = androidSourceSet.getAidl().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set5, (String)"androidSourceSet.aidl.srcDirs");
        if (!((Collection)set5).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getAidl();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "aidl"));
        }
        Set set6 = androidSourceSet.getRenderscript().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set6, (String)"androidSourceSet.renderscript.srcDirs");
        if (!((Collection)set6).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getRenderscript();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "rs"));
        }
        Set set7 = androidSourceSet.getJni().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set7, (String)"androidSourceSet.jni.srcDirs");
        if (!((Collection)set7).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getJni();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "jni"));
        }
        Set set8 = androidSourceSet.getJniLibs().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set8, (String)"androidSourceSet.jniLibs.srcDirs");
        if (!((Collection)set8).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getJniLibs();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "jniLibs"));
        }
        Set set9 = androidSourceSet.getShaders().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set9, (String)"androidSourceSet.shaders.srcDirs");
        if (!((Collection)set9).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getShaders();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "shaders"));
        }
    }

    @Override
    public void configureWithVariant(@NotNull KotlinAndroidTarget target2, @NotNull KotlinSourceSet kotlinSourceSet, @NotNull BaseVariant variant) {
        KotlinAndroidSourceSetConfigurator.DefaultImpls.configureWithVariant(this, target2, kotlinSourceSet, variant);
    }
}

