/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.ContinuationKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginLifecycle;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginLifecycleCoroutineContextElement;
import org.jetbrains.kotlin.gradle.utils.CompletableFuture;
import org.jetbrains.kotlin.gradle.utils.FailuresKt;
import org.jetbrains.kotlin.gradle.utils.FutureKt;
import org.jetbrains.kotlin.gradle.utils.WhenEvaluatedKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010!\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\"J'\u0010#\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\f2\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\b\u0010J\b\u0010%\u001a\u00020\u000fH\u0002J\b\u0010&\u001a\u00020\u000fH\u0002J\u0016\u0010'\u001a\u00020\u000f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J>\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-2'\u0010.\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f00\u0012\u0006\u0012\u0004\u0018\u0001010/\u00a2\u0006\u0002\b\u0010H\u0016\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u00020\u000fH\u0002J\u0006\u0010,\u001a\u00020\u000fJ\b\u00104\u001a\u000205H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR1\u0010\n\u001a%\u0012\u0004\u0012\u00020\f\u0012\u001b\u0012\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\b\u00100\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinPluginLifecycleImpl;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinPluginLifecycle;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "configurationResult", "Lorg/jetbrains/kotlin/gradle/utils/CompletableFuture;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinPluginLifecycle$ProjectConfigurationResult;", "getConfigurationResult", "()Lorg/jetbrains/kotlin/gradle/utils/CompletableFuture;", "enqueuedActions", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinPluginLifecycle$Stage;", "Lkotlin/collections/ArrayDeque;", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "isFinished", "", "()Z", "isFinishedSuccessfully", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isFinishedWithFailures", "isStarted", "isStartedImpl", "loopRunning", "getProject", "()Lorg/gradle/api/Project;", "stage", "getStage", "()Lorg/jetbrains/kotlin/gradle/plugin/KotlinPluginLifecycle$Stage;", "setStage", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinPluginLifecycle$Stage;)V", "await", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinPluginLifecycle$Stage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "enqueue", "action", "executeCurrentStageAndScheduleNext", "finishSuccessfully", "finishWithFailures", "failures", "", "", "launch", "start", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinPluginLifecycle$CoroutineStart;", "block", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinPluginLifecycle$CoroutineStart;Lkotlin/jvm/functions/Function2;)V", "loopIfNecessary", "toString", "", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nKotlinPluginLifecycleImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPluginLifecycleImpl.kt\norg/jetbrains/kotlin/gradle/plugin/KotlinPluginLifecycleImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,202:1\n9226#2,2:203\n9376#2,4:205\n*S KotlinDebug\n*F\n+ 1 KotlinPluginLifecycleImpl.kt\norg/jetbrains/kotlin/gradle/plugin/KotlinPluginLifecycleImpl\n*L\n27#1:203,2\n27#1:205,4\n*E\n"})
public final class KotlinPluginLifecycleImpl
implements KotlinPluginLifecycle {
    @NotNull
    private final Project project;
    @NotNull
    private final CompletableFuture<KotlinPluginLifecycle.ProjectConfigurationResult> configurationResult;
    @NotNull
    private final Map<KotlinPluginLifecycle.Stage, ArrayDeque<Function1<KotlinPluginLifecycle, Unit>>> enqueuedActions;
    @NotNull
    private final AtomicBoolean loopRunning;
    @NotNull
    private final AtomicBoolean isStartedImpl;
    @NotNull
    private final AtomicBoolean isFinishedSuccessfully;
    @NotNull
    private final AtomicBoolean isFinishedWithFailures;
    @NotNull
    private KotlinPluginLifecycle.Stage stage;

    /*
     * WARNING - void declaration
     */
    public KotlinPluginLifecycleImpl(@NotNull Project project) {
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.configurationResult = FutureKt.CompletableFuture();
        KotlinPluginLifecycle.Stage[] stageArray = KotlinPluginLifecycle.Stage.values();
        KotlinPluginLifecycleImpl kotlinPluginLifecycleImpl = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$this$associateWith$iv).length), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        int n = ((void)$this$associateWithTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void var10_11 = element$iv$iv = $this$associateWithTo$iv$iv[j];
            void var14_14 = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            ArrayDeque arrayDeque = new ArrayDeque();
            map2.put(var14_14, arrayDeque);
        }
        kotlinPluginLifecycleImpl.enqueuedActions = result$iv;
        this.loopRunning = new AtomicBoolean(false);
        this.isStartedImpl = new AtomicBoolean(false);
        this.isFinishedSuccessfully = new AtomicBoolean(false);
        this.isFinishedWithFailures = new AtomicBoolean(false);
        this.stage = (KotlinPluginLifecycle.Stage)((Object)CollectionsKt.first(KotlinPluginLifecycle.Stage.Companion.getValues()));
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final CompletableFuture<KotlinPluginLifecycle.ProjectConfigurationResult> getConfigurationResult() {
        return this.configurationResult;
    }

    @Override
    @NotNull
    public KotlinPluginLifecycle.Stage getStage() {
        return this.stage;
    }

    public void setStage(@NotNull KotlinPluginLifecycle.Stage stage) {
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"<set-?>");
        this.stage = stage;
    }

    @Override
    public boolean isStarted() {
        return this.isStartedImpl.get();
    }

    @Override
    public boolean isFinished() {
        return this.isFinishedSuccessfully.get() || this.isFinishedWithFailures.get();
    }

    public final void start() {
        if (!(!this.isStartedImpl.getAndSet(true))) {
            boolean $i$a$-check-KotlinPluginLifecycleImpl$start$32 = false;
            String $i$a$-check-KotlinPluginLifecycleImpl$start$32 = KotlinPluginLifecycle.class.getName() + " already started";
            throw new IllegalStateException($i$a$-check-KotlinPluginLifecycleImpl$start$32.toString());
        }
        if (!(!this.getProject().getState().getExecuted())) {
            boolean bl = false;
            String string = KotlinPluginLifecycle.class.getName() + " cannot be started in ProjectState '" + this.getProject().getState() + '\'';
            throw new IllegalStateException(string.toString());
        }
        this.loopIfNecessary();
        WhenEvaluatedKt.whenEvaluated(this.getProject(), (Function1)new Function1<Project, Unit>(this){
            final /* synthetic */ KotlinPluginLifecycleImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Project $this$whenEvaluated) {
                Intrinsics.checkNotNullParameter((Object)$this$whenEvaluated, (String)"$this$whenEvaluated");
                Project project = $this$whenEvaluated.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                List<Throwable> list = FailuresKt.getFailures(project);
                KotlinPluginLifecycleImpl kotlinPluginLifecycleImpl = this.this$0;
                List<Throwable> failures = list;
                boolean bl = false;
                if (!((Collection)failures).isEmpty()) {
                    KotlinPluginLifecycleImpl.access$finishWithFailures(kotlinPluginLifecycleImpl, failures);
                    return;
                }
                boolean bl2 = ((ArrayDeque)MapsKt.getValue((Map)KotlinPluginLifecycleImpl.access$getEnqueuedActions$p(this.this$0), (Object)((Object)this.this$0.getStage()))).isEmpty();
                kotlinPluginLifecycleImpl = this.this$0;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl3 = false;
                    String string = "Expected empty queue from '" + (Object)((Object)kotlinPluginLifecycleImpl.getStage()) + '\'';
                    throw new AssertionError((Object)string);
                }
                this.this$0.setStage(this.this$0.getStage().getNextOrThrow());
                KotlinPluginLifecycleImpl.access$executeCurrentStageAndScheduleNext(this.this$0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void executeCurrentStageAndScheduleNext() {
        List<Throwable> failures;
        KotlinPluginLifecycle.Stage stage = this.getStage().getPreviousOrNull();
        if (stage != null) {
            KotlinPluginLifecycle.Stage previousStage = stage;
            boolean bl = false;
            boolean bl2 = ((ArrayDeque)MapsKt.getValue(this.enqueuedActions, (Object)((Object)previousStage))).isEmpty();
            if (_Assertions.ENABLED && !bl2) {
                boolean bl3 = false;
                String string = "Actions from previous stage '" + (Object)((Object)previousStage) + "' have not been executed (stage: '" + (Object)((Object)this.getStage()) + "')";
                throw new AssertionError((Object)string);
            }
        }
        if (!((Collection)(failures = FailuresKt.getFailures(this.getProject()))).isEmpty()) {
            this.finishWithFailures(failures);
            return;
        }
        try {
            this.loopIfNecessary();
        }
        catch (Throwable t) {
            this.finishWithFailures(CollectionsKt.listOf((Object)t));
            throw t;
        }
        KotlinPluginLifecycle.Stage stage2 = this.getStage().getNextOrNull();
        if (stage2 == null) {
            void $this$executeCurrentStageAndScheduleNext_u24lambda_u245;
            KotlinPluginLifecycleImpl bl = this;
            boolean bl4 = false;
            super.finishSuccessfully();
            return;
        }
        this.setStage(stage2);
        this.getProject().afterEvaluate(new Action(this){
            final /* synthetic */ KotlinPluginLifecycleImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(Project it) {
                KotlinPluginLifecycleImpl.access$executeCurrentStageAndScheduleNext(this.this$0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loopIfNecessary() {
        if (this.loopRunning.getAndSet(true)) {
            return;
        }
        try {
            Function1 action2;
            ArrayDeque queue = (ArrayDeque)MapsKt.getValue(this.enqueuedActions, (Object)((Object)this.getStage()));
            do {
                this.getProject().getState().rethrowFailure();
                Function1 function1 = action2 = (Function1)queue.removeFirstOrNull();
                if (function1 == null) continue;
                function1.invoke((Object)this);
            } while (action2 != null);
        }
        finally {
            this.loopRunning.set(false);
        }
    }

    private final void finishWithFailures(List<? extends Throwable> failures) {
        boolean bl;
        boolean bl2 = bl = !((Collection)failures).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = this.isStartedImpl.get();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = !this.isFinishedWithFailures.getAndSet(true);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.configurationResult.complete(new KotlinPluginLifecycle.ProjectConfigurationResult.Failure(failures));
    }

    private final void finishSuccessfully() {
        boolean bl = this.isStartedImpl.get();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl2 = bl = !this.isFinishedSuccessfully.getAndSet(true);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.configurationResult.complete(KotlinPluginLifecycle.ProjectConfigurationResult.Success.INSTANCE);
    }

    public final void enqueue(@NotNull KotlinPluginLifecycle.Stage stage, @NotNull Function1<? super KotlinPluginLifecycle, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        if (stage.compareTo((Enum)this.getStage()) < 0) {
            throw new KotlinPluginLifecycle.IllegalLifecycleException("Cannot enqueue Action for stage '" + (Object)((Object)stage) + "' in current stage '" + (Object)((Object)this.getStage()) + '\'');
        }
        if (this.isFinishedSuccessfully.get()) {
            action2.invoke((Object)this);
            return;
        }
        if (this.isFinishedWithFailures.get()) {
            if (stage == this.getStage()) {
                action2.invoke((Object)this);
            }
            return;
        }
        ((ArrayDeque)MapsKt.getValue(this.enqueuedActions, (Object)((Object)stage))).addLast(action2);
        if (stage == KotlinPluginLifecycle.Stage.EvaluateBuildscript && this.isStartedImpl.get()) {
            this.loopIfNecessary();
        }
    }

    @Override
    public void launch(@NotNull KotlinPluginLifecycle.CoroutineStart start2, @NotNull Function2<? super KotlinPluginLifecycle, ? super Continuation<? super Unit>, ? extends Object> block) {
        Intrinsics.checkNotNullParameter((Object)((Object)start2), (String)"start");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        KotlinPluginLifecycleImpl lifecycle = this;
        Continuation coroutine2 = ContinuationKt.createCoroutine(block, (Object)this, (Continuation)((Continuation)new Continuation<Unit>(lifecycle){
            private final CoroutineContext context;
            {
                this.context = EmptyCoroutineContext.INSTANCE.plus((CoroutineContext)new KotlinPluginLifecycleCoroutineContextElement($lifecycle));
            }

            public CoroutineContext getContext() {
                return this.context;
            }

            public void resumeWith(Object result2) {
                Object object = result2;
                ResultKt.throwOnFailure((Object)object);
            }
        }));
        switch (WhenMappings.$EnumSwitchMapping$0[start2.ordinal()]) {
            case 1: {
                this.enqueue(this.getStage(), (Function1<? super KotlinPluginLifecycle, Unit>)((Function1)new Function1<KotlinPluginLifecycle, Unit>((Continuation<? super Unit>)coroutine2){
                    final /* synthetic */ Continuation<Unit> $coroutine;
                    {
                        this.$coroutine = $coroutine;
                        super(1);
                    }

                    public final void invoke(KotlinPluginLifecycle $this$enqueue) {
                        Intrinsics.checkNotNullParameter((Object)$this$enqueue, (String)"$this$enqueue");
                        this.$coroutine.resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
                    }
                }));
                break;
            }
            case 2: {
                coroutine2.resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
            }
        }
    }

    @Override
    @Nullable
    public Object await(@NotNull KotlinPluginLifecycle.Stage stage, @NotNull Continuation<? super Unit> $completion) {
        if (this.getStage().compareTo((Enum)stage) > 0) {
            return Unit.INSTANCE;
        }
        Continuation<? super Unit> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl = false;
        this.enqueue(stage, (Function1<? super KotlinPluginLifecycle, Unit>)((Function1)new Function1<KotlinPluginLifecycle, Unit>((Continuation<? super Unit>)continuation2){
            final /* synthetic */ Continuation<Unit> $continuation;
            {
                this.$continuation = $continuation;
                super(1);
            }

            public final void invoke(KotlinPluginLifecycle $this$enqueue) {
                Intrinsics.checkNotNullParameter((Object)$this$enqueue, (String)"$this$enqueue");
                this.$continuation.resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
            }
        }));
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u247 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u247.append("Kotlin Plugin Lifecycle: (" + this.getProject().getDisplayName() + ')');
        if (!this.isStarted()) {
            $this$toString_u24lambda_u247.append(" *not started*");
        } else {
            $this$toString_u24lambda_u247.append(" stage '" + (Object)((Object)this.getStage()) + '\'');
        }
        if (this.isFinishedSuccessfully.get()) {
            $this$toString_u24lambda_u247.append(" *finished successfully*");
        }
        if (this.isFinishedWithFailures.get()) {
            $this$toString_u24lambda_u247.append(" *finished with failures*");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final /* synthetic */ Map access$getEnqueuedActions$p(KotlinPluginLifecycleImpl $this) {
        return $this.enqueuedActions;
    }

    public static final /* synthetic */ void access$executeCurrentStageAndScheduleNext(KotlinPluginLifecycleImpl $this) {
        $this.executeCurrentStageAndScheduleNext();
    }

    public static final /* synthetic */ void access$finishWithFailures(KotlinPluginLifecycleImpl $this, List failures) {
        $this.finishWithFailures(failures);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinPluginLifecycle.CoroutineStart.values().length];
            try {
                nArray[KotlinPluginLifecycle.CoroutineStart.Default.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinPluginLifecycle.CoroutineStart.Undispatched.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

