/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kotlin.reflect.jvm.internal.impl.di;

import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JavaDescriptorResolver;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializationComponentsForJava;
import kotlin.reflect.jvm.internal.impl.load.java.components.ExternalSignatureResolver;
import kotlin.reflect.jvm.internal.impl.load.java.components.MethodSignatureChecker;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaResolverCache;
import kotlin.reflect.jvm.internal.impl.load.java.components.ExternalAnnotationResolver;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPropertyInitializerEvaluator;
import kotlin.reflect.jvm.internal.impl.load.java.components.SamConversionResolver;
import kotlin.reflect.jvm.internal.impl.load.java.components.RuntimeErrorReporter;
import kotlin.reflect.jvm.internal.impl.load.java.components.RuntimeSourceElementFactory;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.SingleModuleClassResolver;
import kotlin.reflect.jvm.internal.impl.load.java.reflect.ReflectJavaClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.reflect.ReflectKotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaPackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.GlobalJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver;
import kotlin.reflect.jvm.internal.impl.builtins.ReflectionTypes;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JavaClassDataFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.BinaryClassAnnotationAndConstantLoaderImpl;
import org.jetbrains.annotations.NotNull;
import javax.annotation.PreDestroy;

/* This file is generated by kotlin.reflect.jvm.internal.impl.generators.injectors.InjectorsPackage. DO NOT EDIT! */
@SuppressWarnings("all")
public class InjectorForRuntimeDescriptorLoader {

    private final ClassLoader classLoader;
    private final ModuleDescriptor moduleDescriptor;
    private final StorageManager storageManager;
    private final JavaDescriptorResolver javaDescriptorResolver;
    private final DeserializationComponentsForJava deserializationComponentsForJava;
    private final ExternalSignatureResolver externalSignatureResolver;
    private final MethodSignatureChecker methodSignatureChecker;
    private final JavaResolverCache javaResolverCache;
    private final ExternalAnnotationResolver externalAnnotationResolver;
    private final JavaPropertyInitializerEvaluator javaPropertyInitializerEvaluator;
    private final SamConversionResolver samConversionResolver;
    private final RuntimeErrorReporter runtimeErrorReporter;
    private final RuntimeSourceElementFactory runtimeSourceElementFactory;
    private final SingleModuleClassResolver singleModuleClassResolver;
    private final ReflectJavaClassFinder reflectJavaClassFinder;
    private final ReflectKotlinClassFinder reflectKotlinClassFinder;
    private final LazyJavaPackageFragmentProvider lazyJavaPackageFragmentProvider;
    private final GlobalJavaResolverContext globalJavaResolverContext;
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;
    private final ReflectionTypes reflectionTypes;
    private final JavaClassDataFinder javaClassDataFinder;
    private final BinaryClassAnnotationAndConstantLoaderImpl binaryClassAnnotationAndConstantLoader;

    public InjectorForRuntimeDescriptorLoader(
        @NotNull ClassLoader classLoader,
        @NotNull ModuleDescriptor moduleDescriptor,
        @NotNull StorageManager storageManager
    ) {
        this.classLoader = classLoader;
        this.moduleDescriptor = moduleDescriptor;
        this.storageManager = storageManager;
        this.reflectJavaClassFinder = new ReflectJavaClassFinder(classLoader);
        this.reflectKotlinClassFinder = new ReflectKotlinClassFinder(classLoader);
        this.runtimeErrorReporter = RuntimeErrorReporter.INSTANCE$;
        this.deserializedDescriptorResolver = new DeserializedDescriptorResolver(runtimeErrorReporter);
        this.externalAnnotationResolver = ExternalAnnotationResolver.EMPTY;
        this.externalSignatureResolver = ExternalSignatureResolver.DO_NOTHING;
        this.methodSignatureChecker = MethodSignatureChecker.DO_NOTHING;
        this.javaResolverCache = JavaResolverCache.EMPTY;
        this.javaPropertyInitializerEvaluator = JavaPropertyInitializerEvaluator.DO_NOTHING;
        this.samConversionResolver = SamConversionResolver.EMPTY;
        this.runtimeSourceElementFactory = RuntimeSourceElementFactory.INSTANCE$;
        this.singleModuleClassResolver = new SingleModuleClassResolver();
        this.globalJavaResolverContext = new GlobalJavaResolverContext(storageManager, reflectJavaClassFinder, reflectKotlinClassFinder, deserializedDescriptorResolver, externalAnnotationResolver, externalSignatureResolver, runtimeErrorReporter, methodSignatureChecker, javaResolverCache, javaPropertyInitializerEvaluator, samConversionResolver, runtimeSourceElementFactory, singleModuleClassResolver);
        this.reflectionTypes = new ReflectionTypes(getModuleDescriptor());
        this.lazyJavaPackageFragmentProvider = new LazyJavaPackageFragmentProvider(globalJavaResolverContext, getModuleDescriptor(), reflectionTypes);
        this.javaDescriptorResolver = new JavaDescriptorResolver(lazyJavaPackageFragmentProvider, getModuleDescriptor());
        this.javaClassDataFinder = new JavaClassDataFinder(reflectKotlinClassFinder, deserializedDescriptorResolver);
        this.binaryClassAnnotationAndConstantLoader = new BinaryClassAnnotationAndConstantLoaderImpl(getModuleDescriptor(), storageManager, reflectKotlinClassFinder, runtimeErrorReporter);
        this.deserializationComponentsForJava = new DeserializationComponentsForJava(storageManager, getModuleDescriptor(), javaClassDataFinder, binaryClassAnnotationAndConstantLoader, lazyJavaPackageFragmentProvider);

        singleModuleClassResolver.setResolver(javaDescriptorResolver);

        deserializedDescriptorResolver.setComponents(deserializationComponentsForJava);

    }

    @PreDestroy
    public void destroy() {
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    public JavaDescriptorResolver getJavaDescriptorResolver() {
        return this.javaDescriptorResolver;
    }

    public DeserializationComponentsForJava getDeserializationComponentsForJava() {
        return this.deserializationComponentsForJava;
    }

}
