@file:kotlin.jvm.JvmMultifileClass
@file:kotlin.jvm.JvmName("CollectionsKt")

package kotlin.collections

//
// NOTE THIS FILE IS AUTO-GENERATED by the GenerateStandardLib.kt
// See: https://github.com/JetBrains/kotlin/tree/master/libraries/stdlib
//

import kotlin.comparisons.*

/**
 * Returns 1st *element* from the collection.
 */
@kotlin.internal.InlineOnly
public expect inline operator fun <T> List<T>.component1(): T

/**
 * Returns 2nd *element* from the collection.
 */
@kotlin.internal.InlineOnly
public expect inline operator fun <T> List<T>.component2(): T

/**
 * Returns 3rd *element* from the collection.
 */
@kotlin.internal.InlineOnly
public expect inline operator fun <T> List<T>.component3(): T

/**
 * Returns 4th *element* from the collection.
 */
@kotlin.internal.InlineOnly
public expect inline operator fun <T> List<T>.component4(): T

/**
 * Returns 5th *element* from the collection.
 */
@kotlin.internal.InlineOnly
public expect inline operator fun <T> List<T>.component5(): T

/**
 * Returns `true` if [element] is found in the collection.
 */
public expect operator fun <@kotlin.internal.OnlyInputTypes T> Iterable<T>.contains(element: T): Boolean

/**
 * Returns an element at the given [index] or throws an [IndexOutOfBoundsException] if the [index] is out of bounds of this collection.
 */
public expect fun <T> Iterable<T>.elementAt(index: Int): T

/**
 * Returns an element at the given [index] or throws an [IndexOutOfBoundsException] if the [index] is out of bounds of this list.
 */
@kotlin.internal.InlineOnly
public expect inline fun <T> List<T>.elementAt(index: Int): T

/**
 * Returns an element at the given [index] or the result of calling the [defaultValue] function if the [index] is out of bounds of this collection.
 */
public expect fun <T> Iterable<T>.elementAtOrElse(index: Int, defaultValue: (Int) -> T): T

/**
 * Returns an element at the given [index] or the result of calling the [defaultValue] function if the [index] is out of bounds of this list.
 */
@kotlin.internal.InlineOnly
public expect inline fun <T> List<T>.elementAtOrElse(index: Int, defaultValue: (Int) -> T): T

/**
 * Returns an element at the given [index] or `null` if the [index] is out of bounds of this collection.
 */
public expect fun <T> Iterable<T>.elementAtOrNull(index: Int): T?

/**
 * Returns an element at the given [index] or `null` if the [index] is out of bounds of this list.
 */
@kotlin.internal.InlineOnly
public expect inline fun <T> List<T>.elementAtOrNull(index: Int): T?

/**
 * Returns the first element matching the given [predicate], or `null` if no such element was found.
 */
@kotlin.internal.InlineOnly
public expect inline fun <T> Iterable<T>.find(predicate: (T) -> Boolean): T?

/**
 * Returns the last element matching the given [predicate], or `null` if no such element was found.
 */
@kotlin.internal.InlineOnly
public expect inline fun <T> Iterable<T>.findLast(predicate: (T) -> Boolean): T?

/**
 * Returns the last element matching the given [predicate], or `null` if no such element was found.
 */
@kotlin.internal.InlineOnly
public expect inline fun <T> List<T>.findLast(predicate: (T) -> Boolean): T?

/**
 * Returns first element.
 * @throws [NoSuchElementException] if the collection is empty.
 */
public expect fun <T> Iterable<T>.first(): T

/**
 * Returns first element.
 * @throws [NoSuchElementException] if the list is empty.
 */
public expect fun <T> List<T>.first(): T

/**
 * Returns the first element matching the given [predicate].
 * @throws [NoSuchElementException] if no such element is found.
 */
public expect inline fun <T> Iterable<T>.first(predicate: (T) -> Boolean): T

/**
 * Returns the first element, or `null` if the collection is empty.
 */
public expect fun <T> Iterable<T>.firstOrNull(): T?

/**
 * Returns the first element, or `null` if the list is empty.
 */
public expect fun <T> List<T>.firstOrNull(): T?

/**
 * Returns the first element matching the given [predicate], or `null` if element was not found.
 */
public expect inline fun <T> Iterable<T>.firstOrNull(predicate: (T) -> Boolean): T?

/**
 * Returns an element at the given [index] or the result of calling the [defaultValue] function if the [index] is out of bounds of this list.
 */
@kotlin.internal.InlineOnly
public expect inline fun <T> List<T>.getOrElse(index: Int, defaultValue: (Int) -> T): T

/**
 * Returns an element at the given [index] or `null` if the [index] is out of bounds of this list.
 */
public expect fun <T> List<T>.getOrNull(index: Int): T?

/**
 * Returns first index of [element], or -1 if the collection does not contain element.
 */
public expect fun <@kotlin.internal.OnlyInputTypes T> Iterable<T>.indexOf(element: T): Int

/**
 * Returns first index of [element], or -1 if the list does not contain element.
 */
@Suppress("EXTENSION_SHADOWED_BY_MEMBER") // false warning, extension takes precedence in some cases
public expect fun <@kotlin.internal.OnlyInputTypes T> List<T>.indexOf(element: T): Int

/**
 * Returns index of the first element matching the given [predicate], or -1 if the collection does not contain such element.
 */
public expect inline fun <T> Iterable<T>.indexOfFirst(predicate: (T) -> Boolean): Int

/**
 * Returns index of the first element matching the given [predicate], or -1 if the list does not contain such element.
 */
public expect inline fun <T> List<T>.indexOfFirst(predicate: (T) -> Boolean): Int

/**
 * Returns index of the last element matching the given [predicate], or -1 if the collection does not contain such element.
 */
public expect inline fun <T> Iterable<T>.indexOfLast(predicate: (T) -> Boolean): Int

/**
 * Returns index of the last element matching the given [predicate], or -1 if the list does not contain such element.
 */
public expect inline fun <T> List<T>.indexOfLast(predicate: (T) -> Boolean): Int

/**
 * Returns the last element.
 * @throws [NoSuchElementException] if the collection is empty.
 */
public expect fun <T> Iterable<T>.last(): T

/**
 * Returns the last element.
 * @throws [NoSuchElementException] if the list is empty.
 */
public expect fun <T> List<T>.last(): T

/**
 * Returns the last element matching the given [predicate].
 * @throws [NoSuchElementException] if no such element is found.
 */
public expect inline fun <T> Iterable<T>.last(predicate: (T) -> Boolean): T

/**
 * Returns the last element matching the given [predicate].
 * @throws [NoSuchElementException] if no such element is found.
 */
public expect inline fun <T> List<T>.last(predicate: (T) -> Boolean): T

/**
 * Returns last index of [element], or -1 if the collection does not contain element.
 */
public expect fun <@kotlin.internal.OnlyInputTypes T> Iterable<T>.lastIndexOf(element: T): Int

/**
 * Returns last index of [element], or -1 if the list does not contain element.
 */
@Suppress("EXTENSION_SHADOWED_BY_MEMBER") // false warning, extension takes precedence in some cases
public expect fun <@kotlin.internal.OnlyInputTypes T> List<T>.lastIndexOf(element: T): Int

/**
 * Returns the last element, or `null` if the collection is empty.
 */
public expect fun <T> Iterable<T>.lastOrNull(): T?

/**
 * Returns the last element, or `null` if the list is empty.
 */
public expect fun <T> List<T>.lastOrNull(): T?

/**
 * Returns the last element matching the given [predicate], or `null` if no such element was found.
 */
public expect inline fun <T> Iterable<T>.lastOrNull(predicate: (T) -> Boolean): T?

/**
 * Returns the last element matching the given [predicate], or `null` if no such element was found.
 */
public expect inline fun <T> List<T>.lastOrNull(predicate: (T) -> Boolean): T?

/**
 * Returns the single element, or throws an exception if the collection is empty or has more than one element.
 */
public expect fun <T> Iterable<T>.single(): T

/**
 * Returns the single element, or throws an exception if the list is empty or has more than one element.
 */
public expect fun <T> List<T>.single(): T

/**
 * Returns the single element matching the given [predicate], or throws exception if there is no or more than one matching element.
 */
public expect inline fun <T> Iterable<T>.single(predicate: (T) -> Boolean): T

/**
 * Returns single element, or `null` if the collection is empty or has more than one element.
 */
public expect fun <T> Iterable<T>.singleOrNull(): T?

/**
 * Returns single element, or `null` if the list is empty or has more than one element.
 */
public expect fun <T> List<T>.singleOrNull(): T?

/**
 * Returns the single element matching the given [predicate], or `null` if element was not found or more than one element was found.
 */
public expect inline fun <T> Iterable<T>.singleOrNull(predicate: (T) -> Boolean): T?

/**
 * Returns a list containing all elements except first [n] elements.
 */
public expect fun <T> Iterable<T>.drop(n: Int): List<T>

/**
 * Returns a list containing all elements except last [n] elements.
 */
public expect fun <T> List<T>.dropLast(n: Int): List<T>

/**
 * Returns a list containing all elements except last elements that satisfy the given [predicate].
 */
public expect inline fun <T> List<T>.dropLastWhile(predicate: (T) -> Boolean): List<T>

/**
 * Returns a list containing all elements except first elements that satisfy the given [predicate].
 */
public expect inline fun <T> Iterable<T>.dropWhile(predicate: (T) -> Boolean): List<T>

/**
 * Returns a list containing only elements matching the given [predicate].
 */
public expect inline fun <T> Iterable<T>.filter(predicate: (T) -> Boolean): List<T>

/**
 * Returns a list containing only elements matching the given [predicate].
 * @param [predicate] function that takes the index of an element and the element itself
 * and returns the result of predicate evaluation on the element.
 */
public expect inline fun <T> Iterable<T>.filterIndexed(predicate: (index: Int, T) -> Boolean): List<T>

/**
 * Appends all elements matching the given [predicate] to the given [destination].
 * @param [predicate] function that takes the index of an element and the element itself
 * and returns the result of predicate evaluation on the element.
 */
public expect inline fun <T, C : MutableCollection<in T>> Iterable<T>.filterIndexedTo(destination: C, predicate: (index: Int, T) -> Boolean): C

/**
 * Returns a list containing all elements that are instances of specified type parameter R.
 */
public expect inline fun <reified R> Iterable<*>.filterIsInstance(): List<@kotlin.internal.NoInfer R>

/**
 * Appends all elements that are instances of specified type parameter R to the given [destination].
 */
public expect inline fun <reified R, C : MutableCollection<in R>> Iterable<*>.filterIsInstanceTo(destination: C): C

/**
 * Returns a list containing all elements not matching the given [predicate].
 */
public expect inline fun <T> Iterable<T>.filterNot(predicate: (T) -> Boolean): List<T>

/**
 * Returns a list containing all elements that are not `null`.
 */
public expect fun <T : Any> Iterable<T?>.filterNotNull(): List<T>

/**
 * Appends all elements that are not `null` to the given [destination].
 */
public expect fun <C : MutableCollection<in T>, T : Any> Iterable<T?>.filterNotNullTo(destination: C): C

/**
 * Appends all elements not matching the given [predicate] to the given [destination].
 */
public expect inline fun <T, C : MutableCollection<in T>> Iterable<T>.filterNotTo(destination: C, predicate: (T) -> Boolean): C

/**
 * Appends all elements matching the given [predicate] to the given [destination].
 */
public expect inline fun <T, C : MutableCollection<in T>> Iterable<T>.filterTo(destination: C, predicate: (T) -> Boolean): C

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public expect fun <T> List<T>.slice(indices: IntRange): List<T>

/**
 * Returns a list containing elements at specified [indices].
 */
public expect fun <T> List<T>.slice(indices: Iterable<Int>): List<T>

/**
 * Returns a list containing first [n] elements.
 */
public expect fun <T> Iterable<T>.take(n: Int): List<T>

/**
 * Returns a list containing last [n] elements.
 */
public expect fun <T> List<T>.takeLast(n: Int): List<T>

/**
 * Returns a list containing last elements satisfying the given [predicate].
 */
public expect inline fun <T> List<T>.takeLastWhile(predicate: (T) -> Boolean): List<T>

/**
 * Returns a list containing first elements satisfying the given [predicate].
 */
public expect inline fun <T> Iterable<T>.takeWhile(predicate: (T) -> Boolean): List<T>

/**
 * Reverses elements in the list in-place.
 */
public expect fun <T> MutableList<T>.reverse(): Unit

/**
 * Returns a list with elements in reversed order.
 */
public expect fun <T> Iterable<T>.reversed(): List<T>

/**
 * Sorts elements in the list in-place according to natural sort order of the value returned by specified [selector] function.
 */
public expect inline fun <T, R : Comparable<R>> MutableList<T>.sortBy(crossinline selector: (T) -> R?): Unit

/**
 * Sorts elements in the list in-place descending according to natural sort order of the value returned by specified [selector] function.
 */
public expect inline fun <T, R : Comparable<R>> MutableList<T>.sortByDescending(crossinline selector: (T) -> R?): Unit

/**
 * Sorts elements in the list in-place descending according to their natural sort order.
 */
public expect fun <T : Comparable<T>> MutableList<T>.sortDescending(): Unit

/**
 * Returns a list of all elements sorted according to their natural sort order.
 */
public expect fun <T : Comparable<T>> Iterable<T>.sorted(): List<T>

/**
 * Returns a list of all elements sorted according to natural sort order of the value returned by specified [selector] function.
 */
public expect inline fun <T, R : Comparable<R>> Iterable<T>.sortedBy(crossinline selector: (T) -> R?): List<T>

/**
 * Returns a list of all elements sorted descending according to natural sort order of the value returned by specified [selector] function.
 */
public expect inline fun <T, R : Comparable<R>> Iterable<T>.sortedByDescending(crossinline selector: (T) -> R?): List<T>

/**
 * Returns a list of all elements sorted descending according to their natural sort order.
 */
public expect fun <T : Comparable<T>> Iterable<T>.sortedDescending(): List<T>

/**
 * Returns a list of all elements sorted according to the specified [comparator].
 */
public expect fun <T> Iterable<T>.sortedWith(comparator: Comparator<in T>): List<T>

/**
 * Returns an array of Boolean containing all of the elements of this collection.
 */
public expect fun Collection<Boolean>.toBooleanArray(): BooleanArray

/**
 * Returns an array of Byte containing all of the elements of this collection.
 */
public expect fun Collection<Byte>.toByteArray(): ByteArray

/**
 * Returns an array of Char containing all of the elements of this collection.
 */
public expect fun Collection<Char>.toCharArray(): CharArray

/**
 * Returns an array of Double containing all of the elements of this collection.
 */
public expect fun Collection<Double>.toDoubleArray(): DoubleArray

/**
 * Returns an array of Float containing all of the elements of this collection.
 */
public expect fun Collection<Float>.toFloatArray(): FloatArray

/**
 * Returns an array of Int containing all of the elements of this collection.
 */
public expect fun Collection<Int>.toIntArray(): IntArray

/**
 * Returns an array of Long containing all of the elements of this collection.
 */
public expect fun Collection<Long>.toLongArray(): LongArray

/**
 * Returns an array of Short containing all of the elements of this collection.
 */
public expect fun Collection<Short>.toShortArray(): ShortArray

/**
 * Returns a [Map] containing key-value pairs provided by [transform] function
 * applied to elements of the given collection.
 * 
 * If any of two pairs would have the same key the last one gets added to the map.
 * 
 * The returned map preserves the entry iteration order of the original collection.
 */
public expect inline fun <T, K, V> Iterable<T>.associate(transform: (T) -> Pair<K, V>): Map<K, V>

/**
 * Returns a [Map] containing the elements from the given collection indexed by the key
 * returned from [keySelector] function applied to each element.
 * 
 * If any two elements would have the same key returned by [keySelector] the last one gets added to the map.
 * 
 * The returned map preserves the entry iteration order of the original collection.
 */
public expect inline fun <T, K> Iterable<T>.associateBy(keySelector: (T) -> K): Map<K, T>

/**
 * Returns a [Map] containing the values provided by [valueTransform] and indexed by [keySelector] functions applied to elements of the given collection.
 * 
 * If any two elements would have the same key returned by [keySelector] the last one gets added to the map.
 * 
 * The returned map preserves the entry iteration order of the original collection.
 */
public expect inline fun <T, K, V> Iterable<T>.associateBy(keySelector: (T) -> K, valueTransform: (T) -> V): Map<K, V>

/**
 * Populates and returns the [destination] mutable map with key-value pairs,
 * where key is provided by the [keySelector] function applied to each element of the given collection
 * and value is the element itself.
 * 
 * If any two elements would have the same key returned by [keySelector] the last one gets added to the map.
 */
public expect inline fun <T, K, M : MutableMap<in K, in T>> Iterable<T>.associateByTo(destination: M, keySelector: (T) -> K): M

/**
 * Populates and returns the [destination] mutable map with key-value pairs,
 * where key is provided by the [keySelector] function and
 * and value is provided by the [valueTransform] function applied to elements of the given collection.
 * 
 * If any two elements would have the same key returned by [keySelector] the last one gets added to the map.
 */
public expect inline fun <T, K, V, M : MutableMap<in K, in V>> Iterable<T>.associateByTo(destination: M, keySelector: (T) -> K, valueTransform: (T) -> V): M

/**
 * Populates and returns the [destination] mutable map with key-value pairs
 * provided by [transform] function applied to each element of the given collection.
 * 
 * If any of two pairs would have the same key the last one gets added to the map.
 */
public expect inline fun <T, K, V, M : MutableMap<in K, in V>> Iterable<T>.associateTo(destination: M, transform: (T) -> Pair<K, V>): M

/**
 * Appends all elements to the given [destination] collection.
 */
public expect fun <T, C : MutableCollection<in T>> Iterable<T>.toCollection(destination: C): C

/**
 * Returns a [HashSet] of all elements.
 */
public expect fun <T> Iterable<T>.toHashSet(): HashSet<T>

/**
 * Returns a [List] containing all elements.
 */
public expect fun <T> Iterable<T>.toList(): List<T>

/**
 * Returns a [MutableList] filled with all elements of this collection.
 */
public expect fun <T> Iterable<T>.toMutableList(): MutableList<T>

/**
 * Returns a [MutableList] filled with all elements of this collection.
 */
public expect fun <T> Collection<T>.toMutableList(): MutableList<T>

/**
 * Returns a [Set] of all elements.
 * 
 * The returned set preserves the element iteration order of the original collection.
 */
public expect fun <T> Iterable<T>.toSet(): Set<T>

/**
 * Returns a single list of all elements yielded from results of [transform] function being invoked on each element of original collection.
 */
public expect inline fun <T, R> Iterable<T>.flatMap(transform: (T) -> Iterable<R>): List<R>

/**
 * Appends all elements yielded from results of [transform] function being invoked on each element of original collection, to the given [destination].
 */
public expect inline fun <T, R, C : MutableCollection<in R>> Iterable<T>.flatMapTo(destination: C, transform: (T) -> Iterable<R>): C

/**
 * Groups elements of the original collection by the key returned by the given [keySelector] function
 * applied to each element and returns a map where each group key is associated with a list of corresponding elements.
 * 
 * The returned map preserves the entry iteration order of the keys produced from the original collection.
 * 
 * @sample samples.collections.Collections.Transformations.groupBy
 */
public expect inline fun <T, K> Iterable<T>.groupBy(keySelector: (T) -> K): Map<K, List<T>>

/**
 * Groups values returned by the [valueTransform] function applied to each element of the original collection
 * by the key returned by the given [keySelector] function applied to the element
 * and returns a map where each group key is associated with a list of corresponding values.
 * 
 * The returned map preserves the entry iteration order of the keys produced from the original collection.
 * 
 * @sample samples.collections.Collections.Transformations.groupByKeysAndValues
 */
public expect inline fun <T, K, V> Iterable<T>.groupBy(keySelector: (T) -> K, valueTransform: (T) -> V): Map<K, List<V>>

/**
 * Groups elements of the original collection by the key returned by the given [keySelector] function
 * applied to each element and puts to the [destination] map each group key associated with a list of corresponding elements.
 * 
 * @return The [destination] map.
 * 
 * @sample samples.collections.Collections.Transformations.groupBy
 */
public expect inline fun <T, K, M : MutableMap<in K, MutableList<T>>> Iterable<T>.groupByTo(destination: M, keySelector: (T) -> K): M

/**
 * Groups values returned by the [valueTransform] function applied to each element of the original collection
 * by the key returned by the given [keySelector] function applied to the element
 * and puts to the [destination] map each group key associated with a list of corresponding values.
 * 
 * @return The [destination] map.
 * 
 * @sample samples.collections.Collections.Transformations.groupByKeysAndValues
 */
public expect inline fun <T, K, V, M : MutableMap<in K, MutableList<V>>> Iterable<T>.groupByTo(destination: M, keySelector: (T) -> K, valueTransform: (T) -> V): M

/**
 * Creates a [Grouping] source from a collection to be used later with one of group-and-fold operations
 * using the specified [keySelector] function to extract a key from each element.
 * 
 * @sample samples.collections.Collections.Transformations.groupingByEachCount
 */
@SinceKotlin("1.1")
public expect inline fun <T, K> Iterable<T>.groupingBy(crossinline keySelector: (T) -> K): Grouping<T, K>

/**
 * Returns a list containing the results of applying the given [transform] function
 * to each element in the original collection.
 */
public expect inline fun <T, R> Iterable<T>.map(transform: (T) -> R): List<R>

/**
 * Returns a list containing the results of applying the given [transform] function
 * to each element and its index in the original collection.
 * @param [transform] function that takes the index of an element and the element itself
 * and returns the result of the transform applied to the element.
 */
public expect inline fun <T, R> Iterable<T>.mapIndexed(transform: (index: Int, T) -> R): List<R>

/**
 * Returns a list containing only the non-null results of applying the given [transform] function
 * to each element and its index in the original collection.
 * @param [transform] function that takes the index of an element and the element itself
 * and returns the result of the transform applied to the element.
 */
public expect inline fun <T, R : Any> Iterable<T>.mapIndexedNotNull(transform: (index: Int, T) -> R?): List<R>

/**
 * Applies the given [transform] function to each element and its index in the original collection
 * and appends only the non-null results to the given [destination].
 * @param [transform] function that takes the index of an element and the element itself
 * and returns the result of the transform applied to the element.
 */
public expect inline fun <T, R : Any, C : MutableCollection<in R>> Iterable<T>.mapIndexedNotNullTo(destination: C, transform: (index: Int, T) -> R?): C

/**
 * Applies the given [transform] function to each element and its index in the original collection
 * and appends the results to the given [destination].
 * @param [transform] function that takes the index of an element and the element itself
 * and returns the result of the transform applied to the element.
 */
public expect inline fun <T, R, C : MutableCollection<in R>> Iterable<T>.mapIndexedTo(destination: C, transform: (index: Int, T) -> R): C

/**
 * Returns a list containing only the non-null results of applying the given [transform] function
 * to each element in the original collection.
 */
public expect inline fun <T, R : Any> Iterable<T>.mapNotNull(transform: (T) -> R?): List<R>

/**
 * Applies the given [transform] function to each element in the original collection
 * and appends only the non-null results to the given [destination].
 */
public expect inline fun <T, R : Any, C : MutableCollection<in R>> Iterable<T>.mapNotNullTo(destination: C, transform: (T) -> R?): C

/**
 * Applies the given [transform] function to each element of the original collection
 * and appends the results to the given [destination].
 */
public expect inline fun <T, R, C : MutableCollection<in R>> Iterable<T>.mapTo(destination: C, transform: (T) -> R): C

/**
 * Returns a lazy [Iterable] of [IndexedValue] for each element of the original collection.
 */
public expect fun <T> Iterable<T>.withIndex(): Iterable<IndexedValue<T>>

/**
 * Returns a list containing only distinct elements from the given collection.
 * 
 * The elements in the resulting list are in the same order as they were in the source collection.
 */
public expect fun <T> Iterable<T>.distinct(): List<T>

/**
 * Returns a list containing only elements from the given collection
 * having distinct keys returned by the given [selector] function.
 * 
 * The elements in the resulting list are in the same order as they were in the source collection.
 */
public expect inline fun <T, K> Iterable<T>.distinctBy(selector: (T) -> K): List<T>

/**
 * Returns a set containing all elements that are contained by both this set and the specified collection.
 * 
 * The returned set preserves the element iteration order of the original collection.
 */
public expect infix fun <T> Iterable<T>.intersect(other: Iterable<T>): Set<T>

/**
 * Returns a set containing all elements that are contained by this collection and not contained by the specified collection.
 * 
 * The returned set preserves the element iteration order of the original collection.
 */
public expect infix fun <T> Iterable<T>.subtract(other: Iterable<T>): Set<T>

/**
 * Returns a mutable set containing all distinct elements from the given collection.
 * 
 * The returned set preserves the element iteration order of the original collection.
 */
public expect fun <T> Iterable<T>.toMutableSet(): MutableSet<T>

/**
 * Returns a set containing all distinct elements from both collections.
 * 
 * The returned set preserves the element iteration order of the original collection.
 * Those elements of the [other] collection that are unique are iterated in the end
 * in the order of the [other] collection.
 */
public expect infix fun <T> Iterable<T>.union(other: Iterable<T>): Set<T>

/**
 * Returns `true` if all elements match the given [predicate].
 */
public expect inline fun <T> Iterable<T>.all(predicate: (T) -> Boolean): Boolean

/**
 * Returns `true` if collection has at least one element.
 */
public expect fun <T> Iterable<T>.any(): Boolean

/**
 * Returns `true` if at least one element matches the given [predicate].
 */
public expect inline fun <T> Iterable<T>.any(predicate: (T) -> Boolean): Boolean

/**
 * Returns the number of elements in this collection.
 */
public expect fun <T> Iterable<T>.count(): Int

/**
 * Returns the number of elements in this collection.
 */
@kotlin.internal.InlineOnly
public expect inline fun <T> Collection<T>.count(): Int

/**
 * Returns the number of elements matching the given [predicate].
 */
public expect inline fun <T> Iterable<T>.count(predicate: (T) -> Boolean): Int

/**
 * Accumulates value starting with [initial] value and applying [operation] from left to right to current accumulator value and each element.
 */
public expect inline fun <T, R> Iterable<T>.fold(initial: R, operation: (acc: R, T) -> R): R

/**
 * Accumulates value starting with [initial] value and applying [operation] from left to right
 * to current accumulator value and each element with its index in the original collection.
 * @param [operation] function that takes the index of an element, current accumulator value
 * and the element itself, and calculates the next accumulator value.
 */
public expect inline fun <T, R> Iterable<T>.foldIndexed(initial: R, operation: (index: Int, acc: R, T) -> R): R

/**
 * Accumulates value starting with [initial] value and applying [operation] from right to left to each element and current accumulator value.
 */
public expect inline fun <T, R> List<T>.foldRight(initial: R, operation: (T, acc: R) -> R): R

/**
 * Accumulates value starting with [initial] value and applying [operation] from right to left
 * to each element with its index in the original list and current accumulator value.
 * @param [operation] function that takes the index of an element, the element itself
 * and current accumulator value, and calculates the next accumulator value.
 */
public expect inline fun <T, R> List<T>.foldRightIndexed(initial: R, operation: (index: Int, T, acc: R) -> R): R

/**
 * Performs the given [action] on each element.
 */
@kotlin.internal.HidesMembers
public expect inline fun <T> Iterable<T>.forEach(action: (T) -> Unit): Unit

/**
 * Performs the given [action] on each element, providing sequential index with the element.
 * @param [action] function that takes the index of an element and the element itself
 * and performs the desired action on the element.
 */
public expect inline fun <T> Iterable<T>.forEachIndexed(action: (index: Int, T) -> Unit): Unit

/**
 * Returns the largest element or `null` if there are no elements.
 * 
 * If any of elements is `NaN` returns `NaN`.
 */
@SinceKotlin("1.1")
public expect fun Iterable<Double>.max(): Double?

/**
 * Returns the largest element or `null` if there are no elements.
 * 
 * If any of elements is `NaN` returns `NaN`.
 */
@SinceKotlin("1.1")
public expect fun Iterable<Float>.max(): Float?

/**
 * Returns the largest element or `null` if there are no elements.
 */
public expect fun <T : Comparable<T>> Iterable<T>.max(): T?

/**
 * Returns the first element yielding the largest value of the given function or `null` if there are no elements.
 */
public expect inline fun <T, R : Comparable<R>> Iterable<T>.maxBy(selector: (T) -> R): T?

/**
 * Returns the first element having the largest value according to the provided [comparator] or `null` if there are no elements.
 */
public expect fun <T> Iterable<T>.maxWith(comparator: Comparator<in T>): T?

/**
 * Returns the smallest element or `null` if there are no elements.
 * 
 * If any of elements is `NaN` returns `NaN`.
 */
@SinceKotlin("1.1")
public expect fun Iterable<Double>.min(): Double?

/**
 * Returns the smallest element or `null` if there are no elements.
 * 
 * If any of elements is `NaN` returns `NaN`.
 */
@SinceKotlin("1.1")
public expect fun Iterable<Float>.min(): Float?

/**
 * Returns the smallest element or `null` if there are no elements.
 */
public expect fun <T : Comparable<T>> Iterable<T>.min(): T?

/**
 * Returns the first element yielding the smallest value of the given function or `null` if there are no elements.
 */
public expect inline fun <T, R : Comparable<R>> Iterable<T>.minBy(selector: (T) -> R): T?

/**
 * Returns the first element having the smallest value according to the provided [comparator] or `null` if there are no elements.
 */
public expect fun <T> Iterable<T>.minWith(comparator: Comparator<in T>): T?

/**
 * Returns `true` if the collection has no elements.
 */
public expect fun <T> Iterable<T>.none(): Boolean

/**
 * Returns `true` if no elements match the given [predicate].
 */
public expect inline fun <T> Iterable<T>.none(predicate: (T) -> Boolean): Boolean

/**
 * Performs the given [action] on each element and returns the collection itself afterwards.
 */
@SinceKotlin("1.1")
public expect inline fun <T, C : Iterable<T>> C.onEach(action: (T) -> Unit): C

/**
 * Accumulates value starting with the first element and applying [operation] from left to right to current accumulator value and each element.
 */
public expect inline fun <S, T: S> Iterable<T>.reduce(operation: (acc: S, T) -> S): S

/**
 * Accumulates value starting with the first element and applying [operation] from left to right
 * to current accumulator value and each element with its index in the original collection.
 * @param [operation] function that takes the index of an element, current accumulator value
 * and the element itself and calculates the next accumulator value.
 */
public expect inline fun <S, T: S> Iterable<T>.reduceIndexed(operation: (index: Int, acc: S, T) -> S): S

/**
 * Accumulates value starting with last element and applying [operation] from right to left to each element and current accumulator value.
 */
public expect inline fun <S, T: S> List<T>.reduceRight(operation: (T, acc: S) -> S): S

/**
 * Accumulates value starting with last element and applying [operation] from right to left
 * to each element with its index in the original list and current accumulator value.
 * @param [operation] function that takes the index of an element, the element itself
 * and current accumulator value, and calculates the next accumulator value.
 */
public expect inline fun <S, T: S> List<T>.reduceRightIndexed(operation: (index: Int, T, acc: S) -> S): S

/**
 * Returns the sum of all values produced by [selector] function applied to each element in the collection.
 */
public expect inline fun <T> Iterable<T>.sumBy(selector: (T) -> Int): Int

/**
 * Returns the sum of all values produced by [selector] function applied to each element in the collection.
 */
public expect inline fun <T> Iterable<T>.sumByDouble(selector: (T) -> Double): Double

/**
 * Returns an original collection containing all the non-`null` elements, throwing an [IllegalArgumentException] if there are any `null` elements.
 */
public expect fun <T : Any> Iterable<T?>.requireNoNulls(): Iterable<T>

/**
 * Returns an original collection containing all the non-`null` elements, throwing an [IllegalArgumentException] if there are any `null` elements.
 */
public expect fun <T : Any> List<T?>.requireNoNulls(): List<T>

/**
 * Splits this collection into a list of lists each not exceeding the given [size].
 * 
 * The last list in the resulting list may have less elements than the given [size].
 * 
 * @param size the number of elements to take in each list, must be positive and can be greater than the number of elements in this collection.
 * 
 * @sample samples.collections.Collections.Transformations.chunked
 */
@SinceKotlin("1.2")
public expect fun <T> Iterable<T>.chunked(size: Int): List<List<T>>

/**
 * Splits this collection into several lists each not exceeding the given [size]
 * and applies the given [transform] function to an each.
 * 
 * @return list of results of the [transform] applied to an each list.
 * 
 * Note that the list passed to the [transform] function is ephemeral and is valid only inside that function.
 * You should not store it or allow it to escape in some way, unless you made a snapshot of it.
 * The last list may have less elements than the given [size].
 * 
 * @param size the number of elements to take in each list, must be positive and can be greater than the number of elements in this collection.
 * 
 * @sample samples.text.Strings.chunkedTransform
 */
@SinceKotlin("1.2")
public expect fun <T, R> Iterable<T>.chunked(size: Int, transform: (List<T>) -> R): List<R>

/**
 * Returns a list containing all elements of the original collection without the first occurrence of the given [element].
 */
public expect operator fun <T> Iterable<T>.minus(element: T): List<T>

/**
 * Returns a list containing all elements of the original collection except the elements contained in the given [elements] array.
 */
public expect operator fun <T> Iterable<T>.minus(elements: Array<out T>): List<T>

/**
 * Returns a list containing all elements of the original collection except the elements contained in the given [elements] collection.
 */
public expect operator fun <T> Iterable<T>.minus(elements: Iterable<T>): List<T>

/**
 * Returns a list containing all elements of the original collection except the elements contained in the given [elements] sequence.
 */
public expect operator fun <T> Iterable<T>.minus(elements: Sequence<T>): List<T>

/**
 * Returns a list containing all elements of the original collection without the first occurrence of the given [element].
 */
@kotlin.internal.InlineOnly
public expect inline fun <T> Iterable<T>.minusElement(element: T): List<T>

/**
 * Splits the original collection into pair of lists,
 * where *first* list contains elements for which [predicate] yielded `true`,
 * while *second* list contains elements for which [predicate] yielded `false`.
 */
public expect inline fun <T> Iterable<T>.partition(predicate: (T) -> Boolean): Pair<List<T>, List<T>>

/**
 * Returns a list containing all elements of the original collection and then the given [element].
 */
public expect operator fun <T> Iterable<T>.plus(element: T): List<T>

/**
 * Returns a list containing all elements of the original collection and then the given [element].
 */
public expect operator fun <T> Collection<T>.plus(element: T): List<T>

/**
 * Returns a list containing all elements of the original collection and then all elements of the given [elements] array.
 */
public expect operator fun <T> Iterable<T>.plus(elements: Array<out T>): List<T>

/**
 * Returns a list containing all elements of the original collection and then all elements of the given [elements] array.
 */
public expect operator fun <T> Collection<T>.plus(elements: Array<out T>): List<T>

/**
 * Returns a list containing all elements of the original collection and then all elements of the given [elements] collection.
 */
public expect operator fun <T> Iterable<T>.plus(elements: Iterable<T>): List<T>

/**
 * Returns a list containing all elements of the original collection and then all elements of the given [elements] collection.
 */
public expect operator fun <T> Collection<T>.plus(elements: Iterable<T>): List<T>

/**
 * Returns a list containing all elements of the original collection and then all elements of the given [elements] sequence.
 */
public expect operator fun <T> Iterable<T>.plus(elements: Sequence<T>): List<T>

/**
 * Returns a list containing all elements of the original collection and then all elements of the given [elements] sequence.
 */
public expect operator fun <T> Collection<T>.plus(elements: Sequence<T>): List<T>

/**
 * Returns a list containing all elements of the original collection and then the given [element].
 */
@kotlin.internal.InlineOnly
public expect inline fun <T> Iterable<T>.plusElement(element: T): List<T>

/**
 * Returns a list containing all elements of the original collection and then the given [element].
 */
@kotlin.internal.InlineOnly
public expect inline fun <T> Collection<T>.plusElement(element: T): List<T>

/**
 * Returns a list of snapshots of the window of the given [size]
 * sliding along this collection with the given [step], where each
 * snapshot is a list.
 * 
 * Several last lists may have less elements than the given [size].
 * 
 * Both [size] and [step] must be positive and can be greater than the number of elements in this collection.
 * @param size the number of elements to take in each window
 * @param step the number of elements to move the window forward by on an each step, by default 1
 * @param partialWindows controls whether or not to keep partial windows in the end if any,
 * by default `false` which means partial windows won't be preserved
 * 
 * @sample samples.collections.Sequences.Transformations.takeWindows
 */
@SinceKotlin("1.2")
public fun <T> Iterable<T>.windowed(size: Int, step: Int = 1, partialWindows: Boolean = false): List<List<T>> {
    checkWindowSizeStep(size, step)
    if (this is RandomAccess && this is List) {
        val thisSize = this.size
        val result = ArrayList<List<T>>((thisSize + step - 1) / step)
        var index = 0
        while (index < thisSize) {
            val windowSize = size.coerceAtMost(thisSize - index)
            if (windowSize < size && !partialWindows) break
            result.add(List(windowSize) { this[it + index] })
            index += step
        }
        return result
    }
    val result = ArrayList<List<T>>()
    windowedIterator(iterator(), size, step, partialWindows, reuseBuffer = false).forEach {
        result.add(it)
    }
    return result
}

/**
 * Returns a list of results of applying the given [transform] function to
 * an each list representing a view over the window of the given [size]
 * sliding along this collection with the given [step].
 * 
 * Note that the list passed to the [transform] function is ephemeral and is valid only inside that function.
 * You should not store it or allow it to escape in some way, unless you made a snapshot of it.
 * Several last lists may have less elements than the given [size].
 * 
 * Both [size] and [step] must be positive and can be greater than the number of elements in this collection.
 * @param size the number of elements to take in each window
 * @param step the number of elements to move the window forward by on an each step, by default 1
 * @param partialWindows controls whether or not to keep partial windows in the end if any,
 * by default `false` which means partial windows won't be preserved
 * 
 * @sample samples.collections.Sequences.Transformations.averageWindows
 */
@SinceKotlin("1.2")
public fun <T, R> Iterable<T>.windowed(size: Int, step: Int = 1, partialWindows: Boolean = false, transform: (List<T>) -> R): List<R> {
    checkWindowSizeStep(size, step)
    if (this is RandomAccess && this is List) {
        val thisSize = this.size
        val result = ArrayList<R>((thisSize + step - 1) / step)
        val window = MovingSubList(this)
        var index = 0
        while (index < thisSize) {
            window.move(index, (index + size).coerceAtMost(thisSize))
            if (!partialWindows && window.size < size) break
            result.add(transform(window))
            index += step
        }
        return result
    }
    val result = ArrayList<R>()
    windowedIterator(iterator(), size, step, partialWindows, reuseBuffer = true).forEach {
        result.add(transform(it))
    }
    return result
}

/**
 * Returns a list of pairs built from elements of both collections with same indexes. List has length of shortest collection.
 */
public expect infix fun <T, R> Iterable<T>.zip(other: Array<out R>): List<Pair<T, R>>

/**
 * Returns a list of values built from elements of both collections with same indexes using provided [transform]. List has length of shortest collection.
 */
public expect inline fun <T, R, V> Iterable<T>.zip(other: Array<out R>, transform: (a: T, b: R) -> V): List<V>

/**
 * Returns a list of pairs built from elements of both collections with same indexes. List has length of shortest collection.
 */
public expect infix fun <T, R> Iterable<T>.zip(other: Iterable<R>): List<Pair<T, R>>

/**
 * Returns a list of values built from elements of both collections with same indexes using provided [transform]. List has length of shortest collection.
 */
public expect inline fun <T, R, V> Iterable<T>.zip(other: Iterable<R>, transform: (a: T, b: R) -> V): List<V>

/**
 * Returns a list of pairs of each two adjacent elements in this collection.
 * 
 * The returned list is empty if this collection contains less than two elements.
 * 
 * @sample samples.collections.Collections.Transformations.zipWithNext
 */
@SinceKotlin("1.2")
public expect fun <T> Iterable<T>.zipWithNext(): List<Pair<T, T>>

/**
 * Returns a list containing the results of applying the given [transform] function
 * to an each pair of two adjacent elements in this collection.
 * 
 * The returned list is empty if this collection contains less than two elements.
 * 
 * @sample samples.collections.Collections.Transformations.zipWithNextToFindDeltas
 */
@SinceKotlin("1.2")
public expect inline fun <T, R> Iterable<T>.zipWithNext(transform: (a: T, b: T) -> R): List<R>

/**
 * Appends the string from all the elements separated using [separator] and using the given [prefix] and [postfix] if supplied.
 * 
 * If the collection could be huge, you can specify a non-negative value of [limit], in which case only the first [limit]
 * elements will be appended, followed by the [truncated] string (which defaults to "...").
 */
public fun <T, A : Appendable> Iterable<T>.joinTo(buffer: A, separator: CharSequence = ", ", prefix: CharSequence = "", postfix: CharSequence = "", limit: Int = -1, truncated: CharSequence = "...", transform: ((T) -> CharSequence)? = null): A {
    buffer.append(prefix)
    var count = 0
    for (element in this) {
        if (++count > 1) buffer.append(separator)
        if (limit < 0 || count <= limit) {
            buffer.appendElement(element, transform)
        } else break
    }
    if (limit >= 0 && count > limit) buffer.append(truncated)
    buffer.append(postfix)
    return buffer
}

/**
 * Creates a string from all the elements separated using [separator] and using the given [prefix] and [postfix] if supplied.
 * 
 * If the collection could be huge, you can specify a non-negative value of [limit], in which case only the first [limit]
 * elements will be appended, followed by the [truncated] string (which defaults to "...").
 */
public fun <T> Iterable<T>.joinToString(separator: CharSequence = ", ", prefix: CharSequence = "", postfix: CharSequence = "", limit: Int = -1, truncated: CharSequence = "...", transform: ((T) -> CharSequence)? = null): String {
    return joinTo(StringBuilder(), separator, prefix, postfix, limit, truncated, transform).toString()
}

/**
 * Returns this collection as an [Iterable].
 */
@kotlin.internal.InlineOnly
public expect inline fun <T> Iterable<T>.asIterable(): Iterable<T>

/**
 * Creates a [Sequence] instance that wraps the original collection returning its elements when being iterated.
 * 
 * @sample samples.collections.Sequences.Building.sequenceFromCollection
 */
public expect fun <T> Iterable<T>.asSequence(): Sequence<T>

/**
 * Returns an average value of elements in the collection.
 */
@kotlin.jvm.JvmName("averageOfByte")
public expect fun Iterable<Byte>.average(): Double

/**
 * Returns an average value of elements in the collection.
 */
@kotlin.jvm.JvmName("averageOfShort")
public expect fun Iterable<Short>.average(): Double

/**
 * Returns an average value of elements in the collection.
 */
@kotlin.jvm.JvmName("averageOfInt")
public expect fun Iterable<Int>.average(): Double

/**
 * Returns an average value of elements in the collection.
 */
@kotlin.jvm.JvmName("averageOfLong")
public expect fun Iterable<Long>.average(): Double

/**
 * Returns an average value of elements in the collection.
 */
@kotlin.jvm.JvmName("averageOfFloat")
public expect fun Iterable<Float>.average(): Double

/**
 * Returns an average value of elements in the collection.
 */
@kotlin.jvm.JvmName("averageOfDouble")
public expect fun Iterable<Double>.average(): Double

/**
 * Returns the sum of all elements in the collection.
 */
@kotlin.jvm.JvmName("sumOfByte")
public expect fun Iterable<Byte>.sum(): Int

/**
 * Returns the sum of all elements in the collection.
 */
@kotlin.jvm.JvmName("sumOfShort")
public expect fun Iterable<Short>.sum(): Int

/**
 * Returns the sum of all elements in the collection.
 */
@kotlin.jvm.JvmName("sumOfInt")
public expect fun Iterable<Int>.sum(): Int

/**
 * Returns the sum of all elements in the collection.
 */
@kotlin.jvm.JvmName("sumOfLong")
public expect fun Iterable<Long>.sum(): Long

/**
 * Returns the sum of all elements in the collection.
 */
@kotlin.jvm.JvmName("sumOfFloat")
public expect fun Iterable<Float>.sum(): Float

/**
 * Returns the sum of all elements in the collection.
 */
@kotlin.jvm.JvmName("sumOfDouble")
public expect fun Iterable<Double>.sum(): Double

