/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.debug.internal;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.jvm.internal.CoroutineStackFrame;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobSupport;
import kotlinx.coroutines.debug.CoroutineState;
import kotlinx.coroutines.debug.DebugProbes;
import kotlinx.coroutines.debug.State;
import kotlinx.coroutines.debug.internal.DebugProbesImpl;
import kotlinx.coroutines.internal.ScopeCoroutine;
import kotlinx.coroutines.internal.StackTraceRecoveryKt;
import kotlinx.coroutines.repackaged.net.bytebuddy.ByteBuddy;
import kotlinx.coroutines.repackaged.net.bytebuddy.agent.ByteBuddyAgent;
import kotlinx.coroutines.repackaged.net.bytebuddy.dynamic.DynamicType;
import kotlinx.coroutines.repackaged.net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001?B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0004H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001aJ\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u0016J\u0014\u0010\u001f\u001a\u00020\u00162\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J'\u0010!\u001a\b\u0012\u0004\u0012\u0002H#0\"\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0\"H\u0000\u00a2\u0006\u0002\b%J\u0019\u0010&\u001a\u00020\u00162\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\"H\u0000\u00a2\u0006\u0002\b(J\u0019\u0010)\u001a\u00020\u00162\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\"H\u0000\u00a2\u0006\u0002\b*J%\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00130\u001a\"\b\b\u0000\u0010#*\u00020,2\u0006\u0010-\u001a\u0002H#H\u0002\u00a2\u0006\u0002\u0010.J*\u0010/\u001a\u00020\u0016\"\u0004\b\u0000\u0010#2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H#0\u00072\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0\"H\u0002J\u0006\u00100\u001a\u00020\u0016J\u001c\u00101\u001a\u00020\u00162\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u00102\u001a\u000203H\u0002J*\u00101\u001a\u00020\u00162\f\u00104\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u00102\u001a\u000203H\u0002J4\u00105\u001a\u00020\u0016*\u00020\u001d2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\b072\n\u00108\u001a\u000609j\u0002`:2\u0006\u0010;\u001a\u00020\u0004H\u0002J\u0016\u00104\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007*\u0006\u0012\u0002\b\u00030\"H\u0002J\u0013\u00104\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007*\u00020<H\u0082\u0010J\u001e\u0010=\u001a\u00020\u0016*\u000609j\u0002`:2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00130\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u00020\u000e*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006@"}, d2={"Lkotlinx/coroutines/debug/internal/DebugProbesImpl;", "", "()V", "ARTIFICIAL_FRAME_MESSAGE", "", "capturedCoroutines", "Ljava/util/WeakHashMap;", "Lkotlinx/coroutines/debug/internal/DebugProbesImpl$ArtificialStackFrame;", "Lkotlinx/coroutines/debug/CoroutineState;", "dateFormat", "Ljava/text/SimpleDateFormat;", "installations", "", "isInstalled", "", "()Z", "sequenceNumber", "", "isInternalMethod", "Ljava/lang/StackTraceElement;", "(Ljava/lang/StackTraceElement;)Z", "dumpCoroutines", "", "out", "Ljava/io/PrintStream;", "dumpCoroutinesState", "", "hierarchyToString", "job", "Lkotlinx/coroutines/Job;", "install", "probeCoroutineCompleted", "coroutine", "probeCoroutineCreated", "Lkotlin/coroutines/Continuation;", "T", "completion", "probeCoroutineCreated$kotlinx_coroutines_debug", "probeCoroutineResumed", "frame", "probeCoroutineResumed$kotlinx_coroutines_debug", "probeCoroutineSuspended", "probeCoroutineSuspended$kotlinx_coroutines_debug", "sanitizeStackTrace", "", "throwable", "(Ljava/lang/Throwable;)Ljava/util/List;", "storeFrame", "uninstall", "updateState", "state", "Lkotlinx/coroutines/debug/State;", "owner", "build", "map", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;", "printStackTrace", "frames", "ArtificialStackFrame", "kotlinx-coroutines-debug"})
public final class DebugProbesImpl {
    private static final String ARTIFICIAL_FRAME_MESSAGE = "Coroutine creation stacktrace";
    private static final SimpleDateFormat dateFormat;
    private static final WeakHashMap<ArtificialStackFrame<?>, CoroutineState> capturedCoroutines;
    private static volatile int installations;
    private static long sequenceNumber;
    public static final DebugProbesImpl INSTANCE;

    private final boolean isInstalled() {
        return installations > 0;
    }

    public final synchronized void install() {
        if (++installations > 1) {
            return;
        }
        ByteBuddyAgent.install();
        Class<?> cl = Class.forName("kotlin.coroutines.jvm.internal.DebugProbesKt");
        Class<?> cl2 = Class.forName("kotlinx.coroutines.debug.DebugProbesKt");
        DynamicType.Builder<?> builder = new ByteBuddy().redefine(cl2);
        Class<?> clazz = cl;
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"cl");
        builder.name(clazz.getName()).make().load(cl.getClassLoader(), ClassReloadingStrategy.fromInstalledAgent());
    }

    public final synchronized void uninstall() {
        boolean bl = this.isInstalled();
        if (!bl) {
            String string = "Agent was not installed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if ((installations += -1) != 0) {
            return;
        }
        capturedCoroutines.clear();
        Class<?> cl = Class.forName("kotlin.coroutines.jvm.internal.DebugProbesKt");
        Class<?> cl2 = Class.forName("kotlinx.coroutines.debug.internal.NoOpProbesKt");
        DynamicType.Builder<?> builder = new ByteBuddy().redefine(cl2);
        Class<?> clazz = cl;
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"cl");
        builder.name(clazz.getName()).make().load(cl.getClassLoader(), ClassReloadingStrategy.fromInstalledAgent());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized String hierarchyToString(@NotNull Job job) {
        StringBuilder stringBuilder;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        boolean bl = this.isInstalled();
        if (!bl) {
            String string = "Debug probes are not installed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Map $receiver$iv = capturedCoroutines;
        Map result$iv = new LinkedHashMap();
        Map map = $receiver$iv;
        for (Map.Entry entry$iv : map.entrySet()) {
            ArtificialStackFrame it = (ArtificialStackFrame)entry$iv.getKey();
            if (!(it.delegate.getContext().get((CoroutineContext.Key)Job.Key) != null)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        $receiver$iv = result$iv;
        result$iv = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry $i$a$1$filterKeys = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            CoroutineContext.Element element = ((ArtificialStackFrame)it.getKey()).delegate.getContext().get((CoroutineContext.Key)Job.Key);
            if (element == null) {
                Intrinsics.throwNpe();
            }
            Job job2 = (Job)element;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Job job3 = job2;
            Map map3 = map2;
            Object v = it$iv$iv.getValue();
            map3.put(job3, v);
        }
        Map jobToStack = destination$iv$iv;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        INSTANCE.build(job, jobToStack, $receiver, "");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void build(@NotNull Job $receiver, Map<Job, CoroutineState> map, StringBuilder builder, String indent) {
        String str;
        CoroutineState state = map.get($receiver);
        builder.append(indent);
        String string = str = !($receiver instanceof JobSupport) ? $receiver.toString() : ((JobSupport)$receiver).toDebugString();
        if (state == null) {
            if (!($receiver instanceof ScopeCoroutine)) {
                builder.append(str + '\n');
            }
        } else {
            StackTraceElement element = (StackTraceElement)CollectionsKt.firstOrNull(state.lastObservedStackTrace());
            State contState = state.getState();
            builder.append(str + ", continuation is " + (Object)((Object)contState) + " at line " + element + '\n');
        }
        for (Job child : $receiver.getChildren()) {
            this.build(child, map, builder, indent + "\t");
        }
    }

    @NotNull
    public final synchronized List<CoroutineState> dumpCoroutinesState() {
        boolean bl = this.isInstalled();
        if (!bl) {
            String string = "Debug probes are not installed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Set<Map.Entry<ArtificialStackFrame<?>, CoroutineState>> set = capturedCoroutines.entrySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"capturedCoroutines.entries");
        Sequence $receiver$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)dumpCoroutinesState.2.INSTANCE);
        Sequence sequence = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                CoroutineState it = (CoroutineState)a;
                it = (CoroutineState)b;
                Comparable comparable = Long.valueOf(it.sequenceNumber);
                Long l = it.sequenceNumber;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)l);
            }
        };
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)sequence, (Comparator)comparator));
    }

    public final void dumpCoroutines(@NotNull PrintStream out) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        boolean bl = this.isInstalled();
        if (!bl) {
            String string2 = "Debug probes are not installed";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String it = string = this.dumpCoroutines();
        out.println(it);
    }

    private final synchronized String dumpCoroutines() {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append("Coroutines dump " + dateFormat.format(System.currentTimeMillis()));
        Sequence $receiver$iv = MapsKt.asSequence((Map)capturedCoroutines);
        Sequence sequence = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                it = (Map.Entry)b;
                Comparable comparable = Long.valueOf(((CoroutineState)it.getValue()).sequenceNumber);
                Long l = ((CoroutineState)it.getValue()).sequenceNumber;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)l);
            }
        };
        $receiver$iv = SequencesKt.sortedWith((Sequence)sequence, (Comparator)comparator);
        for (Object element$iv : $receiver$iv) {
            Map.Entry $key_value;
            Map.Entry entry = $key_value = (Map.Entry)element$iv;
            ArtificialStackFrame key = (ArtificialStackFrame)entry.getKey();
            entry = $key_value;
            CoroutineState value = (CoroutineState)entry.getValue();
            String state = value.getState() == State.RUNNING ? (Object)((Object)value.getState()) + " (Last suspension stacktrace, not an actual stacktrace)" : value.getState().toString();
            $receiver.append("\n\nCoroutine " + key + ", state: " + state);
            List<StackTraceElement> observedStackTrace = value.lastObservedStackTrace();
            if (observedStackTrace.isEmpty()) {
                $receiver.append("\n\tat " + StackTraceRecoveryKt.artificialFrame((String)ARTIFICIAL_FRAME_MESSAGE));
                INSTANCE.printStackTrace($receiver, value.getCreationStackTrace());
                continue;
            }
            INSTANCE.printStackTrace($receiver, value.lastObservedStackTrace());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void printStackTrace(@NotNull StringBuilder $receiver, List<StackTraceElement> frames) {
        Iterable $receiver$iv = frames;
        for (Object element$iv : $receiver$iv) {
            StackTraceElement frame2 = (StackTraceElement)element$iv;
            $receiver.append("\n\tat " + frame2);
        }
    }

    public final void probeCoroutineResumed$kotlinx_coroutines_debug(@NotNull Continuation<?> frame2) {
        Intrinsics.checkParameterIsNotNull(frame2, (String)"frame");
        this.updateState(frame2, State.RUNNING);
    }

    public final void probeCoroutineSuspended$kotlinx_coroutines_debug(@NotNull Continuation<?> frame2) {
        Intrinsics.checkParameterIsNotNull(frame2, (String)"frame");
        this.updateState(frame2, State.SUSPENDED);
    }

    private final void updateState(Continuation<?> frame2, State state) {
        if (!this.isInstalled()) {
            return;
        }
        ArtificialStackFrame<?> owner = this.owner(frame2);
        this.updateState(owner, frame2, state);
    }

    private final synchronized void updateState(ArtificialStackFrame<?> owner, Continuation<?> frame2, State state) {
        CoroutineState coroutineState = capturedCoroutines.get(owner);
        if (coroutineState == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)coroutineState, (String)"capturedCoroutines[owner] ?: return");
        CoroutineState coroutineState2 = coroutineState;
        coroutineState2.updateState$kotlinx_coroutines_debug(state, frame2);
    }

    private final ArtificialStackFrame<?> owner(@NotNull Continuation<?> $receiver) {
        Continuation<?> continuation = $receiver;
        if (!(continuation instanceof CoroutineStackFrame)) {
            continuation = null;
        }
        CoroutineStackFrame coroutineStackFrame = (CoroutineStackFrame)continuation;
        return coroutineStackFrame != null ? this.owner(coroutineStackFrame) : null;
    }

    private final ArtificialStackFrame<?> owner(@NotNull CoroutineStackFrame $receiver) {
        ArtificialStackFrame artificialStackFrame;
        block2: {
            while (true) {
                if ($receiver instanceof ArtificialStackFrame) {
                    artificialStackFrame = (ArtificialStackFrame)$receiver;
                    break block2;
                }
                if ($receiver.getCallerFrame() == null) break;
            }
            artificialStackFrame = null;
        }
        return artificialStackFrame;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> Continuation<T> probeCoroutineCreated$kotlinx_coroutines_debug(@NotNull Continuation<? super T> completion) {
        CoroutineStackFrame frame2;
        void $receiver$iv;
        CoroutineStackFrame initial$iv;
        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
        if (!this.isInstalled()) {
            return completion;
        }
        ArtificialStackFrame<?> owner = this.owner(completion);
        if (owner != null) {
            return completion;
        }
        List<StackTraceElement> stacktrace = this.sanitizeStackTrace((Throwable)new Exception());
        Object object = stacktrace;
        CoroutineStackFrame accumulator$iv = initial$iv = null;
        if (!$receiver$iv.isEmpty()) {
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                void acc;
                CoroutineStackFrame coroutineStackFrame = accumulator$iv;
                StackTraceElement frame3 = (StackTraceElement)iterator$iv.previous();
                accumulator$iv = new CoroutineStackFrame(frame3, (CoroutineStackFrame)acc){
                    @Nullable
                    private final CoroutineStackFrame callerFrame;
                    final /* synthetic */ StackTraceElement $frame;
                    final /* synthetic */ CoroutineStackFrame $acc;

                    @Nullable
                    public CoroutineStackFrame getCallerFrame() {
                        return this.callerFrame;
                    }

                    @NotNull
                    public StackTraceElement getStackTraceElement() {
                        return this.$frame;
                    }
                    {
                        this.$frame = $captured_local_variable$0;
                        this.$acc = $captured_local_variable$1;
                        this.callerFrame = $captured_local_variable$1;
                    }
                };
            }
        }
        CoroutineStackFrame coroutineStackFrame = frame2 = (CoroutineStackFrame)accumulator$iv;
        if (coroutineStackFrame == null) {
            Intrinsics.throwNpe();
        }
        Object it = object = new ArtificialStackFrame<T>(completion, coroutineStackFrame);
        INSTANCE.storeFrame((ArtificialStackFrame<T>)it, completion);
        return (Continuation)object;
    }

    private final synchronized <T> void storeFrame(ArtificialStackFrame<T> frame2, Continuation<? super T> completion) {
        Map map = capturedCoroutines;
        CoroutineState coroutineState = new CoroutineState(completion, frame2, ++sequenceNumber);
        map.put(frame2, coroutineState);
    }

    private final synchronized void probeCoroutineCompleted(ArtificialStackFrame<?> coroutine) {
        capturedCoroutines.remove(coroutine);
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends Throwable> List<StackTraceElement> sanitizeStackTrace(T throwable) {
        int probeIndex;
        int index$iv222;
        Object object;
        int size;
        Object[] stackTrace;
        block9: {
            int n;
            stackTrace = throwable.getStackTrace();
            size = stackTrace.length;
            Intrinsics.checkExpressionValueIsNotNull((Object)stackTrace, (String)"stackTrace");
            Object[] $receiver$iv = stackTrace;
            object = CollectionsKt.reversed((Iterable)((Iterable)ArraysKt.getIndices((Object[])$receiver$iv))).iterator();
            while (object.hasNext()) {
                Object it;
                index$iv222 = ((Number)object.next()).intValue();
                Object object2 = it = $receiver$iv[index$iv222];
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it");
                if (!Intrinsics.areEqual((Object)((StackTraceElement)object2).getClassName(), (Object)"kotlin.coroutines.jvm.internal.DebugProbesKt")) continue;
                n = index$iv222;
                break block9;
            }
            n = probeIndex = -1;
        }
        if (!DebugProbes.INSTANCE.getSanitizeStackTraces()) {
            int $receiver$iv = size - probeIndex;
            object = new ArrayList($receiver$iv);
            int n = $receiver$iv;
            for (index$iv222 = 0; index$iv222 < n; ++index$iv222) {
                void it;
                int $i$a$1$indexOfLast;
                int $i$f$indexOfLast = $i$a$1$indexOfLast = index$iv222;
                Object object3 = object;
                StackTraceElement stackTraceElement = it == false ? StackTraceRecoveryKt.artificialFrame((String)ARTIFICIAL_FRAME_MESSAGE) : stackTrace[it + probeIndex];
                ((ArrayList)object3).add(stackTraceElement);
            }
            return (List)object;
        }
        ArrayList result = new ArrayList(size - probeIndex + 1);
        object = result;
        StackTraceElement index$iv222 = StackTraceRecoveryKt.artificialFrame((String)ARTIFICIAL_FRAME_MESSAGE);
        object.add(index$iv222);
        boolean includeInternalFrame = true;
        int index$iv222 = probeIndex + 1;
        int n = size - 1;
        while (index$iv222 < n) {
            Collection collection;
            void i;
            Object element;
            Object object4 = element = stackTrace[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"element");
            if (!this.isInternalMethod((StackTraceElement)object4)) {
                includeInternalFrame = true;
                collection = result;
                collection.add(element);
            } else if (includeInternalFrame) {
                collection = result;
                collection.add(element);
                includeInternalFrame = false;
            } else {
                Object object5 = stackTrace[i + true];
                Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"stackTrace[i + 1]");
                if (!this.isInternalMethod((StackTraceElement)object5)) {
                    collection = result;
                    collection.add(element);
                    includeInternalFrame = true;
                }
            }
            ++i;
        }
        Collection collection = result;
        Object object6 = stackTrace[size - 1];
        collection.add(object6);
        return result;
    }

    private final boolean isInternalMethod(@NotNull StackTraceElement $receiver) {
        String string = $receiver.getClassName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className");
        return StringsKt.startsWith$default((String)string, (String)"kotlinx.coroutines", (boolean)false, (int)2, null);
    }

    private DebugProbesImpl() {
    }

    static {
        DebugProbesImpl debugProbesImpl;
        INSTANCE = debugProbesImpl = new DebugProbesImpl();
        dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        capturedCoroutines = new WeakHashMap();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0001J\u001e\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00028\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lkotlinx/coroutines/debug/internal/DebugProbesImpl$ArtificialStackFrame;", "T", "Lkotlin/coroutines/Continuation;", "Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;", "delegate", "frame", "(Lkotlin/coroutines/Continuation;Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;)V", "callerFrame", "getCallerFrame", "()Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;", "context", "Lkotlin/coroutines/CoroutineContext;", "getContext", "()Lkotlin/coroutines/CoroutineContext;", "getStackTraceElement", "Ljava/lang/StackTraceElement;", "resumeWith", "", "result", "Lkotlin/Result;", "(Ljava/lang/Object;)V", "toString", "", "kotlinx-coroutines-debug"})
    private static final class ArtificialStackFrame<T>
    implements Continuation<T>,
    CoroutineStackFrame {
        @JvmField
        @NotNull
        public final Continuation<T> delegate;
        private final /* synthetic */ CoroutineStackFrame $$delegate_1;

        public void resumeWith(@NotNull Object result) {
            INSTANCE.probeCoroutineCompleted(this);
            this.delegate.resumeWith(result);
        }

        @NotNull
        public String toString() {
            return this.delegate.toString();
        }

        public ArtificialStackFrame(@NotNull Continuation<? super T> delegate, @NotNull CoroutineStackFrame frame2) {
            Intrinsics.checkParameterIsNotNull(delegate, (String)"delegate");
            Intrinsics.checkParameterIsNotNull((Object)frame2, (String)"frame");
            this.$$delegate_1 = frame2;
            this.delegate = delegate;
        }

        @NotNull
        public CoroutineContext getContext() {
            return this.delegate.getContext();
        }

        @Nullable
        public CoroutineStackFrame getCallerFrame() {
            return this.$$delegate_1.getCallerFrame();
        }

        @Nullable
        public StackTraceElement getStackTraceElement() {
            return this.$$delegate_1.getStackTraceElement();
        }
    }
}

