/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.repackaged.net.bytebuddy.agent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

public interface VirtualMachine {
    public void loadAgent(String var1, String var2) throws IOException;

    public void detach() throws IOException;

    public static abstract class ForHotSpot
    implements VirtualMachine {
        private static final String UTF_8 = "UTF-8";
        private static final String PROTOCOL_VERSION = "1";
        private static final String LOAD_COMMAND = "load";
        private static final String INSTRUMENT_COMMAND = "instrument";
        private static final String ARGUMENT_DELIMITER = "=";
        private static final byte[] BLANK = new byte[]{0};
        protected final String processId;

        protected ForHotSpot(String processId) {
            this.processId = processId;
        }

        public void loadAgent(String jarFile, String argument) throws IOException {
            int length;
            this.connect();
            this.write(PROTOCOL_VERSION.getBytes(UTF_8));
            this.write(BLANK);
            this.write(LOAD_COMMAND.getBytes(UTF_8));
            this.write(BLANK);
            this.write(INSTRUMENT_COMMAND.getBytes(UTF_8));
            this.write(BLANK);
            this.write(Boolean.FALSE.toString().getBytes(UTF_8));
            this.write(BLANK);
            this.write((argument == null ? jarFile : jarFile + ARGUMENT_DELIMITER + argument).getBytes(UTF_8));
            this.write(BLANK);
            byte[] buffer = new byte[1];
            StringBuilder stringBuilder = new StringBuilder();
            while ((length = this.read(buffer)) != -1) {
                if (length <= 0) continue;
                if (buffer[0] == 10) break;
                stringBuilder.append((char)buffer[0]);
            }
            switch (Integer.parseInt(stringBuilder.toString())) {
                case 0: {
                    return;
                }
                case 101: {
                    throw new IOException("Protocol mismatch with target VM");
                }
            }
            buffer = new byte[1024];
            stringBuilder = new StringBuilder();
            while ((length = this.read(buffer)) != -1) {
                stringBuilder.append(new String(buffer, 0, length, UTF_8));
            }
            throw new IllegalStateException(stringBuilder.toString());
        }

        protected abstract void connect() throws IOException;

        protected abstract int read(byte[] var1) throws IOException;

        protected abstract void write(byte[] var1) throws IOException;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class OnUnix
        extends ForHotSpot {
            private static final int DEFAULT_ATTEMPTS = 10;
            private static final long DEFAULT_PAUSE = 200L;
            private static final long DEFAULT_TIMEOUT = 5000L;
            private static final String TEMPORARY_DIRECTORY = "/tmp";
            private static final String SOCKET_FILE_PREFIX = ".java_pid";
            private static final String ATTACH_FILE_PREFIX = ".attach_pid";
            private final Object socket;
            private final int attempts;
            private final long pause;
            private final long timeout;
            private final TimeUnit timeUnit;

            public OnUnix(String processId, Object socket, int attempts, long pause, long timeout, TimeUnit timeUnit) {
                super(processId);
                this.socket = socket;
                this.attempts = attempts;
                this.pause = pause;
                this.timeout = timeout;
                this.timeUnit = timeUnit;
            }

            public static Class<?> assertAvailability() throws Throwable {
                try {
                    Class<?> moduleType = Class.forName("java.lang.Module");
                    Method getModule = Class.class.getMethod("getModule", new Class[0]);
                    Method canRead = moduleType.getMethod("canRead", moduleType);
                    Object thisModule = getModule.invoke(OnUnix.class, new Object[0]);
                    Object otherModule = getModule.invoke(AFUNIXSocket.class, new Object[0]);
                    if (!((Boolean)canRead.invoke(thisModule, otherModule)).booleanValue()) {
                        moduleType.getMethod("addReads", moduleType).invoke(thisModule, otherModule);
                    }
                    return OnUnix.doAssertAvailability();
                }
                catch (ClassNotFoundException ignored) {
                    return OnUnix.doAssertAvailability();
                }
            }

            private static Class<?> doAssertAvailability() {
                if (!AFUNIXSocket.isSupported()) {
                    throw new IllegalStateException("POSIX sockets are not supported on the current system");
                }
                if (!System.getProperty("java.vm.name").toLowerCase(Locale.US).contains("hotspot")) {
                    throw new IllegalStateException("Cannot apply attachment on non-Hotspot compatible VM");
                }
                return OnUnix.class;
            }

            public static VirtualMachine attach(String processId) throws IOException {
                return new OnUnix(processId, AFUNIXSocket.newInstance(), 10, 200L, 5000L, TimeUnit.MILLISECONDS);
            }

            @Override
            @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"}, justification="This is a Unix-specific implementation")
            protected void connect() throws IOException {
                File socketFile = new File(TEMPORARY_DIRECTORY, SOCKET_FILE_PREFIX + this.processId);
                if (!socketFile.exists()) {
                    File attachFile;
                    block18: {
                        String target = ATTACH_FILE_PREFIX + this.processId;
                        String path = "/proc/" + this.processId + "/cwd/" + target;
                        attachFile = new File(path);
                        try {
                            if (!attachFile.createNewFile() && !attachFile.isFile()) {
                                throw new IllegalStateException("Could not create attach file: " + attachFile);
                            }
                        }
                        catch (IOException ignored) {
                            attachFile = new File(TEMPORARY_DIRECTORY, target);
                            if (attachFile.createNewFile() || attachFile.isFile()) break block18;
                            throw new IllegalStateException("Could not create attach file: " + attachFile);
                        }
                    }
                    try {
                        Process process = Runtime.getRuntime().exec("kill -3 " + this.processId);
                        int attempts = this.attempts;
                        boolean killed = false;
                        while (true) {
                            try {
                                if (process.exitValue() != 0) {
                                    throw new IllegalStateException("Error while sending signal to target VM: " + this.processId);
                                }
                                killed = true;
                            }
                            catch (IllegalThreadStateException ignored) {
                                Thread.sleep(this.timeUnit.toMillis(this.pause));
                                if (--attempts > 0) continue;
                            }
                            break;
                        }
                        if (!killed) {
                            throw new IllegalStateException("Target VM did not respond to signal: " + this.processId);
                        }
                        attempts = this.attempts;
                        while (attempts-- > 0 && !socketFile.exists()) {
                            Thread.sleep(this.timeUnit.toMillis(this.pause));
                        }
                        if (!socketFile.exists()) {
                            throw new IllegalStateException("Target VM did not respond: " + this.processId);
                        }
                    }
                    catch (InterruptedException exception) {
                        throw new IllegalStateException("Interrupted during wait for process", exception);
                    }
                    finally {
                        if (!attachFile.delete()) {
                            attachFile.deleteOnExit();
                        }
                    }
                }
                if (this.timeout != 0L) {
                    ((AFUNIXSocket)this.socket).setSoTimeout((int)this.timeUnit.toMillis(this.timeout));
                }
                ((AFUNIXSocket)this.socket).connect((SocketAddress)new AFUNIXSocketAddress(socketFile));
            }

            @Override
            public int read(byte[] buffer) throws IOException {
                return ((AFUNIXSocket)this.socket).getInputStream().read(buffer);
            }

            @Override
            public void write(byte[] buffer) throws IOException {
                ((AFUNIXSocket)this.socket).getOutputStream().write(buffer);
            }

            @Override
            public void detach() throws IOException {
                ((AFUNIXSocket)this.socket).close();
            }
        }
    }
}

