/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.debug;

import java.io.PrintStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.debug.CoroutineInfo;
import kotlinx.coroutines.debug.internal.DebugProbesImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u001a\u001a\u00020\nJ\u0017\u0010\u001b\u001a\u00020\n2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u001dH\u0086\bR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lkotlinx/coroutines/debug/DebugProbes;", "", "()V", "sanitizeStackTraces", "", "getSanitizeStackTraces", "()Z", "setSanitizeStackTraces", "(Z)V", "dumpCoroutines", "", "out", "Ljava/io/PrintStream;", "dumpCoroutinesInfo", "", "Lkotlinx/coroutines/debug/CoroutineInfo;", "install", "jobToString", "", "job", "Lkotlinx/coroutines/Job;", "printJob", "printScope", "scope", "Lkotlinx/coroutines/CoroutineScope;", "scopeToString", "uninstall", "withDebugProbes", "block", "Lkotlin/Function0;", "kotlinx-coroutines-debug"})
@ExperimentalCoroutinesApi
public final class DebugProbes {
    private static boolean sanitizeStackTraces;
    public static final DebugProbes INSTANCE;

    public final boolean getSanitizeStackTraces() {
        return sanitizeStackTraces;
    }

    public final void setSanitizeStackTraces(boolean bl) {
        sanitizeStackTraces = bl;
    }

    public final void install() {
        DebugProbesImpl.INSTANCE.install();
    }

    public final void uninstall() {
        DebugProbesImpl.INSTANCE.uninstall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void withDebugProbes(@NotNull Function0<Unit> block) {
        int $i$f$withDebugProbes = 0;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        this.install();
        try {
            block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.uninstall();
            InlineMarker.finallyEnd((int)1);
        }
    }

    @NotNull
    public final String jobToString(@NotNull Job job) {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        return DebugProbesImpl.INSTANCE.hierarchyToString(job);
    }

    @NotNull
    public final String scopeToString(@NotNull CoroutineScope scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        DebugProbes debugProbes = this;
        Job job = (Job)scope.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
        if (job == null) {
            String string = "Job is not present in the scope";
            DebugProbes debugProbes2 = debugProbes;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return debugProbes.jobToString(job);
    }

    public final void printJob(@NotNull Job job, @NotNull PrintStream out) {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        out.println(DebugProbesImpl.INSTANCE.hierarchyToString(job));
    }

    public static /* synthetic */ void printJob$default(DebugProbes debugProbes, Job job, PrintStream printStream, int n, Object object) {
        if ((n & 2) != 0) {
            PrintStream printStream2 = System.out;
            Intrinsics.checkExpressionValueIsNotNull((Object)printStream2, (String)"System.out");
            printStream = printStream2;
        }
        debugProbes.printJob(job, printStream);
    }

    public final void printScope(@NotNull CoroutineScope scope, @NotNull PrintStream out) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        DebugProbes debugProbes = this;
        Job job = (Job)scope.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
        if (job == null) {
            String string = "Job is not present in the scope";
            DebugProbes debugProbes2 = debugProbes;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        debugProbes.printJob(job, out);
    }

    public static /* synthetic */ void printScope$default(DebugProbes debugProbes, CoroutineScope coroutineScope, PrintStream printStream, int n, Object object) {
        if ((n & 2) != 0) {
            PrintStream printStream2 = System.out;
            Intrinsics.checkExpressionValueIsNotNull((Object)printStream2, (String)"System.out");
            printStream = printStream2;
        }
        debugProbes.printScope(coroutineScope, printStream);
    }

    @NotNull
    public final List<CoroutineInfo> dumpCoroutinesInfo() {
        return DebugProbesImpl.INSTANCE.dumpCoroutinesInfo();
    }

    public final void dumpCoroutines(@NotNull PrintStream out) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        DebugProbesImpl.INSTANCE.dumpCoroutines(out);
    }

    public static /* synthetic */ void dumpCoroutines$default(DebugProbes debugProbes, PrintStream printStream, int n, Object object) {
        if ((n & 1) != 0) {
            PrintStream printStream2 = System.out;
            Intrinsics.checkExpressionValueIsNotNull((Object)printStream2, (String)"System.out");
            printStream = printStream2;
        }
        debugProbes.dumpCoroutines(printStream);
    }

    private DebugProbes() {
    }

    static {
        DebugProbes debugProbes;
        INSTANCE = debugProbes = new DebugProbes();
        sanitizeStackTraces = true;
    }
}

