/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.debug.internal;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.jvm.internal.CoroutineStackFrame;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobSupport;
import kotlinx.coroutines.debug.CoroutineInfo;
import kotlinx.coroutines.debug.DebugProbes;
import kotlinx.coroutines.debug.State;
import kotlinx.coroutines.debug.internal.DebugProbesImpl;
import kotlinx.coroutines.internal.ScopeCoroutine;
import kotlinx.coroutines.internal.StackTraceRecoveryKt;
import kotlinx.coroutines.repackaged.net.bytebuddy.ByteBuddy;
import kotlinx.coroutines.repackaged.net.bytebuddy.agent.ByteBuddyAgent;
import kotlinx.coroutines.repackaged.net.bytebuddy.dynamic.DynamicType;
import kotlinx.coroutines.repackaged.net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0010\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001TB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H!0 \"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0 2\u0006\u0010#\u001a\u00020\u0007H\u0002J\b\u0010$\u001a\u00020\u0004H\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0)J$\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001d0)2\u0006\u0010+\u001a\u00020\b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001d0)H\u0002J=\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00120.2\u0006\u0010/\u001a\u00020\u00102\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001d012\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001d0)H\u0002\u00a2\u0006\u0002\u00102J1\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u00020\u00102\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001d012\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001d0)H\u0002\u00a2\u0006\u0002\u00105J\u000e\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0017J\u0006\u00108\u001a\u00020%J\u0014\u00109\u001a\u00020%2\n\u0010:\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J'\u0010;\u001a\b\u0012\u0004\u0012\u0002H!0 \"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0 H\u0000\u00a2\u0006\u0002\b<J\u0019\u0010=\u001a\u00020%2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030 H\u0000\u00a2\u0006\u0002\b>J\u0019\u0010?\u001a\u00020%2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030 H\u0000\u00a2\u0006\u0002\b@J%\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001d0)\"\b\b\u0000\u0010!*\u00020B2\u0006\u0010C\u001a\u0002H!H\u0002\u00a2\u0006\u0002\u0010DJ\u0006\u0010E\u001a\u00020%J\u0018\u0010F\u001a\u00020%2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010G\u001a\u00020HH\u0002J\u001c\u0010I\u001a\u00020%2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010G\u001a\u00020HH\u0002J(\u0010I\u001a\u00020%2\n\u0010:\u001a\u0006\u0012\u0002\b\u00030\f2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010G\u001a\u00020HH\u0002J4\u0010J\u001a\u00020%*\u00020\u00172\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\b0L2\n\u0010M\u001a\u00060Nj\u0002`O2\u0006\u0010P\u001a\u00020\u0004H\u0002J\u0016\u0010:\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f*\u0006\u0012\u0002\b\u00030 H\u0002J\u0013\u0010:\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f*\u00020\u0007H\u0082\u0010J\u001e\u0010Q\u001a\u00020%*\u00060Nj\u0002`O2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u001d0)H\u0002J\u000f\u0010S\u001a\u0004\u0018\u00010\u0007*\u00020\u0007H\u0082\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u0004*\u00020\u00178BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\u00020\u0012*\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006U"}, d2={"Lkotlinx/coroutines/debug/internal/DebugProbesImpl;", "", "()V", "ARTIFICIAL_FRAME_MESSAGE", "", "callerInfoCache", "Ljava/util/HashMap;", "Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;", "Lkotlinx/coroutines/debug/CoroutineInfo;", "Lkotlin/collections/HashMap;", "capturedCoroutines", "Ljava/util/HashSet;", "Lkotlinx/coroutines/debug/internal/DebugProbesImpl$CoroutineOwner;", "dateFormat", "Ljava/text/SimpleDateFormat;", "installations", "", "isInstalled", "", "()Z", "sequenceNumber", "", "debugString", "Lkotlinx/coroutines/Job;", "debugString$annotations", "(Lkotlinx/coroutines/Job;)V", "getDebugString", "(Lkotlinx/coroutines/Job;)Ljava/lang/String;", "isInternalMethod", "Ljava/lang/StackTraceElement;", "(Ljava/lang/StackTraceElement;)Z", "createOwner", "Lkotlin/coroutines/Continuation;", "T", "completion", "frame", "dumpCoroutines", "", "out", "Ljava/io/PrintStream;", "dumpCoroutinesInfo", "", "enhanceStackTraceWithThreadDump", "info", "coroutineTrace", "findContinuationStartIndex", "Lkotlin/Pair;", "indexOfResumeWith", "actualTrace", "", "(I[Ljava/lang/StackTraceElement;Ljava/util/List;)Lkotlin/Pair;", "findIndexOfFrame", "frameIndex", "(I[Ljava/lang/StackTraceElement;Ljava/util/List;)I", "hierarchyToString", "job", "install", "probeCoroutineCompleted", "owner", "probeCoroutineCreated", "probeCoroutineCreated$kotlinx_coroutines_debug", "probeCoroutineResumed", "probeCoroutineResumed$kotlinx_coroutines_debug", "probeCoroutineSuspended", "probeCoroutineSuspended$kotlinx_coroutines_debug", "sanitizeStackTrace", "", "throwable", "(Ljava/lang/Throwable;)Ljava/util/List;", "uninstall", "updateRunningState", "state", "Lkotlinx/coroutines/debug/State;", "updateState", "build", "map", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "printStackTrace", "frames", "realCaller", "CoroutineOwner", "kotlinx-coroutines-debug"})
public final class DebugProbesImpl {
    private static final String ARTIFICIAL_FRAME_MESSAGE = "Coroutine creation stacktrace";
    private static final SimpleDateFormat dateFormat;
    private static final HashSet<CoroutineOwner<?>> capturedCoroutines;
    private static volatile int installations;
    private static long sequenceNumber;
    private static final HashMap<CoroutineStackFrame, CoroutineInfo> callerInfoCache;
    public static final DebugProbesImpl INSTANCE;

    private final boolean isInstalled() {
        return installations > 0;
    }

    public final synchronized void install() {
        if (++installations > 1) {
            return;
        }
        ByteBuddyAgent.install();
        Class<?> cl = Class.forName("kotlin.coroutines.jvm.internal.DebugProbesKt");
        Class<?> cl2 = Class.forName("kotlinx.coroutines.debug.DebugProbesKt");
        DynamicType.Builder<?> builder = new ByteBuddy().redefine(cl2);
        Class<?> clazz = cl;
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"cl");
        builder.name(clazz.getName()).make().load(cl.getClassLoader(), ClassReloadingStrategy.fromInstalledAgent());
    }

    public final synchronized void uninstall() {
        boolean bl = this.isInstalled();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Agent was not installed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if ((installations += -1) != 0) {
            return;
        }
        capturedCoroutines.clear();
        callerInfoCache.clear();
        Class<?> cl = Class.forName("kotlin.coroutines.jvm.internal.DebugProbesKt");
        Class<?> cl2 = Class.forName("kotlinx.coroutines.debug.internal.NoOpProbesKt");
        DynamicType.Builder<?> builder = new ByteBuddy().redefine(cl2);
        Class<?> clazz = cl;
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"cl");
        builder.name(clazz.getName()).make().load(cl.getClassLoader(), ClassReloadingStrategy.fromInstalledAgent());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized String hierarchyToString(@NotNull Job job) {
        void $this$associateByTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        boolean bl = this.isInstalled();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Debug probes are not installed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Iterable $this$filter$iv = capturedCoroutines;
        boolean $i$f$filter = false;
        Iterable bl4 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CoroutineOwner it = (CoroutineOwner)element$iv$iv;
            boolean bl5 = false;
            if (!(it.delegate.getContext().get((CoroutineContext.Key)Job.Key) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            CoroutineOwner it;
            CoroutineOwner bl5 = (CoroutineOwner)element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl6 = false;
            CoroutineContext.Element element = it.delegate.getContext().get((CoroutineContext.Key)Job.Key);
            if (element == null) {
                Intrinsics.throwNpe();
            }
            Job job2 = (Job)element;
            it = (CoroutineOwner)element$iv$iv;
            boolean bl7 = false;
            CoroutineInfo coroutineInfo = it.info;
            map.put(job2, coroutineInfo);
        }
        Map jobToStack = destination$iv$iv2;
        boolean bl8 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl9 = false;
        boolean bl10 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl11 = false;
        INSTANCE.build(job, jobToStack, $this$buildString, "");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void build(@NotNull Job $this$build, Map<Job, CoroutineInfo> map, StringBuilder builder, String indent) {
        CoroutineInfo info = map.get($this$build);
        String newIndent = null;
        if (info == null) {
            if (!($this$build instanceof ScopeCoroutine)) {
                builder.append(indent + this.getDebugString($this$build) + '\n');
                newIndent = indent + "\t";
            } else {
                newIndent = indent;
            }
        } else {
            StackTraceElement element = (StackTraceElement)CollectionsKt.firstOrNull(info.lastObservedStackTrace());
            State state = info.getState();
            builder.append(indent + this.getDebugString($this$build) + ", continuation is " + (Object)((Object)state) + " at line " + element + '\n');
            newIndent = indent + "\t";
        }
        for (Job child : $this$build.getChildren()) {
            this.build(child, map, builder, newIndent);
        }
    }

    private static /* synthetic */ void debugString$annotations(Job job) {
    }

    private final String getDebugString(@NotNull Job $this$debugString) {
        return $this$debugString instanceof JobSupport ? ((JobSupport)$this$debugString).toDebugString() : $this$debugString.toString();
    }

    @NotNull
    public final synchronized List<CoroutineInfo> dumpCoroutinesInfo() {
        boolean bl = this.isInstalled();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Debug probes are not installed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Sequence $this$sortedBy$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)capturedCoroutines), (Function1)dumpCoroutinesInfo.2.INSTANCE);
        boolean $i$f$sortedBy = false;
        Sequence sequence = $this$sortedBy$iv;
        boolean bl5 = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                CoroutineInfo it = (CoroutineInfo)a;
                boolean bl2 = false;
                it = (CoroutineInfo)b;
                Comparable comparable = Long.valueOf(it.sequenceNumber);
                bl2 = false;
                Long l = it.sequenceNumber;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)l);
            }
        };
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)sequence, (Comparator)comparator));
    }

    public final void dumpCoroutines(@NotNull PrintStream out) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        String string = this.dumpCoroutines();
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        out.println(it);
    }

    private final synchronized String dumpCoroutines() {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        boolean bl5 = INSTANCE.isInstalled();
        boolean bl6 = false;
        boolean bl7 = false;
        if (!bl5) {
            boolean bl8 = false;
            String string = "Debug probes are not installed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        $this$buildString.append("Coroutines dump " + dateFormat.format(System.currentTimeMillis()));
        Sequence $this$sortedBy$iv = CollectionsKt.asSequence((Iterable)capturedCoroutines);
        boolean $i$f$sortedBy = false;
        Sequence sequence = $this$sortedBy$iv;
        boolean bl8 = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                CoroutineOwner it = (CoroutineOwner)a;
                boolean bl2 = false;
                it = (CoroutineOwner)b;
                Comparable comparable = Long.valueOf(it.info.sequenceNumber);
                bl2 = false;
                Long l = it.info.sequenceNumber;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)l);
            }
        };
        Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)sequence, (Comparator)comparator);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CoroutineOwner owner = (CoroutineOwner)element$iv;
            boolean bl9 = false;
            CoroutineInfo info = owner.info;
            List<StackTraceElement> observedStackTrace = info.lastObservedStackTrace();
            List<StackTraceElement> enhancedStackTrace = INSTANCE.enhanceStackTraceWithThreadDump(info, observedStackTrace);
            String state = info.getState() == State.RUNNING && enhancedStackTrace == observedStackTrace ? (Object)((Object)info.getState()) + " (Last suspension stacktrace, not an actual stacktrace)" : info.getState().toString();
            $this$buildString.append("\n\nCoroutine " + owner.delegate + ", state: " + state);
            if (observedStackTrace.isEmpty()) {
                $this$buildString.append("\n\tat " + StackTraceRecoveryKt.artificialFrame((String)ARTIFICIAL_FRAME_MESSAGE));
                INSTANCE.printStackTrace($this$buildString, info.getCreationStackTrace());
                continue;
            }
            INSTANCE.printStackTrace($this$buildString, enhancedStackTrace);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<StackTraceElement> enhanceStackTraceWithThreadDump(CoroutineInfo info, List<StackTraceElement> coroutineTrace) {
        boolean bl;
        StackTraceElement stackTraceElement;
        void index;
        Collection collection;
        void continuationStartFrame;
        int n;
        int n2;
        StackTraceElement[] actualTrace;
        block9: {
            Object object;
            Thread thread = info.lastObservedThread;
            if (info.getState() != State.RUNNING || thread == null) {
                return coroutineTrace;
            }
            Object object2 = this;
            boolean bl2 = false;
            try {
                object = Result.Companion;
                Object $this$runCatching = object2;
                boolean bl3 = false;
                $this$runCatching = thread.getStackTrace();
                bl3 = false;
                object = Result.constructor-impl((Object)$this$runCatching);
            }
            catch (Throwable $this$runCatching) {
                Result.Companion bl3 = Result.Companion;
                boolean bl4 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
            }
            object2 = object;
            bl2 = false;
            StackTraceElement[] stackTraceElementArray = (StackTraceElement[])(Result.isFailure-impl((Object)object2) ? null : object2);
            if (stackTraceElementArray == null) {
                return coroutineTrace;
            }
            StackTraceElement[] $this$indexOfFirst$iv = actualTrace = stackTraceElementArray;
            boolean $i$f$indexOfFirst = false;
            int $this$runCatching = 0;
            int bl3 = $this$indexOfFirst$iv.length;
            while ($this$runCatching < bl3) {
                void index$iv;
                StackTraceElement it = $this$indexOfFirst$iv[index$iv];
                n2 = 0;
                StackTraceElement stackTraceElement2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement2, (String)"it");
                if (Intrinsics.areEqual((Object)stackTraceElement2.getClassName(), (Object)"kotlin.coroutines.jvm.internal.BaseContinuationImpl") && Intrinsics.areEqual((Object)it.getMethodName(), (Object)"resumeWith") && Intrinsics.areEqual((Object)it.getFileName(), (Object)"ContinuationImpl.kt")) {
                    n = index$iv;
                    break block9;
                }
                ++index$iv;
            }
            n = -1;
        }
        int indexOfResumeWith = n;
        Pair<Integer, Boolean> index$iv = super.findContinuationStartIndex(indexOfResumeWith, actualTrace, coroutineTrace);
        int $this$indexOfFirst$iv = ((Number)index$iv.component1()).intValue();
        boolean frameSkipped = (Boolean)index$iv.component2();
        if (continuationStartFrame == -1) {
            return coroutineTrace;
        }
        int delta = frameSkipped ? 1 : 0;
        int expectedSize = indexOfResumeWith + coroutineTrace.size() - continuationStartFrame - 1 - delta;
        ArrayList result = new ArrayList(expectedSize);
        n2 = 0;
        int n3 = indexOfResumeWith - delta;
        while (n2 < n3) {
            collection = result;
            stackTraceElement = actualTrace[index];
            bl = false;
            collection.add(stackTraceElement);
            ++index;
        }
        n3 = coroutineTrace.size();
        for (index = continuationStartFrame + true; index < n3; ++index) {
            collection = result;
            stackTraceElement = coroutineTrace.get((int)index);
            bl = false;
            collection.add(stackTraceElement);
        }
        return result;
    }

    private final Pair<Integer, Boolean> findContinuationStartIndex(int indexOfResumeWith, StackTraceElement[] actualTrace, List<StackTraceElement> coroutineTrace) {
        int result = this.findIndexOfFrame(indexOfResumeWith - 1, actualTrace, coroutineTrace);
        if (result == -1) {
            return TuplesKt.to((Object)this.findIndexOfFrame(indexOfResumeWith - 2, actualTrace, coroutineTrace), (Object)true);
        }
        return TuplesKt.to((Object)result, (Object)false);
    }

    private final int findIndexOfFrame(int frameIndex, StackTraceElement[] actualTrace, List<StackTraceElement> coroutineTrace) {
        int n;
        block3: {
            StackTraceElement stackTraceElement = (StackTraceElement)ArraysKt.getOrNull((Object[])actualTrace, (int)frameIndex);
            if (stackTraceElement == null) {
                return -1;
            }
            StackTraceElement continuationFrame = stackTraceElement;
            List<StackTraceElement> $this$indexOfFirst$iv = coroutineTrace;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<StackTraceElement> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                StackTraceElement item$iv;
                StackTraceElement it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getFileName(), (Object)continuationFrame.getFileName()) && Intrinsics.areEqual((Object)it.getClassName(), (Object)continuationFrame.getClassName()) && Intrinsics.areEqual((Object)it.getMethodName(), (Object)continuationFrame.getMethodName())) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    private final void printStackTrace(@NotNull StringBuilder $this$printStackTrace, List<StackTraceElement> frames) {
        Iterable $this$forEach$iv = frames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StackTraceElement frame2 = (StackTraceElement)element$iv;
            boolean bl = false;
            $this$printStackTrace.append("\n\tat " + frame2);
        }
    }

    public final void probeCoroutineResumed$kotlinx_coroutines_debug(@NotNull Continuation<?> frame2) {
        Intrinsics.checkParameterIsNotNull(frame2, (String)"frame");
        this.updateState(frame2, State.RUNNING);
    }

    public final void probeCoroutineSuspended$kotlinx_coroutines_debug(@NotNull Continuation<?> frame2) {
        Intrinsics.checkParameterIsNotNull(frame2, (String)"frame");
        this.updateState(frame2, State.SUSPENDED);
    }

    private final void updateState(Continuation<?> frame2, State state) {
        if (state == State.RUNNING && KotlinVersion.CURRENT.isAtLeast(1, 3, 30)) {
            Continuation<?> continuation = frame2;
            if (!(continuation instanceof CoroutineStackFrame)) {
                continuation = null;
            }
            CoroutineStackFrame coroutineStackFrame = (CoroutineStackFrame)continuation;
            if (coroutineStackFrame == null) {
                return;
            }
            CoroutineStackFrame stackFrame = coroutineStackFrame;
            this.updateRunningState(stackFrame, state);
            return;
        }
        CoroutineOwner<?> coroutineOwner = this.owner(frame2);
        if (coroutineOwner == null) {
            return;
        }
        CoroutineOwner<?> owner = coroutineOwner;
        this.updateState(owner, frame2, state);
    }

    private final synchronized void updateRunningState(CoroutineStackFrame frame2, State state) {
        if (!this.isInstalled()) {
            return;
        }
        Object info = null;
        CoroutineInfo cached = callerInfoCache.remove(frame2);
        if (cached != null) {
            info = cached;
        } else {
            CoroutineOwner<?> coroutineOwner = this.owner(frame2);
            if (coroutineOwner == null || (coroutineOwner = coroutineOwner.info) == null) {
                return;
            }
            info = coroutineOwner;
            Map map = callerInfoCache;
            CoroutineStackFrame coroutineStackFrame = ((CoroutineInfo)info).lastObservedFrame;
            CoroutineStackFrame coroutineStackFrame2 = coroutineStackFrame != null ? this.realCaller(coroutineStackFrame) : null;
            boolean bl = false;
            Map map2 = map;
            if (map2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
            }
            TypeIntrinsics.asMutableMap((Object)map2).remove(coroutineStackFrame2);
        }
        CoroutineStackFrame coroutineStackFrame = frame2;
        if (coroutineStackFrame == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.coroutines.Continuation<*>");
        }
        ((CoroutineInfo)info).updateState$kotlinx_coroutines_debug(state, (Continuation)coroutineStackFrame);
        CoroutineStackFrame coroutineStackFrame3 = this.realCaller(frame2);
        if (coroutineStackFrame3 == null) {
            return;
        }
        CoroutineStackFrame caller = coroutineStackFrame3;
        ((Map)callerInfoCache).put(caller, info);
    }

    private final CoroutineStackFrame realCaller(@NotNull CoroutineStackFrame $this$realCaller) {
        CoroutineStackFrame caller;
        while (true) {
            if ($this$realCaller.getCallerFrame() == null) {
                return null;
            }
            if (caller.getStackTraceElement() != null) break;
            $this$realCaller = caller;
        }
        return caller;
    }

    private final synchronized void updateState(CoroutineOwner<?> owner, Continuation<?> frame2, State state) {
        if (!this.isInstalled()) {
            return;
        }
        owner.info.updateState$kotlinx_coroutines_debug(state, frame2);
    }

    private final CoroutineOwner<?> owner(@NotNull Continuation<?> $this$owner) {
        Continuation<?> continuation = $this$owner;
        if (!(continuation instanceof CoroutineStackFrame)) {
            continuation = null;
        }
        CoroutineStackFrame coroutineStackFrame = (CoroutineStackFrame)continuation;
        return coroutineStackFrame != null ? this.owner(coroutineStackFrame) : null;
    }

    private final CoroutineOwner<?> owner(@NotNull CoroutineStackFrame $this$owner) {
        CoroutineOwner coroutineOwner;
        block2: {
            while (true) {
                if ($this$owner instanceof CoroutineOwner) {
                    coroutineOwner = (CoroutineOwner)$this$owner;
                    break block2;
                }
                if ($this$owner.getCallerFrame() == null) break;
            }
            coroutineOwner = null;
        }
        return coroutineOwner;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> Continuation<T> probeCoroutineCreated$kotlinx_coroutines_debug(@NotNull Continuation<? super T> completion) {
        void $this$foldRight$iv;
        List<StackTraceElement> stacktrace;
        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
        if (!this.isInstalled()) {
            return completion;
        }
        CoroutineOwner<?> owner = this.owner(completion);
        if (owner != null) {
            return completion;
        }
        List<StackTraceElement> list = stacktrace = this.sanitizeStackTrace((Throwable)new Exception());
        CoroutineStackFrame initial$iv = null;
        boolean $i$f$foldRight = false;
        CoroutineStackFrame accumulator$iv = initial$iv;
        if (!$this$foldRight$iv.isEmpty()) {
            ListIterator iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
            while (iterator$iv.hasPrevious()) {
                void acc;
                CoroutineStackFrame coroutineStackFrame = accumulator$iv;
                StackTraceElement frame2 = (StackTraceElement)iterator$iv.previous();
                boolean bl = false;
                accumulator$iv = new CoroutineStackFrame(frame2, (CoroutineStackFrame)acc){
                    @Nullable
                    private final CoroutineStackFrame callerFrame;
                    final /* synthetic */ StackTraceElement $frame;
                    final /* synthetic */ CoroutineStackFrame $acc;

                    @Nullable
                    public CoroutineStackFrame getCallerFrame() {
                        return this.callerFrame;
                    }

                    @NotNull
                    public StackTraceElement getStackTraceElement() {
                        return this.$frame;
                    }
                    {
                        this.$frame = $captured_local_variable$0;
                        this.$acc = $captured_local_variable$1;
                        this.callerFrame = $captured_local_variable$1;
                    }
                };
            }
        }
        CoroutineStackFrame coroutineStackFrame = accumulator$iv;
        if (coroutineStackFrame == null) {
            Intrinsics.throwNpe();
        }
        CoroutineStackFrame frame3 = coroutineStackFrame;
        return this.createOwner(completion, frame3);
    }

    private final synchronized <T> Continuation<T> createOwner(Continuation<? super T> completion, CoroutineStackFrame frame2) {
        if (!this.isInstalled()) {
            return completion;
        }
        CoroutineInfo info = new CoroutineInfo(completion.getContext(), frame2, ++sequenceNumber);
        CoroutineOwner<? super T> owner = new CoroutineOwner<T>(completion, info, frame2);
        Collection collection = capturedCoroutines;
        boolean bl = false;
        collection.add(owner);
        return owner;
    }

    private final synchronized void probeCoroutineCompleted(CoroutineOwner<?> owner) {
        capturedCoroutines.remove(owner);
        CoroutineStackFrame coroutineStackFrame = owner.info.lastObservedFrame;
        CoroutineStackFrame caller = coroutineStackFrame != null ? this.realCaller(coroutineStackFrame) : null;
        Map map = callerInfoCache;
        boolean bl = false;
        Map map2 = map;
        if (map2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
        }
        TypeIntrinsics.asMutableMap((Object)map2).remove(caller);
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends Throwable> List<StackTraceElement> sanitizeStackTrace(T throwable) {
        int probeIndex;
        int index$iv222;
        int n;
        boolean $i$f$indexOfLast2;
        int size;
        StackTraceElement[] stackTrace;
        block10: {
            int n2;
            stackTrace = throwable.getStackTrace();
            size = stackTrace.length;
            Intrinsics.checkExpressionValueIsNotNull((Object)stackTrace, (String)"stackTrace");
            StackTraceElement[] $this$indexOfLast$iv = stackTrace;
            $i$f$indexOfLast2 = false;
            int n3 = $this$indexOfLast$iv.length;
            --n3;
            n = 0;
            while (n3 >= 0) {
                StackTraceElement it = $this$indexOfLast$iv[index$iv222];
                boolean bl = false;
                StackTraceElement stackTraceElement = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement, (String)"it");
                if (Intrinsics.areEqual((Object)stackTraceElement.getClassName(), (Object)"kotlin.coroutines.jvm.internal.DebugProbesKt")) {
                    n2 = index$iv222;
                    break block10;
                }
                --index$iv222;
            }
            n2 = probeIndex = -1;
        }
        if (!DebugProbes.INSTANCE.getSanitizeStackTraces()) {
            int $this$indexOfLast$iv = size - probeIndex;
            $i$f$indexOfLast2 = false;
            index$iv222 = 0;
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>($this$indexOfLast$iv);
            boolean it = false;
            int n4 = 0;
            int n5 = $this$indexOfLast$iv;
            for (n4 = 0; n4 < n5; ++n4) {
                void it2;
                int n6 = n4;
                boolean bl = false;
                int n7 = n6;
                ArrayList<StackTraceElement> arrayList2 = arrayList;
                boolean bl2 = false;
                StackTraceElement stackTraceElement = it2 == false ? StackTraceRecoveryKt.artificialFrame((String)ARTIFICIAL_FRAME_MESSAGE) : stackTrace[it2 + probeIndex];
                arrayList2.add(stackTraceElement);
            }
            return arrayList;
        }
        ArrayList result = new ArrayList(size - probeIndex + 1);
        Collection $i$f$indexOfLast2 = result;
        StackTraceElement index$iv222 = StackTraceRecoveryKt.artificialFrame((String)ARTIFICIAL_FRAME_MESSAGE);
        n = 0;
        $i$f$indexOfLast2.add(index$iv222);
        boolean includeInternalFrame = true;
        int index$iv222 = probeIndex + 1;
        n = size - 1;
        while (index$iv222 < n) {
            boolean bl;
            void i;
            StackTraceElement element;
            StackTraceElement stackTraceElement = element = stackTrace[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement, (String)"element");
            if (!this.isInternalMethod(stackTraceElement)) {
                includeInternalFrame = true;
                Collection collection = result;
                bl = false;
                collection.add(element);
            } else if (includeInternalFrame) {
                Collection collection = result;
                bl = false;
                collection.add(element);
                includeInternalFrame = false;
            } else {
                StackTraceElement stackTraceElement2 = stackTrace[i + true];
                Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement2, (String)"stackTrace[i + 1]");
                if (!this.isInternalMethod(stackTraceElement2)) {
                    Collection collection = result;
                    bl = false;
                    collection.add(element);
                    includeInternalFrame = true;
                }
            }
            ++i;
        }
        Collection collection = result;
        StackTraceElement stackTraceElement = stackTrace[size - 1];
        boolean bl = false;
        collection.add(stackTraceElement);
        return result;
    }

    private final boolean isInternalMethod(@NotNull StackTraceElement $this$isInternalMethod) {
        String string = $this$isInternalMethod.getClassName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className");
        return StringsKt.startsWith$default((String)string, (String)"kotlinx.coroutines", (boolean)false, (int)2, null);
    }

    private DebugProbesImpl() {
    }

    static {
        DebugProbesImpl debugProbesImpl;
        INSTANCE = debugProbesImpl = new DebugProbesImpl();
        dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        capturedCoroutines = new HashSet();
        callerInfoCache = new HashMap();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0001J\u001e\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00028\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lkotlinx/coroutines/debug/internal/DebugProbesImpl$CoroutineOwner;", "T", "Lkotlin/coroutines/Continuation;", "Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;", "delegate", "info", "Lkotlinx/coroutines/debug/CoroutineInfo;", "frame", "(Lkotlin/coroutines/Continuation;Lkotlinx/coroutines/debug/CoroutineInfo;Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;)V", "callerFrame", "getCallerFrame", "()Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;", "context", "Lkotlin/coroutines/CoroutineContext;", "getContext", "()Lkotlin/coroutines/CoroutineContext;", "getStackTraceElement", "Ljava/lang/StackTraceElement;", "resumeWith", "", "result", "Lkotlin/Result;", "(Ljava/lang/Object;)V", "toString", "", "kotlinx-coroutines-debug"})
    private static final class CoroutineOwner<T>
    implements Continuation<T>,
    CoroutineStackFrame {
        @JvmField
        @NotNull
        public final Continuation<T> delegate;
        @JvmField
        @NotNull
        public final CoroutineInfo info;
        private final /* synthetic */ CoroutineStackFrame $$delegate_1;

        public void resumeWith(@NotNull Object result) {
            INSTANCE.probeCoroutineCompleted(this);
            this.delegate.resumeWith(result);
        }

        @NotNull
        public String toString() {
            return this.delegate.toString();
        }

        public CoroutineOwner(@NotNull Continuation<? super T> delegate, @NotNull CoroutineInfo info, @NotNull CoroutineStackFrame frame2) {
            Intrinsics.checkParameterIsNotNull(delegate, (String)"delegate");
            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
            Intrinsics.checkParameterIsNotNull((Object)frame2, (String)"frame");
            this.$$delegate_1 = frame2;
            this.delegate = delegate;
            this.info = info;
        }

        @NotNull
        public CoroutineContext getContext() {
            return this.delegate.getContext();
        }

        @Nullable
        public CoroutineStackFrame getCallerFrame() {
            return this.$$delegate_1.getCallerFrame();
        }

        @Nullable
        public StackTraceElement getStackTraceElement() {
            return this.$$delegate_1.getStackTraceElement();
        }
    }
}

