/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.debug.junit4;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.debug.CoroutineInfo;
import kotlinx.coroutines.debug.DebugProbes;
import org.jetbrains.annotations.NotNull;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestTimedOutException;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0011\u001a\u00020\fH\u0002J\u0014\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\b\u0010\u0016\u001a\u00020\fH\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkotlinx/coroutines/debug/junit4/CoroutinesTimeoutStatement;", "Lorg/junit/runners/model/Statement;", "testStatement", "testDescription", "Lorg/junit/runner/Description;", "testTimeoutMs", "", "cancelOnTimeout", "", "(Lorg/junit/runners/model/Statement;Lorg/junit/runner/Description;JZ)V", "testResult", "Ljava/util/concurrent/FutureTask;", "", "testStartedLatch", "Ljava/util/concurrent/CountDownLatch;", "testThread", "Ljava/lang/Thread;", "cancelIfNecessary", "createTimeoutException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "thread", "evaluate", "handleTimeout", "description", "kotlinx-coroutines-debug"})
public final class CoroutinesTimeoutStatement
extends Statement {
    private final CountDownLatch testStartedLatch;
    private final FutureTask<Unit> testResult;
    private final Thread testThread;
    private final Description testDescription;
    private final long testTimeoutMs;
    private final boolean cancelOnTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() {
        DebugProbes.INSTANCE.install();
        this.testThread.start();
        this.testStartedLatch.await();
        try {
            this.testResult.get(this.testTimeoutMs, TimeUnit.MILLISECONDS);
            return;
        }
        catch (TimeoutException e) {
            this.handleTimeout(this.testDescription);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
        finally {
            DebugProbes.INSTANCE.uninstall();
        }
    }

    private final void handleTimeout(Description description) {
        String units = this.testTimeoutMs % (long)1000 == 0L ? this.testTimeoutMs / (long)1000 + " seconds" : this.testTimeoutMs + " milliseconds";
        System.err.println("\nTest " + description.getMethodName() + " timed out after " + units + '\n');
        System.err.flush();
        DebugProbes.dumpCoroutines$default(DebugProbes.INSTANCE, null, 1, null);
        System.out.flush();
        Exception exception = this.createTimeoutException(this.testThread);
        this.cancelIfNecessary();
        throw (Throwable)exception;
    }

    private final void cancelIfNecessary() {
        if (this.cancelOnTimeout) {
            Iterable $this$forEach$iv = DebugProbes.INSTANCE.dumpCoroutinesInfo();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CoroutineInfo it = (CoroutineInfo)element$iv;
                boolean bl = false;
                Job job = it.getJob();
                if (job != null) {
                    Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                }
            }
        }
    }

    private final Exception createTimeoutException(Thread thread) {
        StackTraceElement[] stackTrace = thread.getStackTrace();
        TestTimedOutException exception = new TestTimedOutException(this.testTimeoutMs, TimeUnit.MILLISECONDS);
        exception.setStackTrace(stackTrace);
        thread.interrupt();
        return (Exception)exception;
    }

    public CoroutinesTimeoutStatement(@NotNull Statement testStatement, @NotNull Description testDescription, long testTimeoutMs, boolean cancelOnTimeout) {
        Thread thread;
        Intrinsics.checkParameterIsNotNull((Object)testStatement, (String)"testStatement");
        Intrinsics.checkParameterIsNotNull((Object)testDescription, (String)"testDescription");
        this.testDescription = testDescription;
        this.testTimeoutMs = testTimeoutMs;
        this.cancelOnTimeout = cancelOnTimeout;
        this.testStartedLatch = new CountDownLatch(1);
        this.testResult = new FutureTask(new Callable<V>(this, testStatement){
            final /* synthetic */ CoroutinesTimeoutStatement this$0;
            final /* synthetic */ Statement $testStatement;

            public final void call() {
                CoroutinesTimeoutStatement.access$getTestStartedLatch$p(this.this$0).countDown();
                this.$testStatement.evaluate();
            }
            {
                this.this$0 = coroutinesTimeoutStatement;
                this.$testStatement = statement;
            }
        });
        Thread thread2 = new Thread((Runnable)this.testResult, "Timeout test thread");
        CoroutinesTimeoutStatement coroutinesTimeoutStatement = this;
        boolean bl = false;
        boolean bl2 = false;
        Thread $this$apply = thread2;
        boolean bl3 = false;
        $this$apply.setDaemon(true);
        coroutinesTimeoutStatement.testThread = thread = thread2;
    }

    public /* synthetic */ CoroutinesTimeoutStatement(Statement statement, Description description, long l, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(statement, description, l, bl);
    }

    public static final /* synthetic */ CountDownLatch access$getTestStartedLatch$p(CoroutinesTimeoutStatement $this) {
        return $this.testStartedLatch;
    }
}

