/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.debug;

import java.io.PrintStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.debug.CoroutineInfo;
import kotlinx.coroutines.debug.internal.DebugProbesImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001e\u001a\u00020\u000eJ\u0017\u0010\u001f\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0!H\u0086\bR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u001a\u0010\n\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0006\"\u0004\b\f\u0010\b\u00a8\u0006\""}, d2={"Lkotlinx/coroutines/debug/DebugProbes;", "", "()V", "enableCreationStackTraces", "", "getEnableCreationStackTraces", "()Z", "setEnableCreationStackTraces", "(Z)V", "isInstalled", "sanitizeStackTraces", "getSanitizeStackTraces", "setSanitizeStackTraces", "dumpCoroutines", "", "out", "Ljava/io/PrintStream;", "dumpCoroutinesInfo", "", "Lkotlinx/coroutines/debug/CoroutineInfo;", "install", "jobToString", "", "job", "Lkotlinx/coroutines/Job;", "printJob", "printScope", "scope", "Lkotlinx/coroutines/CoroutineScope;", "scopeToString", "uninstall", "withDebugProbes", "block", "Lkotlin/Function0;", "kotlinx-coroutines-debug"})
@ExperimentalCoroutinesApi
public final class DebugProbes {
    private static boolean sanitizeStackTraces;
    private static boolean enableCreationStackTraces;
    public static final DebugProbes INSTANCE;

    public final boolean getSanitizeStackTraces() {
        return sanitizeStackTraces;
    }

    public final void setSanitizeStackTraces(boolean bl) {
        sanitizeStackTraces = bl;
    }

    public final boolean getEnableCreationStackTraces() {
        return enableCreationStackTraces;
    }

    public final void setEnableCreationStackTraces(boolean bl) {
        enableCreationStackTraces = bl;
    }

    public final boolean isInstalled() {
        return DebugProbesImpl.INSTANCE.isInstalled$kotlinx_coroutines_debug();
    }

    public final void install() {
        DebugProbesImpl.INSTANCE.install();
    }

    public final void uninstall() {
        DebugProbesImpl.INSTANCE.uninstall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void withDebugProbes(@NotNull Function0<Unit> block) {
        int $i$f$withDebugProbes = 0;
        this.install();
        try {
            block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.uninstall();
            InlineMarker.finallyEnd((int)1);
        }
    }

    @NotNull
    public final String jobToString(@NotNull Job job) {
        return DebugProbesImpl.INSTANCE.hierarchyToString(job);
    }

    @NotNull
    public final String scopeToString(@NotNull CoroutineScope scope) {
        Job job = (Job)scope.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
        if (job == null) {
            String string = "Job is not present in the scope";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.jobToString(job);
    }

    public final void printJob(@NotNull Job job, @NotNull PrintStream out) {
        out.println(DebugProbesImpl.INSTANCE.hierarchyToString(job));
    }

    public static /* synthetic */ void printJob$default(DebugProbes debugProbes, Job job, PrintStream printStream, int n, Object object) {
        if ((n & 2) != 0) {
            printStream = System.out;
        }
        debugProbes.printJob(job, printStream);
    }

    public final void printScope(@NotNull CoroutineScope scope, @NotNull PrintStream out) {
        Job job = (Job)scope.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
        if (job == null) {
            String string = "Job is not present in the scope";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.printJob(job, out);
    }

    public static /* synthetic */ void printScope$default(DebugProbes debugProbes, CoroutineScope coroutineScope, PrintStream printStream, int n, Object object) {
        if ((n & 2) != 0) {
            printStream = System.out;
        }
        debugProbes.printScope(coroutineScope, printStream);
    }

    @NotNull
    public final List<CoroutineInfo> dumpCoroutinesInfo() {
        return DebugProbesImpl.INSTANCE.dumpCoroutinesInfo();
    }

    public final void dumpCoroutines(@NotNull PrintStream out) {
        DebugProbesImpl.INSTANCE.dumpCoroutines(out);
    }

    public static /* synthetic */ void dumpCoroutines$default(DebugProbes debugProbes, PrintStream printStream, int n, Object object) {
        if ((n & 1) != 0) {
            printStream = System.out;
        }
        debugProbes.dumpCoroutines(printStream);
    }

    private DebugProbes() {
    }

    static {
        DebugProbes debugProbes;
        INSTANCE = debugProbes = new DebugProbes();
        sanitizeStackTraces = true;
        enableCreationStackTraces = true;
    }
}

