/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.guava;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.guava.DeferredListenableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\r\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001b\u0010\u001c\u001a\u00028\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0002\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u0013H\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006 "}, d2={"Lkotlinx/coroutines/guava/OuterFuture;", "T", "Lcom/google/common/util/concurrent/ListenableFuture;", "deferred", "Lkotlinx/coroutines/Deferred;", "(Lkotlinx/coroutines/Deferred;)V", "innerFuture", "Lkotlinx/coroutines/guava/DeferredListenableFuture;", "getInnerFuture", "()Lkotlinx/coroutines/guava/DeferredListenableFuture;", "addListener", "", "listener", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "executor", "Ljava/util/concurrent/Executor;", "afterInit", "cancel", "", "mayInterruptIfRunning", "get", "()Ljava/lang/Object;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getInternal", "(Lkotlinx/coroutines/Deferred;)Ljava/lang/Object;", "isCancelled", "isDone", "kotlinx-coroutines-guava"})
final class OuterFuture<T>
implements ListenableFuture<T> {
    @NotNull
    private final DeferredListenableFuture<T> innerFuture;
    private final Deferred<T> deferred;

    @NotNull
    public final DeferredListenableFuture<T> getInnerFuture() {
        return this.innerFuture;
    }

    public final void afterInit() {
        this.deferred.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ OuterFuture this$0;

            public final void invoke(@Nullable Throwable it) {
                this.this$0.getInnerFuture().complete();
            }
            {
                this.this$0 = outerFuture;
                super(1);
            }
        });
    }

    public boolean isCancelled() {
        return this.isDone() && (this.innerFuture.isCancelled() || this.deferred.getCompletionExceptionOrNull() instanceof CancellationException);
    }

    public T get() {
        Object object = this.innerFuture.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"innerFuture.get()");
        return this.getInternal((Deferred)object);
    }

    public T get(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        Object object = this.innerFuture.get(timeout, unit);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"innerFuture.get(timeout, unit)");
        return this.getInternal((Deferred)object);
    }

    private final T getInternal(Deferred<? extends T> deferred) {
        if (deferred.isCancelled()) {
            Throwable exception = deferred.getCompletionExceptionOrNull();
            if (exception instanceof CancellationException) {
                throw exception;
            }
            throw (Throwable)new ExecutionException(exception);
        }
        return (T)deferred.getCompleted();
    }

    public void addListener(@NotNull Runnable listener, @NotNull Executor executor) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        this.innerFuture.addListener(listener, executor);
    }

    public boolean isDone() {
        return this.innerFuture.isDone();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.innerFuture.cancel(mayInterruptIfRunning);
    }

    public OuterFuture(@NotNull Deferred<? extends T> deferred) {
        Intrinsics.checkParameterIsNotNull(deferred, (String)"deferred");
        this.deferred = deferred;
        this.innerFuture = new DeferredListenableFuture<T>(this.deferred);
    }
}

